import {
    defineConfig
} from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from "@tailwindcss/vite";
import forms from '@tailwindcss/forms';
import typography from '@tailwindcss/typography';

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js'],
            refresh: true,
        }),
        tailwindcss({
            config: {
                plugins: [forms, typography]
            }
        }),
    ],
    server: {
        cors: true,
    },
});