<?php $__env->startSection('title', 'Server Error'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Error Header -->
    <div class="text-center">
        <div class="mx-auto h-20 w-20 bg-red-100 rounded-full flex items-center justify-center mb-4">
            <svg class="h-10 w-10 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
        </div>
        <h1 class="text-5xl font-bold text-gray-900 mb-2">500</h1>
        <h2 class="text-xl font-semibold text-gray-800 mb-2">Internal Server Error</h2>
        <p class="text-gray-600">We're experiencing technical difficulties. Our team has been notified.</p>
    </div>

    <!-- Error Details Card -->
    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-red-100 text-red-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">⚠</span>
            What happened?
        </h3>
        <div class="space-y-3 text-sm text-gray-600">
            <p>• Our servers encountered an unexpected error</p>
            <p>• This is a temporary issue that we're working to fix</p>
            <p>• Your data and account are safe and secure</p>
        </div>
    </div>

    <!-- Action Card -->
    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">🔄</span>
            What can you do?
        </h3>
        <div class="space-y-4">
            <div class="flex flex-col sm:flex-row gap-3">
                <button onclick="window.location.reload()" 
                        class="flex-1 inline-flex items-center justify-center px-4 py-3 border border-transparent text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                    </svg>
                    Try Again
                </button>
                <a href="<?php echo e(route('dashboard')); ?>" 
                   class="flex-1 inline-flex items-center justify-center px-4 py-3 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Go to Dashboard
                </a>
            </div>
        </div>
    </div>

    <!-- Status Information -->
    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
        <div class="flex items-start">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-yellow-800">Service Status</h3>
                <div class="mt-2 text-sm text-yellow-700">
                    <p>If this problem persists, please contact our support team with the error code:</p>
                    <p class="mt-1 font-mono font-semibold bg-yellow-100 px-2 py-1 rounded">ERR-<?php echo e(date('YmdHis')); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Help Section -->
    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
        <div class="flex items-start">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">Need immediate assistance?</h3>
                <div class="mt-2 text-sm text-blue-700">
                    <p>Our technical team is working to resolve this issue. Contact us if you need urgent help.</p>
                    <div class="mt-2 flex space-x-4">
                        <a href="#" class="font-medium hover:text-blue-600">Contact Support</a>
                        <a href="#" class="font-medium hover:text-blue-600">Status Page</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('errors.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/sbrbot/pay.sbrbot.trading/resources/views/errors/500.blade.php ENDPATH**/ ?>