<!-- Main Header -->
<header class="bg-[#1e3a8a] text-white relative z-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-20">
            <!-- Logo -->
            <div class="flex-shrink-0">
                <a href="/" class="flex items-center">
                    <div class="flex items-center space-x-3">
                        <!-- Bank Logo -->
                        <img src="<?php echo e(\App\Helpers\SettingsHelper::bankLogo()); ?>" alt="<?php echo e(\App\Helpers\SettingsHelper::bankName()); ?>" class="h-14 w-auto filter brightness-0 invert">
                    </div>
                </a>
            </div>
            
            <!-- Desktop Navigation -->
            <nav class="hidden md:flex items-center space-x-8">
                <a href="/" class="text-white font-bold hover:text-green-400 transition-colors">Home</a>
                <a href="<?php echo e(route('about-us')); ?>" class="text-white font-bold hover:text-green-400 transition-colors">About Us</a>
                
                <!-- Personal Banking Dropdown -->
                <div class="relative group">
                    <button class="text-white font-bold hover:text-green-400 transition-colors flex items-center space-x-1">
                        <span>Personal Banking</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="absolute left-0 mt-2 w-48 bg-white rounded-md shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                        <div class="py-1">
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Savings</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Checking</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Investment & Retirement</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Credit Card</a>
                        </div>
                    </div>
                </div>
                
                <!-- Business Banking Dropdown -->
                <div class="relative group">
                    <button class="text-white font-bold hover:text-green-400 transition-colors flex items-center space-x-1">
                        <span>Business Banking</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="absolute left-0 mt-2 w-48 bg-white rounded-md shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                        <div class="py-1">
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Savings Account</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Checking</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Lending</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Credit Card</a>
                        </div>
                    </div>
                </div>
                
                <a href="<?php echo e(route('contact')); ?>" class="text-white font-bold hover:text-green-400 transition-colors">Contact Us</a>
                <a href="<?php echo e(route('login')); ?>" class="bg-[#465ba9] text-white px-6 py-2 rounded-md font-bold transition-colors">
                    Login
                </a>
            </nav>
            
            <!-- Mobile menu button -->
            <div class="md:hidden">
                <button type="button" class="text-white hover:text-[#465ba9] focus:outline-none focus:text-[#465ba9]" onclick="toggleMobileMenu()">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>
    
    <!-- Mobile Navigation -->
    <div id="mobile-menu" class="md:hidden hidden bg-[#1e3a8a] border-t">
        <div class="px-4 py-4 space-y-2">
            <a href="/" class="block px-3 py-2 text-white font-bold">Home</a>
            <a href="<?php echo e(route('about-us')); ?>" class="block px-3 py-2 text-white hover:text-green-400">About Us</a>
            <a href="#" class="block px-3 py-2 text-white hover:text-green-400">Personal Banking</a>
            <a href="#" class="block px-3 py-2 text-white hover:text-green-400">Business Banking</a>
            <a href="<?php echo e(route('contact')); ?>" class="block px-3 py-2 text-white hover:text-green-400">Contact Us</a>
            <a href="<?php echo e(route('login')); ?>" class="block px-3 py-2 bg-[#465ba9] text-white rounded-md font-bold text-center">
                Login
            </a>
        </div>
    </div>
</header>

<!-- Sticky Header (Hidden by default) -->
<header id="sticky-header" class="bg-white shadow-lg fixed top-0 left-0 right-0 z-50 hidden">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            <!-- Logo -->
            <div class="flex-shrink-0">
                <a href="/" class="flex items-center">
                    <img src="<?php echo e(\App\Helpers\SettingsHelper::bankLogo()); ?>" alt="<?php echo e(\App\Helpers\SettingsHelper::bankName()); ?>" class="h-14 w-auto">
                </a>
            </div>
            
            <!-- Desktop Navigation -->
            <nav class="hidden md:flex items-center space-x-8">
                <a href="/" class="text-[#1e3a8a] font-bold hover:text-green-600 transition-colors">Home</a>
                <a href="<?php echo e(route('about-us')); ?>" class="text-gray-700 hover:text-[#1e3a8a] transition-colors">About Us</a>
                
                <!-- Personal Banking Dropdown -->
                <div class="relative group">
                    <button class="text-gray-700 hover:text-[#1e3a8a] transition-colors flex items-center space-x-1">
                        <span>Personal Banking</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="absolute left-0 mt-2 w-48 bg-white rounded-md shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                        <div class="py-1">
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Savings</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Checking</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Investment & Retirement</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Credit Card</a>
                        </div>
                    </div>
                </div>
                
                <!-- Business Banking Dropdown -->
                <div class="relative group">
                    <button class="text-gray-700 hover:text-[#1e3a8a] transition-colors flex items-center space-x-1">
                        <span>Business Banking</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="absolute left-0 mt-2 w-48 bg-white rounded-md shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                        <div class="py-1">
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Savings Account</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Checking</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Lending</a>
                            <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Credit Card</a>
                        </div>
                    </div>
                </div>
                
                <a href="<?php echo e(route('contact')); ?>" class="text-gray-700 hover:text-[#1e3a8a] transition-colors">Contact Us</a>
                <a href="<?php echo e(route('login')); ?>" class="bg-[#1e3a8a] text-white px-6 py-2 rounded-md font-bold hover:bg-blue-800 transition-colors">
                    Login
                </a>
            </nav>
            
            <!-- Mobile menu button -->
            <div class="md:hidden">
                <button type="button" class="text-gray-700 hover:text-[#1e3a8a] focus:outline-none focus:text-[#1e3a8a]" onclick="toggleMobileMenu()">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>
</header>
<?php /**PATH /home/sbrbot/pay.sbrbot.trading/resources/views/components/public/header.blade.php ENDPATH**/ ?>