<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo e(\App\Helpers\SettingsHelper::bankName()); ?> - Your trusted financial partner for personal and business banking solutions">
    <meta name="keywords" content="banking, personal banking, business banking, loans, savings, checking">
    <meta name="author" content="<?php echo e(\App\Helpers\SettingsHelper::bankName()); ?>">
    <title><?php echo $__env->yieldContent('title', \App\Helpers\SettingsHelper::bankName() . ' - Banking Solutions Built for You'); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>" type="image/x-icon">
    
    <!-- Vite Assets -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <!-- Google Fonts - Saira -->
    <link href="https://fonts.googleapis.com/css2?family=Saira:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        body, h1, h2, h3, h4, h5, h6, p, a, span, div {
            font-family: 'Saira', sans-serif;
        }
    </style>
</head>
<body class="bg-white">
    <?php echo $__env->make('components.public.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    
    <?php echo $__env->make('components.public.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <!-- JavaScript -->
    <script>
        function toggleMobileMenu() {
            const mobileMenu = document.getElementById('mobile-menu');
            mobileMenu.classList.toggle('hidden');
        }
        
        // Sticky header functionality
        window.addEventListener('scroll', function() {
            const stickyHeader = document.getElementById('sticky-header');
            const scrollPosition = window.scrollY;
            
            if (scrollPosition > 100) {
                stickyHeader.classList.remove('hidden');
            } else {
                stickyHeader.classList.add('hidden');
            }
        });
        
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home/sbrbot/pay.sbrbot.trading/resources/views/layouts/public.blade.php ENDPATH**/ ?>