<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Livewire\Auth\ProfileCompletion;
use App\Livewire\Auth\AccountCreation;
use App\Livewire\User\ProfileSettings;
use App\Livewire\User\AccountManagement;
use App\Livewire\User\SecuritySettings;
use App\Livewire\User\Banking\KycVerification;
use App\Livewire\User\Banking\LocalTransfer;
use App\Livewire\User\Banking\InternationalTransfer;
use App\Livewire\User\Banking\BeneficiaryManagement;
use App\Livewire\User\Banking\CodeVerification;
use App\Livewire\User\Banking\TransferSuccess;
use App\Livewire\User\Banking\ChequeDeposit;
use App\Livewire\User\Banking\DepositHistory;
use App\Livewire\User\InterAccountTransfer;
use App\Livewire\User\AccountHistory;
use App\Livewire\User\AccountStatement;

Route::get('/', function () {
    return view('welcome');
})->name('home');

Route::get('/about-us', function () {
    return view('about-us');
})->name('about-us');

Route::get('/contact', [App\Http\Controllers\ContactController::class, 'index'])->name('contact');
Route::post('/contact', [App\Http\Controllers\ContactController::class, 'store'])->name('contact.store');

Route::get('/privacy-policy', function () {
    return view('privacy-policy');
})->name('privacy-policy');

// Profile completion route (must be accessible without profile completion middleware)
Route::get('profile/complete', ProfileCompletion::class)
    ->middleware(['auth', 'verified'])
    ->name('profile.complete');

// Account creation route (accessible after profile completion)
Route::get('account/create', AccountCreation::class)
    ->middleware(['auth', 'verified'])
    ->name('account.create');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified', 'profile.complete'])
    ->name('dashboard');
    
Route::middleware(['auth', 'profile.complete'])->group(function () {
    // Banking Routes
    Route::prefix('user')->name('user.')->group(function () {
        // Account Management
        Route::get('account/history', AccountHistory::class)->name('account.history');
        Route::get('account/statements', AccountStatement::class)->name('account.statements');
        Route::get('account/settings', AccountManagement::class)->name('account.settings');

        Route::middleware(['kyc.required'])->group(function () {
            // Fund Transfer
            Route::get('transfer/local', LocalTransfer::class)->name('transfer.local');
            Route::get('transfer/international', InternationalTransfer::class)->name('transfer.international');
            Route::get('transfer/code-verification', CodeVerification::class)->name('transfer.code-verification');
            Route::get('transfer/success/{transaction}', TransferSuccess::class)->name('transfer.success');
            
            // Deposits
            Route::get('deposit/cheque', ChequeDeposit::class)->name('deposit.cheque');
            Route::get('deposit/history', DepositHistory::class)->name('deposit.history');
        });

        // Inter-Account Transfer
        Route::get('transfer/inter-account', InterAccountTransfer::class)->name('transfer.inter-account');

        // Beneficiaries
        Route::get('beneficiaries', BeneficiaryManagement::class)->name('beneficiaries');
        
        // User Management
        Route::get('profile', ProfileSettings::class)->name('profile');
        Route::get('kyc-verification', KycVerification::class)->name('kyc-verification');
        
        // Security & Settings
        Route::get('preferences', SecuritySettings::class)->name('preferences');
    });
});

Route::middleware(['auth'])->group(function () {
    Route::impersonate();
});

// Include admin routes
require __DIR__.'/admin-auth.php';
require __DIR__.'/admin.php';

require __DIR__.'/auth.php';

// Passkey routes
Route::passkeys();
