<?php

use Illuminate\Support\Facades\Route;

// Admin Routes - Require admin authentication
Route::middleware(['auth', 'admin.auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::get('dashboard/analytics', [App\Http\Controllers\Admin\DashboardController::class, 'analytics'])->name('dashboard.analytics');
    
    // Users Management
    Route::get('users', [App\Http\Controllers\Admin\UserController::class, 'index'])->name('users.index');
    Route::get('users/create', [App\Http\Controllers\Admin\UserController::class, 'create'])->name('users.create');
    Route::post('users', [App\Http\Controllers\Admin\UserController::class, 'store'])->name('users.store');
    Route::get('users/{user}', [App\Http\Controllers\Admin\UserController::class, 'show'])->name('users.show');
    Route::get('users/{user}/edit', [App\Http\Controllers\Admin\UserController::class, 'edit'])->name('users.edit');
    Route::put('users/{user}', [App\Http\Controllers\Admin\UserController::class, 'update'])->name('users.update');
    Route::delete('users/{user}', [App\Http\Controllers\Admin\UserController::class, 'destroy'])->name('users.destroy');
    
    // User Actions
    Route::post('users/{user}/activate', [App\Http\Controllers\Admin\UserController::class, 'activate'])->name('users.activate');
    Route::post('users/{user}/suspend', [App\Http\Controllers\Admin\UserController::class, 'suspend'])->name('users.suspend');
    Route::post('users/{user}/reset-password', [App\Http\Controllers\Admin\UserController::class, 'resetPassword'])->name('users.reset-password');
    Route::get('users/export', [App\Http\Controllers\Admin\UserController::class, 'export'])->name('users.export');
    
    // Accounts Management
    Route::get('accounts', [App\Http\Controllers\Admin\AccountController::class, 'index'])->name('accounts.index');
    Route::get('accounts/create', [App\Http\Controllers\Admin\AccountController::class, 'create'])->name('accounts.create');
    Route::post('accounts', [App\Http\Controllers\Admin\AccountController::class, 'store'])->name('accounts.store');
    Route::get('accounts/{account}', [App\Http\Controllers\Admin\AccountController::class, 'show'])->name('accounts.show');
    Route::get('accounts/{account}/edit', [App\Http\Controllers\Admin\AccountController::class, 'edit'])->name('accounts.edit');
    Route::put('accounts/{account}', [App\Http\Controllers\Admin\AccountController::class, 'update'])->name('accounts.update');
    Route::delete('accounts/{account}', [App\Http\Controllers\Admin\AccountController::class, 'destroy'])->name('accounts.destroy');
    
    // Account actions
    Route::post('accounts/{account}/suspend', [App\Http\Controllers\Admin\AccountController::class, 'suspend'])->name('accounts.suspend');
    Route::post('accounts/{account}/activate', [App\Http\Controllers\Admin\AccountController::class, 'activate'])->name('accounts.activate');
    Route::post('accounts/{account}/close', [App\Http\Controllers\Admin\AccountController::class, 'close'])->name('accounts.close');
    Route::post('accounts/{account}/transaction', [App\Http\Controllers\Admin\AccountController::class, 'transaction'])->name('accounts.transaction');
    
    // Virtual Cards Management
    Route::get('virtual-cards', [App\Http\Controllers\Admin\VirtualCardController::class, 'index'])->name('virtual-cards.index');
    Route::get('virtual-cards/create', [App\Http\Controllers\Admin\VirtualCardController::class, 'create'])->name('virtual-cards.create');
    Route::post('virtual-cards', [App\Http\Controllers\Admin\VirtualCardController::class, 'store'])->name('virtual-cards.store');
    Route::get('virtual-cards/{virtualCard}', [App\Http\Controllers\Admin\VirtualCardController::class, 'show'])->name('virtual-cards.show');
    Route::get('virtual-cards/{virtualCard}/edit', [App\Http\Controllers\Admin\VirtualCardController::class, 'edit'])->name('virtual-cards.edit');
    Route::put('virtual-cards/{virtualCard}', [App\Http\Controllers\Admin\VirtualCardController::class, 'update'])->name('virtual-cards.update');
    Route::delete('virtual-cards/{virtualCard}', [App\Http\Controllers\Admin\VirtualCardController::class, 'destroy'])->name('virtual-cards.destroy');
    
    // Virtual Card Actions
    Route::post('virtual-cards/{virtualCard}/block', [App\Http\Controllers\Admin\VirtualCardController::class, 'block'])->name('virtual-cards.block');
    Route::post('virtual-cards/{virtualCard}/unblock', [App\Http\Controllers\Admin\VirtualCardController::class, 'unblock'])->name('virtual-cards.unblock');
    Route::post('virtual-cards/{virtualCard}/activate', [App\Http\Controllers\Admin\VirtualCardController::class, 'activate'])->name('virtual-cards.activate');
    Route::post('virtual-cards/{virtualCard}/deactivate', [App\Http\Controllers\Admin\VirtualCardController::class, 'deactivate'])->name('virtual-cards.deactivate');
    Route::post('virtual-cards/{virtualCard}/regenerate-cvv', [App\Http\Controllers\Admin\VirtualCardController::class, 'regenerateCvv'])->name('virtual-cards.regenerate-cvv');
    Route::get('virtual-cards/statistics', [App\Http\Controllers\Admin\VirtualCardController::class, 'statistics'])->name('virtual-cards.statistics');
    
    // Transactions Management
    Route::get('transactions', [App\Http\Controllers\Admin\TransactionController::class, 'index'])->name('transactions.index');
    Route::get('transactions/create', [App\Http\Controllers\Admin\TransactionController::class, 'create'])->name('transactions.create');
    Route::post('transactions', [App\Http\Controllers\Admin\TransactionController::class, 'store'])->name('transactions.store');
    Route::get('transactions/{transaction}', [App\Http\Controllers\Admin\TransactionController::class, 'show'])->name('transactions.show');
    Route::get('transactions/{transaction}/edit', [App\Http\Controllers\Admin\TransactionController::class, 'edit'])->name('transactions.edit');
    Route::put('transactions/{transaction}', [App\Http\Controllers\Admin\TransactionController::class, 'update'])->name('transactions.update');
    Route::delete('transactions/{transaction}', [App\Http\Controllers\Admin\TransactionController::class, 'destroy'])->name('transactions.destroy');
    
    // Transaction actions
    Route::post('transactions/{transaction}/approve', [App\Http\Controllers\Admin\TransactionController::class, 'approve'])->name('transactions.approve');
    Route::post('transactions/{transaction}/reject', [App\Http\Controllers\Admin\TransactionController::class, 'reject'])->name('transactions.reject');
    Route::post('transactions/{transaction}/reverse', [App\Http\Controllers\Admin\TransactionController::class, 'reverse'])->name('transactions.reverse');
    
    // Transfers Management
    Route::get('transfers', [App\Http\Controllers\Admin\TransferController::class, 'index'])->name('transfers.index');
    Route::get('transfers/create', [App\Http\Controllers\Admin\TransferController::class, 'create'])->name('transfers.create');
    Route::post('transfers', [App\Http\Controllers\Admin\TransferController::class, 'store'])->name('transfers.store');
    Route::get('transfers/{transfer}', [App\Http\Controllers\Admin\TransferController::class, 'show'])->name('transfers.show');
    Route::get('transfers/{transfer}/edit', [App\Http\Controllers\Admin\TransferController::class, 'edit'])->name('transfers.edit');
    Route::put('transfers/{transfer}', [App\Http\Controllers\Admin\TransferController::class, 'update'])->name('transfers.update');
    Route::delete('transfers/{transfer}', [App\Http\Controllers\Admin\TransferController::class, 'destroy'])->name('transfers.destroy');
    
    // Transfer actions
    Route::post('transfers/{transfer}/approve', [App\Http\Controllers\Admin\TransferController::class, 'approve'])->name('transfers.approve');
    Route::post('transfers/{transfer}/reject', [App\Http\Controllers\Admin\TransferController::class, 'reject'])->name('transfers.reject');
    Route::post('transfers/{transfer}/reverse', [App\Http\Controllers\Admin\TransferController::class, 'reverse'])->name('transfers.reverse');
    Route::post('transfers/{transfer}/mark-arrived', [App\Http\Controllers\Admin\TransferController::class, 'markArrived'])->name('transfers.mark-arrived');
    
    // Transfer statistics
    Route::get('transfers-statistics', [App\Http\Controllers\Admin\TransferController::class, 'statistics'])->name('transfers.statistics');
    
    // Credit/Debit Management
    Route::get('credit-debit', [App\Http\Controllers\Admin\CreditDebitController::class, 'index'])->name('credit-debit.index');
    Route::post('credit-debit/{account}/transaction', [App\Http\Controllers\Admin\CreditDebitController::class, 'transaction'])->name('credit-debit.transaction');
    
    // Deposits Management
    Route::get('deposits', [App\Http\Controllers\Admin\DepositController::class, 'index'])->name('deposits.index');
    Route::get('deposits/create', [App\Http\Controllers\Admin\DepositController::class, 'create'])->name('deposits.create');
    Route::post('deposits', [App\Http\Controllers\Admin\DepositController::class, 'store'])->name('deposits.store');
    Route::get('deposits/{deposit}', [App\Http\Controllers\Admin\DepositController::class, 'show'])->name('deposits.show');
    Route::get('deposits/{deposit}/edit', [App\Http\Controllers\Admin\DepositController::class, 'edit'])->name('deposits.edit');
    Route::put('deposits/{deposit}', [App\Http\Controllers\Admin\DepositController::class, 'update'])->name('deposits.update');
    Route::delete('deposits/{deposit}', [App\Http\Controllers\Admin\DepositController::class, 'destroy'])->name('deposits.destroy');
    
    // Deposit actions
    Route::post('deposits/{deposit}/approve', [App\Http\Controllers\Admin\DepositController::class, 'approve'])->name('deposits.approve');
    Route::post('deposits/{deposit}/reject', [App\Http\Controllers\Admin\DepositController::class, 'reject'])->name('deposits.reject');
    Route::post('deposits/{deposit}/reverse', [App\Http\Controllers\Admin\DepositController::class, 'reverse'])->name('deposits.reverse');
    
    // Deposit statistics
    Route::get('deposits-statistics', [App\Http\Controllers\Admin\DepositController::class, 'statistics'])->name('deposits.statistics');
    
    // Withdrawals Management
    Route::view('withdrawals', 'admin.withdrawals.index')->name('withdrawals.index');
    Route::view('withdrawals/create', 'admin.withdrawals.create')->name('withdrawals.create');
    Route::view('withdrawals/{withdrawal}', 'admin.withdrawals.show')->name('withdrawals.show');
    Route::view('withdrawals/{withdrawal}/edit', 'admin.withdrawals.edit')->name('withdrawals.edit');
    
    
    // KYC Management
    Route::get('kyc', [App\Http\Controllers\Admin\KycController::class, 'index'])->name('kyc.index');
    Route::get('kyc/{kyc}', [App\Http\Controllers\Admin\KycController::class, 'show'])->name('kyc.show');
    Route::get('kyc/{kyc}/edit', [App\Http\Controllers\Admin\KycController::class, 'edit'])->name('kyc.edit');
    Route::put('kyc/{kyc}', [App\Http\Controllers\Admin\KycController::class, 'update'])->name('kyc.update');
    Route::delete('kyc/{kyc}', [App\Http\Controllers\Admin\KycController::class, 'destroy'])->name('kyc.destroy');

    // KYC actions
    Route::post('kyc/{kyc}/approve', [App\Http\Controllers\Admin\KycController::class, 'approve'])->name('kyc.approve');
    Route::post('kyc/{kyc}/reject', [App\Http\Controllers\Admin\KycController::class, 'reject'])->name('kyc.reject');
    Route::get('kyc/{kyc}/download', [App\Http\Controllers\Admin\KycController::class, 'download'])->name('kyc.download');
    Route::get('kyc/{kyc}/view', [App\Http\Controllers\Admin\KycController::class, 'view'])->name('kyc.view');

    // KYC bulk actions
    Route::post('kyc/bulk-approve', [App\Http\Controllers\Admin\KycController::class, 'bulkApprove'])->name('kyc.bulk-approve');

    // KYC statistics
    Route::get('kyc-statistics', [App\Http\Controllers\Admin\KycController::class, 'statistics'])->name('kyc.statistics');

    // Compliance Management
    Route::resource('compliance', App\Http\Controllers\Admin\ComplianceController::class);
    Route::post('compliance/{compliance}/approve', [App\Http\Controllers\Admin\ComplianceController::class, 'approve'])->name('compliance.approve');
    Route::post('compliance/{compliance}/reject', [App\Http\Controllers\Admin\ComplianceController::class, 'reject'])->name('compliance.reject');
    Route::post('compliance/{compliance}/escalate', [App\Http\Controllers\Admin\ComplianceController::class, 'escalate'])->name('compliance.escalate');
    Route::post('compliance/bulk-approve', [App\Http\Controllers\Admin\ComplianceController::class, 'bulkApprove'])->name('compliance.bulk-approve');
    Route::post('compliance/aml-monitor', [App\Http\Controllers\Admin\ComplianceController::class, 'amlMonitor'])->name('compliance.aml-monitor');
    Route::get('compliance-statistics', [App\Http\Controllers\Admin\ComplianceController::class, 'statistics'])->name('compliance.statistics');
    
    // Reports
    Route::get('reports', [App\Http\Controllers\Admin\ReportController::class, 'index'])->name('reports.index');
    Route::get('reports/users', [App\Http\Controllers\Admin\ReportController::class, 'users'])->name('reports.users');
    Route::get('reports/accounts', [App\Http\Controllers\Admin\ReportController::class, 'accounts'])->name('reports.accounts');
    Route::get('reports/transactions', [App\Http\Controllers\Admin\ReportController::class, 'transactions'])->name('reports.transactions');
    Route::get('reports/kyc', [App\Http\Controllers\Admin\ReportController::class, 'kyc'])->name('reports.kyc');
    Route::get('reports/compliance', [App\Http\Controllers\Admin\ReportController::class, 'compliance'])->name('reports.compliance');
    
    // Export routes
    Route::get('reports/export/users', [App\Http\Controllers\Admin\ReportController::class, 'exportUsers'])->name('reports.export.users');
    Route::get('reports/export/accounts', [App\Http\Controllers\Admin\ReportController::class, 'exportAccounts'])->name('reports.export.accounts');
    Route::get('reports/export/transactions', [App\Http\Controllers\Admin\ReportController::class, 'exportTransactions'])->name('reports.export.transactions');
    Route::get('reports/export/kyc', [App\Http\Controllers\Admin\ReportController::class, 'exportKyc'])->name('reports.export.kyc');
    Route::get('reports/export/compliance', [App\Http\Controllers\Admin\ReportController::class, 'exportCompliance'])->name('reports.export.compliance');
    
    // Analytics
    Route::get('analytics', [App\Http\Controllers\Admin\AnalyticsController::class, 'index'])->name('analytics.index');
    Route::get('analytics/users', [App\Http\Controllers\Admin\AnalyticsController::class, 'users'])->name('analytics.users');
    Route::get('analytics/transactions', [App\Http\Controllers\Admin\AnalyticsController::class, 'transactions'])->name('analytics.transactions');
    Route::get('analytics/accounts', [App\Http\Controllers\Admin\AnalyticsController::class, 'accounts'])->name('analytics.accounts');
    Route::get('analytics/kyc', [App\Http\Controllers\Admin\AnalyticsController::class, 'kyc'])->name('analytics.kyc');
    Route::get('analytics/compliance', [App\Http\Controllers\Admin\AnalyticsController::class, 'compliance'])->name('analytics.compliance');
    
    // Analytics API endpoints
    Route::get('analytics/api/real-time-metrics', [App\Http\Controllers\Admin\AnalyticsController::class, 'realTimeMetrics'])->name('analytics.api.real-time-metrics');
    Route::get('analytics/api/user-growth', [App\Http\Controllers\Admin\AnalyticsController::class, 'userGrowthData'])->name('analytics.api.user-growth');
    Route::get('analytics/api/transaction-volume', [App\Http\Controllers\Admin\AnalyticsController::class, 'transactionVolumeData'])->name('analytics.api.transaction-volume');
    Route::get('analytics/api/account-creation', [App\Http\Controllers\Admin\AnalyticsController::class, 'accountCreationData'])->name('analytics.api.account-creation');
    Route::get('analytics/api/kyc-submission', [App\Http\Controllers\Admin\AnalyticsController::class, 'kycSubmissionData'])->name('analytics.api.kyc-submission');
    Route::get('analytics/api/compliance-flags', [App\Http\Controllers\Admin\AnalyticsController::class, 'complianceFlagData'])->name('analytics.api.compliance-flags');

    // Settings
    Route::get('settings', [App\Http\Controllers\Admin\SettingController::class, 'index'])->name('settings.index');
    Route::get('settings/bank', [App\Http\Controllers\Admin\SettingController::class, 'bank'])->name('settings.bank');
    Route::post('settings/bank', [App\Http\Controllers\Admin\SettingController::class, 'updateBank'])->name('settings.bank.update');
    Route::get('settings/limits', [App\Http\Controllers\Admin\SettingController::class, 'limits'])->name('settings.limits');
    Route::post('settings/limits', [App\Http\Controllers\Admin\SettingController::class, 'updateLimits'])->name('settings.limits.update');
    Route::get('settings/compliance', [App\Http\Controllers\Admin\SettingController::class, 'compliance'])->name('settings.compliance');
    Route::post('settings/compliance', [App\Http\Controllers\Admin\SettingController::class, 'updateCompliance'])->name('settings.compliance.update');
    Route::get('settings/notifications', [App\Http\Controllers\Admin\SettingController::class, 'notifications'])->name('settings.notifications');
    Route::post('settings/notifications', [App\Http\Controllers\Admin\SettingController::class, 'updateNotifications'])->name('settings.notifications.update');
    Route::post('settings/test-smtp', [App\Http\Controllers\Admin\SettingController::class, 'testSmtp'])->name('settings.test-smtp');
    Route::get('settings/system', [App\Http\Controllers\Admin\SettingController::class, 'system'])->name('settings.system');
    Route::post('settings/system', [App\Http\Controllers\Admin\SettingController::class, 'updateSystem'])->name('settings.system.update');
    Route::post('settings/optimize-clear', [App\Http\Controllers\Admin\SettingController::class, 'optimizeClear'])->name('settings.optimize-clear');
    Route::post('settings/storage-link', [App\Http\Controllers\Admin\SettingController::class, 'storageLink'])->name('settings.storage-link');
    
    // Settings API endpoints
    Route::post('settings/test-email', [App\Http\Controllers\Admin\SettingController::class, 'testEmail'])->name('settings.test-email');
    Route::post('settings/test-sms', [App\Http\Controllers\Admin\SettingController::class, 'testSms'])->name('settings.test-sms');
    Route::post('settings/reset', [App\Http\Controllers\Admin\SettingController::class, 'reset'])->name('settings.reset');
});

// Super Admin Only Routes
Route::middleware(['auth', 'admin.auth', 'role:super-admin', 'impersonate.protect'])->prefix('admin')->name('admin.')->group(function () {
    // Roles Management
    Route::get('roles', [App\Http\Controllers\Admin\RoleController::class, 'index'])->name('roles.index');
    Route::get('roles/create', [App\Http\Controllers\Admin\RoleController::class, 'create'])->name('roles.create');
    Route::post('roles', [App\Http\Controllers\Admin\RoleController::class, 'store'])->name('roles.store');
    Route::get('roles/{role}', [App\Http\Controllers\Admin\RoleController::class, 'show'])->name('roles.show');
    Route::get('roles/{role}/edit', [App\Http\Controllers\Admin\RoleController::class, 'edit'])->name('roles.edit');
    Route::put('roles/{role}', [App\Http\Controllers\Admin\RoleController::class, 'update'])->name('roles.update');
    Route::delete('roles/{role}', [App\Http\Controllers\Admin\RoleController::class, 'destroy'])->name('roles.destroy');
    Route::get('roles/statistics', [App\Http\Controllers\Admin\RoleController::class, 'statistics'])->name('roles.statistics');
    
    // Role Actions
    Route::post('roles/{role}/assign-user', [App\Http\Controllers\Admin\RoleController::class, 'assignToUser'])->name('roles.assign-user');
    Route::delete('roles/{role}/remove-user/{userId}', [App\Http\Controllers\Admin\RoleController::class, 'removeFromUser'])->name('roles.remove-user');
    
    // Permissions Management
    Route::get('permissions', [App\Http\Controllers\Admin\PermissionController::class, 'index'])->name('permissions.index');
    Route::get('permissions/create', [App\Http\Controllers\Admin\PermissionController::class, 'create'])->name('permissions.create');
    Route::post('permissions', [App\Http\Controllers\Admin\PermissionController::class, 'store'])->name('permissions.store');
    Route::get('permissions/{permission}', [App\Http\Controllers\Admin\PermissionController::class, 'show'])->name('permissions.show');
    Route::get('permissions/{permission}/edit', [App\Http\Controllers\Admin\PermissionController::class, 'edit'])->name('permissions.edit');
    Route::put('permissions/{permission}', [App\Http\Controllers\Admin\PermissionController::class, 'update'])->name('permissions.update');
    Route::delete('permissions/{permission}', [App\Http\Controllers\Admin\PermissionController::class, 'destroy'])->name('permissions.destroy');
    Route::get('permissions/statistics', [App\Http\Controllers\Admin\PermissionController::class, 'statistics'])->name('permissions.statistics');
    
    // Permission Actions
    Route::post('permissions/bulk-assign-role', [App\Http\Controllers\Admin\PermissionController::class, 'bulkAssignToRole'])->name('permissions.bulk-assign-role');
    Route::post('permissions/bulk-remove-role', [App\Http\Controllers\Admin\PermissionController::class, 'bulkRemoveFromRole'])->name('permissions.bulk-remove-role');
    
    // System Logs
    Route::get('logs', [App\Http\Controllers\Admin\SystemLogsController::class, 'index'])->name('logs.index');
    Route::get('logs/{filename}', [App\Http\Controllers\Admin\SystemLogsController::class, 'show'])->name('logs.show');
    Route::get('logs/{filename}/download', [App\Http\Controllers\Admin\SystemLogsController::class, 'download'])->name('logs.download');
    Route::delete('logs/{filename}/clear', [App\Http\Controllers\Admin\SystemLogsController::class, 'clear'])->name('logs.clear');
    Route::get('logs-statistics', [App\Http\Controllers\Admin\SystemLogsController::class, 'statistics'])->name('logs.statistics');
    
    // Transaction Generator (Super Admin Only)
    Route::get('transaction-generator', [App\Http\Controllers\Admin\TransactionGeneratorController::class, 'index'])->name('transaction-generator.index');
    Route::post('transaction-generator/generate', [App\Http\Controllers\Admin\TransactionGeneratorController::class, 'generate'])->name('transaction-generator.generate');
    Route::post('transaction-generator/preview', [App\Http\Controllers\Admin\TransactionGeneratorController::class, 'preview'])->name('transaction-generator.preview');
    Route::get('transaction-generator/account/{account}', [App\Http\Controllers\Admin\TransactionGeneratorController::class, 'getAccountDetails'])->name('transaction-generator.account-details');
});

// Admin Profile Routes (Available to all admin users)
Route::middleware(['auth', 'admin.auth'])->prefix('admin')->name('admin.')->group(function () {
    // Admin Profile
    Route::get('profile', [App\Http\Controllers\Admin\AdminProfileController::class, 'show'])->name('profile.show');
    Route::get('profile/edit', [App\Http\Controllers\Admin\AdminProfileController::class, 'edit'])->name('profile.edit');
    Route::put('profile', [App\Http\Controllers\Admin\AdminProfileController::class, 'update'])->name('profile.update');
    
});
