<div>
    <h1 class="text-lg font-medium text-gray-900 mb-4">{{ __('passkeys::passkeys.passkeys') }}</h1>
    <div class="mt-2">
        <form id="passkeyForm" wire:submit="validatePasskeyProperties" class="flex items-center space-x-2">
            <div class="flex-1">
                <label for="name" class="block text-sm font-medium text-gray-700">{{ __('passkeys::passkeys.name') }}</label>
                <input autocomplete="off" type="text" wire:model="name" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="e.g., iPhone, Windows PC">
                @error('name')
                <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <button type="submit" class="mt-6 inline-flex justify-center py-2 px-4 font-medium text-white bg-[#04327c] hover:bg-[#032a6a] rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#04327c]">
                {{ __('passkeys::passkeys.create') }}
            </button>
        </form>
    </div>

    <div class="mt-6">
        <ul class="space-y-4">
            @foreach($passkeys as $passkey)
                <li class="flex justify-between items-center p-4 bg-gray-50 rounded-lg border border-gray-200 shadow-sm">
                    <div class="text-gray-700">
                        <div class="font-medium">{{ $passkey->name }}</div>
                        <div class="text-sm text-gray-500">
                            {{ __('passkeys::passkeys.last_used') }}: {{ $passkey->last_used_at?->diffForHumans() ?? __('passkeys::passkeys.not_used_yet') }}
                        </div>
                    </div>

                    <div>
                        <button wire:click="deletePasskey({{ $passkey->id }})" class="inline-flex justify-center py-2 px-4 text-sm font-medium text-white bg-red-600 hover:bg-red-700 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            {{ __('passkeys::passkeys.delete') }}
                        </button>
                    </div>
                </li>
            @endforeach
        </ul>
    </div>
</div>

@include('passkeys::livewire.partials.createScript')
