<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>{{ \App\Helpers\SettingsHelper::bankName() }}</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="color-scheme" content="light">
<meta name="supported-color-schemes" content="light">
<style>
/* Banking Email Styles */
body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    line-height: 1.6;
    color: #374151;
    background-color: #f9fafb;
    margin: 0;
    padding: 0;
}

.wrapper {
    background-color: #f9fafb;
    padding: 20px 0;
}

.content {
    max-width: 600px;
    margin: 0 auto;
    background-color: #ffffff;
    border-radius: 12px;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    overflow: hidden;
}

.header {
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
    padding: 30px 40px;
    text-align: center;
}

.header h1 {
    color: #04327c;
    font-size: 24px;
    font-weight: 700;
    margin: 0;
    letter-spacing: -0.025em;
}

.header p {
    color: #64748b;
    font-size: 14px;
    margin: 8px 0 0 0;
    opacity: 0.9;
}

.body {
    padding: 0;
}

.inner-body {
    width: 100% !important;
    max-width: 520px;
    margin: 0 auto;
}

.content-cell {
    padding: 40px;
}

.footer {
    background-color: #f8fafc;
    padding: 30px 40px;
    text-align: center;
    border-top: 1px solid #e2e8f0;
}

.footer p {
    color: #64748b;
    font-size: 12px;
    margin: 0;
    line-height: 1.5;
}

.button {
    display: inline-block;
    background: #04327c;
    color: #ffffff !important;
    text-decoration: none;
    padding: 12px 24px;
    border-radius: 8px;
    font-weight: 600;
    font-size: 14px;
    text-align: center;
    border: none;
    box-shadow: none;
}

.button:hover {
    background: #032a6a;
    color: #ffffff !important;
    text-decoration: none;
}

.button-primary {
    background: #04327c !important;
    color: #ffffff !important;
    text-decoration: none;
    border: none !important;
    box-shadow: none !important;
}

.button-primary:hover {
    background: #032a6a !important;
    color: #ffffff !important;
    text-decoration: none;
}

.button-success {
    background: #059669 !important;
    color: #ffffff !important;
    text-decoration: none;
    border: none !important;
    box-shadow: none !important;
}

.button-success:hover {
    background: #047857 !important;
    color: #ffffff !important;
    text-decoration: none;
}

.button-error {
    background: #dc2626 !important;
    color: #ffffff !important;
    text-decoration: none;
    border: none !important;
    box-shadow: none !important;
}

.button-error:hover {
    background: #b91c1c !important;
    color: #ffffff !important;
    text-decoration: none;
}

.panel {
    background-color: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    padding: 20px;
    margin: 20px 0;
}

.panel h2 {
    color: #1e293b;
    font-size: 18px;
    font-weight: 600;
    margin: 0 0 12px 0;
}

.panel p {
    color: #475569;
    font-size: 14px;
    margin: 0;
    line-height: 1.6;
}

.message {
    background-color: #f0f9ff;
    border: 1px solid #bae6fd;
    border-radius: 8px;
    padding: 16px;
    margin: 20px 0;
}

.message h2 {
    color: #0369a1;
    font-size: 16px;
    font-weight: 600;
    margin: 0 0 8px 0;
}

.message p {
    color: #0c4a6e;
    font-size: 14px;
    margin: 0;
    line-height: 1.5;
}

.subcopy {
    border-top: 1px solid #e2e8f0;
    margin-top: 30px;
    padding-top: 20px;
    font-size: 12px;
    color: #64748b;
}

.subcopy a {
    color: #04327c;
    text-decoration: none;
}

.subcopy a:hover {
    text-decoration: underline;
}

/* Responsive Design */
@media only screen and (max-width: 600px) {
    .wrapper {
        padding: 10px;
    }
    
    .content {
        border-radius: 8px;
    }
    
    .header {
        padding: 25px 20px;
    }
    
    .header h1 {
        font-size: 20px;
    }
    
    .content-cell {
        padding: 25px 20px;
    }
    
    .footer {
        padding: 25px 20px;
    }
    
    .inner-body {
        width: 100% !important;
    }
}

@media only screen and (max-width: 500px) {
    .button {
        width: 100% !important;
        display: block;
        text-align: center;
    }
    
    .header h1 {
        font-size: 18px;
    }
    
    .content-cell {
        padding: 20px 15px;
    }
}
</style>
{!! $head ?? '' !!}
</head>
<body>

<table class="wrapper" width="100%" cellpadding="0" cellspacing="0" role="presentation">
<tr>
<td align="center">
<table class="content" width="100%" cellpadding="0" cellspacing="0" role="presentation">
{!! $header ?? '' !!}

<!-- Email Body -->
<tr>
<td class="body" width="100%" cellpadding="0" cellspacing="0" style="border: hidden !important;">
<table class="inner-body" align="center" width="570" cellpadding="0" cellspacing="0" role="presentation">
<!-- Body content -->
<tr>
<td class="content-cell">
{!! Illuminate\Mail\Markdown::parse($slot) !!}

{!! $subcopy ?? '' !!}
</td>
</tr>
</table>
</td>
</tr>

{!! $footer ?? '' !!}
</table>
</td>
</tr>
</table>
</body>
</html>
