<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Security Settings</h1>
            <p class="text-sm text-gray-600 mt-1">Manage your account security preferences and authentication methods</p>
        </div>
    </div>

    <!-- Security Overview Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <!-- Password Status -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                        <flux:icon name="lock-closed" class="w-5 h-5 text-blue-600" />
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-900">Password</h3>
                        <p class="text-xs text-gray-500">Last changed: {{ auth()->user()->password_changed_at ? auth()->user()->password_changed_at->diffForHumans() : 'Never' }}</p>
                    </div>
                </div>
                <div class="w-3 h-3 bg-green-500 rounded-full"></div>
            </div>
        </div>

        <!-- PIN Status -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                        <flux:icon name="key" class="w-5 h-5 text-purple-600" />
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-900">PIN</h3>
                        <p class="text-xs text-gray-500">6-digit banking PIN</p>
                    </div>
                </div>
                <div class="w-3 h-3 bg-green-500 rounded-full"></div>
            </div>
        </div>

        <!-- 2FA Status -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 {{ $twoFactorEnabled ? 'bg-green-100' : 'bg-gray-100' }} rounded-lg flex items-center justify-center">
                        <flux:icon name="shield-check" class="w-5 h-5 {{ $twoFactorEnabled ? 'text-green-600' : 'text-gray-600' }}" />
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-900">Two-Factor Auth</h3>
                        <p class="text-xs text-gray-500">{{ $twoFactorEnabled ? 'Enabled' : 'Disabled' }}</p>
                    </div>
                </div>
                <div class="w-3 h-3 {{ $twoFactorEnabled ? 'bg-green-500' : 'bg-gray-400' }} rounded-full"></div>
            </div>
        </div>
    </div>

    <!-- Security Settings Forms -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Password Change -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Change Password</h3>
                <p class="text-sm text-gray-600 mt-1">Update your account password</p>
            </div>
            <div class="p-6 space-y-4">
                <flux:input
                    wire:model="currentPassword"
                    :label="__('Current Password')"
                    type="password"
                    placeholder="Enter current password"
                    class="w-full"
                />
                @error('currentPassword')
                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                @enderror

                <flux:input
                    wire:model="newPassword"
                    :label="__('New Password')"
                    type="password"
                    placeholder="Enter new password"
                    class="w-full"
                />
                @error('newPassword')
                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                @enderror

                <flux:input
                    wire:model="confirmPassword"
                    :label="__('Confirm New Password')"
                    type="password"
                    placeholder="Confirm new password"
                    class="w-full"
                />
                @error('confirmPassword')
                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                @enderror

                <div class="pt-2">
                    <flux:button
                        wire:click="changePassword"
                        variant="filled"
                        class="w-full"
                    >
                        Update Password
                    </flux:button>
                </div>
            </div>
        </div>

        <!-- PIN Management -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Change PIN</h3>
                <p class="text-sm text-gray-600 mt-1">Update your 6-digit banking PIN</p>
            </div>
            <div class="p-6 space-y-4">
                <flux:input
                    wire:model="currentPin"
                    :label="__('Current PIN')"
                    type="password"
                    placeholder="Enter current PIN"
                    class="w-full"
                    maxlength="6"
                />
                @error('currentPin')
                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                @enderror

                <flux:input
                    wire:model="newPin"
                    :label="__('New PIN')"
                    type="password"
                    placeholder="Enter new PIN"
                    class="w-full"
                    maxlength="6"
                />
                @error('newPin')
                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                @enderror

                <flux:input
                    wire:model="confirmPin"
                    :label="__('Confirm New PIN')"
                    type="password"
                    placeholder="Confirm new PIN"
                    class="w-full"
                    maxlength="6"
                />
                @error('confirmPin')
                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                @enderror

                <div class="pt-2">
                    <flux:button
                        wire:click="changePin"
                        variant="filled"
                        class="w-full"
                    >
                        Update PIN
                    </flux:button>
                </div>
            </div>
        </div>
    </div>

    <!-- Two-Factor Authentication -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-medium text-gray-900">Two-Factor Authentication</h3>
                    <p class="text-sm text-gray-600 mt-1">Add an extra layer of security to your account</p>
                </div>
                <flux:button
                    wire:click="toggleTwoFactor"
                    variant="{{ $twoFactorEnabled ? 'outline' : 'filled' }}"
                    size="sm"
                >
                    {{ $twoFactorEnabled ? 'Disable' : 'Enable' }} 2FA
                </flux:button>
            </div>
        </div>

        @if($showTwoFactorSetup)
            <div class="p-6 border-b border-gray-200">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">2FA Method</label>
                        <flux:select wire:model.live="twoFactorMethod" class="w-full">
                            <option value="totp">Authenticator App (TOTP)</option>
                            <option value="email">Email Verification</option>
                        </flux:select>
                    </div>

                    @if($twoFactorMethod === 'totp' && $twoFactorSecret)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h4 class="text-sm font-medium text-gray-900 mb-2">Setup Instructions</h4>
                            <ol class="text-sm text-gray-600 space-y-1 list-decimal list-inside">
                                <li>Install an authenticator app (Google Authenticator, Authy, etc.)</li>
                                <li>Scan the QR code below or enter the secret key manually</li>
                                <li>Enter the 6-digit code from your app to verify</li>
                            </ol>
                            
                            @if(!empty($twoFactorQrCode))
                                <div class="mt-4 p-4 bg-white rounded border">
                                    <div class="text-center">
                                        <div class="text-xs text-gray-500 mb-2">Scan this QR code:</div>
                                        <div class="flex justify-center">
                                            <img src="{{ $twoFactorQrCode }}" alt="2FA QR Code" class="w-48 h-48 border border-gray-200" />
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="mt-4 p-4 bg-yellow-50 rounded border border-yellow-200">
                                    <p class="text-sm text-yellow-800">QR Code could not be generated. Please use the secret key below.</p>
                                </div>
                            @endif
                            
                            <div class="mt-4 p-4 bg-white rounded border">
                                <div class="text-center">
                                    <div class="text-xs text-gray-500 mb-2">Manual Entry Key:</div>
                                    <div class="font-mono text-sm bg-gray-100 p-2 rounded break-all">{{ $twoFactorSecret }}</div>
                                </div>
                            </div>
                            
                            <div class="mt-4">
                                <flux:input
                                    wire:model="twoFactorVerificationCode"
                                    label="Verification Code"
                                    placeholder="Enter 6-digit code from your app"
                                    class="w-full"
                                    maxlength="6"
                                />
                                @error('twoFactorVerificationCode')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    @endif

                    @if($twoFactorMethod === 'email')
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h4 class="text-sm font-medium text-gray-900 mb-2">Email Verification Setup</h4>
                            <p class="text-sm text-gray-600 mb-3">We'll send a verification code to your email address to complete the setup.</p>
                            
                            @if($twoFactorVerificationCode)
                                <div class="text-center mb-4">
                                    <div class="text-xs text-gray-500 mb-2">Verification Code (if email fails):</div>
                                    <div class="font-mono text-lg bg-white p-3 rounded border">{{ $twoFactorVerificationCode }}</div>
                                </div>
                            @endif
                            
                            <div class="mt-4">
                                <flux:input
                                    wire:model="twoFactorVerificationCode"
                                    label="Verification Code"
                                    placeholder="Enter 6-digit code from your email"
                                    class="w-full"
                                    maxlength="6"
                                />
                                @error('twoFactorVerificationCode')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                                
                                <div class="mt-2 text-center">
                                    <button 
                                        type="button"
                                        wire:click="resendEmailCode"
                                        class="text-xs text-blue-600 hover:text-blue-800 underline"
                                    >
                                        Didn't receive the code? Resend
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="flex space-x-3">
                        <flux:button
                            wire:click="setupTwoFactor"
                            variant="filled"
                            size="sm"
                        >
                            {{ $twoFactorMethod === 'totp' ? 'Generate Secret' : 'Send Code' }}
                        </flux:button>
                        
                        @if($twoFactorMethod === 'totp' && $twoFactorSecret)
                            <flux:button
                                wire:click="verifyTwoFactor"
                                variant="outline"
                                size="sm"
                            >
                                Verify & Enable
                            </flux:button>
                        @elseif($twoFactorMethod === 'email')
                            <flux:button
                                wire:click="verifyTwoFactor"
                                variant="outline"
                                size="sm"
                            >
                                Verify & Enable
                            </flux:button>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        @if($twoFactorEnabled)
            <div class="p-6">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <flux:icon name="check-circle" class="w-5 h-5 text-green-600" />
                        <span class="text-sm font-medium text-gray-900">Two-factor authentication is enabled</span>
                    </div>
                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full bg-green-100 text-green-800">
                        Active
                    </span>
                </div>
                
                @if(!empty($backupCodes) && is_array($backupCodes))
                    <div class="mt-4 bg-yellow-50 rounded-lg p-4">
                        <h4 class="text-sm font-medium text-yellow-800 mb-2">Backup Codes</h4>
                        <p class="text-sm text-yellow-700 mb-3">Save these backup codes in a secure location. You can use them to access your account if you lose your 2FA device.</p>
                        <div class="grid grid-cols-2 gap-2">
                            @foreach($backupCodes as $code)
                                <div class="font-mono text-sm bg-white p-2 rounded border text-center">{{ $code }}</div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        @endif
    </div>

    <!-- Passkey Management -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-medium text-gray-900">Passkeys</h3>
                    <p class="text-sm text-gray-600 mt-1">Manage your FIDO2 passkeys for secure authentication</p>
                </div>
            </div>
        </div>

        <div class="p-6">
            <livewire:passkeys />
        </div>
    </div>

    <!-- Security Log -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-medium text-gray-900">Security Activity Log</h3>
                    <p class="text-sm text-gray-600 mt-1">Recent security-related activities on your account</p>
                </div>
                <flux:button
                    wire:click="loadSecurityLog"
                    variant="outline"
                    size="sm"
                >
                    View Log
                </flux:button>
            </div>
        </div>

        @if($showSecurityLog)
            <div class="p-6">
                @if(empty($securityLogs))
                    <div class="text-center py-8">
                        <flux:icon name="document-text" class="w-12 h-12 text-gray-300 mx-auto mb-4" />
                        <h3 class="text-sm font-medium text-gray-900 mb-1">No security activity</h3>
                        <p class="text-sm text-gray-500">Security activities will appear here</p>
                    </div>
                @else
                    <div class="space-y-3">
                        @foreach($securityLogs as $log)
                            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                <div class="flex items-center space-x-3">
                                    <flux:icon name="shield-check" class="w-5 h-5 text-blue-600" />
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $log['description'] }}</div>
                                        <div class="text-xs text-gray-500">{{ $log['created_at_human'] }}</div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        @endif
    </div>
</div>