<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Profile Settings
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Manage your personal information and preferences</p>
        </div>
    </div>

    <!-- Profile Settings Form -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Left Column - Profile Image & Basic Info -->
        <div class="lg:col-span-1 space-y-4">
            <!-- Profile Image Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Profile Image
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <!-- Current Profile Image -->
                    <div class="text-center mb-4">
                        @if($userProfile && $userProfile->profile_image_url)
                            <div class="relative inline-block">
                                <img src="{{ $userProfile->profile_image_url }}" 
                                     alt="Profile Image" 
                                     class="w-24 h-24 rounded-full object-cover border-4 border-gray-200">
                                <button wire:click="removeProfileImage" 
                                        class="absolute -top-2 -right-2 w-6 h-6 bg-red-500 text-white rounded-full flex items-center justify-center hover:bg-red-600 transition-colors cursor-pointer">
                                    <flux:icon name="x-mark" class="w-3 h-3" />
                                </button>
                            </div>
                        @else
                            <div class="w-24 h-24 bg-gray-200 rounded-full flex items-center justify-center mx-auto">
                                <flux:icon name="user" class="w-8 h-8 text-gray-400" />
                            </div>
                        @endif
                    </div>

                    <!-- Image Upload -->
                    <div>
                        <flux:input
                            wire:model="profile_image"
                            :label="__('Upload New Image')"
                            type="file"
                            accept="image/*"
                            class="w-full text-sm"
                            icon:leading="photo"
                        />
                        <p class="text-xs text-gray-500 mt-1">Max size: 2MB. Supported: JPG, PNG, GIF</p>
                    </div>
                </div>
            </div>

            <!-- Account Status Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Account Status
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <div class="space-y-3">
                        @if(\App\Helpers\SettingsHelper::isKycRequired())
                            <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                                <span class="text-gray-600 text-xs">KYC Status</span>
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium 
                                    {{ $userProfile?->kyc_status === 'verified' ? 'bg-green-100 text-green-800' : 'bg-amber-100 text-amber-800' }}">
                                    {{ $userProfile?->kyc_status_label ?? 'Pending' }}
                                </span>
                            </div>
                        @endif
                        <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                            <span class="text-gray-600 text-xs">Profile Completion</span>
                            <span class="text-xs font-medium text-gray-900">
                                {{ $userProfile?->getCompletenessPercentage() ?? 0 }}%
                            </span>
                        </div>
                        <div class="flex justify-between items-center py-1.5">
                            <span class="text-gray-600 text-xs">Last Updated</span>
                            <span class="text-xs font-medium text-gray-900">
                                {{ $userProfile?->updated_at?->diffForHumans() ?? 'Never' }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column - Profile Form -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Personal Information
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <form class="space-y-4">
                        <!-- Personal Details Section -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <flux:input
                                    wire:model="first_name"
                                    :label="__('First Name')"
                                    type="text"
                                    required
                                    placeholder="Enter your first name"
                                    class="w-full text-sm"
                                    icon:leading="user"
                                />
                                @error('first_name')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:input
                                    wire:model="middle_name"
                                    :label="__('Middle Name')"
                                    type="text"
                                    placeholder="Enter your middle name (optional)"
                                    class="w-full text-sm"
                                    icon:leading="user"
                                />
                                @error('middle_name')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:input
                                    wire:model="last_name"
                                    :label="__('Last Name')"
                                    type="text"
                                    required
                                    placeholder="Enter your last name"
                                    class="w-full text-sm"
                                    icon:leading="user"
                                />
                                @error('last_name')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:input
                                    wire:model="date_of_birth"
                                    :label="__('Date of Birth')"
                                    type="date"
                                    required
                                    class="w-full text-sm"
                                    icon:leading="calendar"
                                />
                                @error('date_of_birth')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:select
                                    wire:model="gender"
                                    :label="__('Gender')"
                                    required
                                    class="w-full text-sm"
                                >
                                    <option value="">Select Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </flux:select>
                                @error('gender')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:select
                                    wire:model="marital_status"
                                    :label="__('Marital Status')"
                                    required
                                    class="w-full text-sm"
                                >
                                    <option value="">Select Status</option>
                                    <option value="single">Single</option>
                                    <option value="married">Married</option>
                                    <option value="divorced">Divorced</option>
                                    <option value="widowed">Widowed</option>
                                </flux:select>
                                @error('marital_status')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Professional Information -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <flux:input
                                    wire:model="occupation"
                                    :label="__('Occupation')"
                                    type="text"
                                    required
                                    placeholder="Enter your occupation"
                                    class="w-full text-sm"
                                    icon:leading="briefcase"
                                />
                                @error('occupation')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:input
                                    wire:model="annual_income"
                                    :label="__('Annual Income')"
                                    type="number"
                                    required
                                    placeholder="Enter annual income"
                                    class="w-full text-sm"
                                    icon:leading="currency-dollar"
                                />
                                @error('annual_income')
                                    <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Address Information -->
                        <div class="space-y-4">
                            <h4 class="text-sm font-medium text-gray-900">Address Information</h4>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="md:col-span-2">
                                    <flux:input
                                        wire:model="address_line_1"
                                        :label="__('Address Line 1')"
                                        type="text"
                                        required
                                        placeholder="Enter your street address"
                                        class="w-full text-sm"
                                        icon:leading="map-pin"
                                    />
                                    @error('address_line_1')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:input
                                        wire:model="city"
                                        :label="__('City')"
                                        type="text"
                                        required
                                        placeholder="Enter your city"
                                        class="w-full text-sm"
                                        icon:leading="building-office"
                                    />
                                    @error('city')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:input
                                        wire:model="state_province"
                                        :label="__('State/Province')"
                                        type="text"
                                        required
                                        placeholder="Enter state/province"
                                        class="w-full text-sm"
                                        icon:leading="map"
                                    />
                                    @error('state_province')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:input
                                        wire:model="postal_code"
                                        :label="__('Postal Code')"
                                        type="text"
                                        required
                                        placeholder="Enter postal code"
                                        class="w-full text-sm"
                                        icon:leading="map-pin"
                                    />
                                    @error('postal_code')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:select
                                        wire:model="country"
                                        :label="__('Country')"
                                        required
                                        class="w-full text-sm"
                                    >
                                        <option value="">Select Country</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->name }}">{{ $country->name }}</option>
                                        @endforeach
                                    </flux:select>
                                    @error('country')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Contact Information -->
                        <div class="space-y-4">
                            <h4 class="text-sm font-medium text-gray-900">Contact Information</h4>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <flux:input
                                        wire:model="phone_number"
                                        :label="__('Phone Number')"
                                        type="tel"
                                        required
                                        placeholder="Enter your phone number"
                                        class="w-full text-sm"
                                        icon:leading="phone"
                                    />
                                    @error('phone_number')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:select
                                        wire:model="preferred_language"
                                        :label="__('Preferred Language')"
                                        class="w-full text-sm"
                                    >
                                        <option value="en">English</option>
                                        <option value="es">Spanish</option>
                                        <option value="fr">French</option>
                                        <option value="de">German</option>
                                        <option value="it">Italian</option>
                                    </flux:select>
                                    @error('preferred_language')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:select
                                        wire:model="timezone"
                                        :label="__('Timezone')"
                                        class="w-full text-sm"
                                    >
                                        <option value="UTC">UTC</option>
                                        <option value="America/New_York">Eastern Time</option>
                                        <option value="America/Chicago">Central Time</option>
                                        <option value="America/Denver">Mountain Time</option>
                                        <option value="America/Los_Angeles">Pacific Time</option>
                                        <option value="Europe/London">London</option>
                                        <option value="Europe/Paris">Paris</option>
                                        <option value="Asia/Tokyo">Tokyo</option>
                                    </flux:select>
                                    @error('timezone')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Emergency Contact -->
                        <div class="space-y-4">
                            <h4 class="text-sm font-medium text-gray-900">Emergency Contact</h4>
                            
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div>
                                    <flux:input
                                        wire:model="emergency_contact_name"
                                        :label="__('Contact Name')"
                                        type="text"
                                        required
                                        placeholder="Enter emergency contact name"
                                        class="w-full text-sm"
                                        icon:leading="user-group"
                                    />
                                    @error('emergency_contact_name')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:input
                                        wire:model="emergency_contact_phone"
                                        :label="__('Contact Phone')"
                                        type="tel"
                                        required
                                        placeholder="Enter emergency contact phone"
                                        class="w-full text-sm"
                                        icon:leading="phone"
                                    />
                                    @error('emergency_contact_phone')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <flux:input
                                        wire:model="emergency_contact_relationship"
                                        :label="__('Relationship')"
                                        type="text"
                                        required
                                        placeholder="e.g., Spouse, Parent"
                                        class="w-full text-sm"
                                        icon:leading="heart"
                                    />
                                    @error('emergency_contact_relationship')
                                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="flex space-x-3 pt-4 border-t border-gray-100">
                            <flux:button wire:click="updateProfile" variant="primary" class="px-6 py-2 text-sm cursor-pointer">
                                Update Profile
                            </flux:button>      
                            <flux:button wire:click="loadUserProfile" variant="filled" class="px-6 py-2 text-sm cursor-pointer">
                                Reset Changes
                            </flux:button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
