<div class="min-h-screen bg-gray-50 p-4">
    <div class="max-w-2xl mx-auto">
        <!-- Success Header -->
        <div class="text-center mb-6">
            <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
            </div>
            <h1 class="text-xl font-semibold text-gray-900 mb-1">Transfer Successful!</h1>
            <p class="text-sm text-gray-600">Your {{ $transaction->subcategory ?? 'transfer' }} has been completed successfully</p>
        </div>

        <!-- Transaction Details -->
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 mb-4">
            <h3 class="text-base font-semibold text-gray-900 mb-3">Transaction Details</h3>
            
            <div class="space-y-2">
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Transaction ID:</span>
                    <span class="text-sm font-medium text-gray-900">{{ $transaction->transaction_id }}</span>
                </div>
                
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Amount:</span>
                    <span class="text-sm font-medium text-gray-900">{{ $transaction->currency }} {{ number_format($transaction->amount, 2) }}</span>
                </div>
                
                @if($transaction->subcategory === 'international' && $beneficiary?->currency)
                <div class="py-2 border-b border-gray-100">
                    <div class="text-xs text-gray-500 italic flex items-center gap-1">
                        Will be converted to {{ $beneficiary->currency }} on arrival
                        <flux:tooltip toggleable>
                            <flux:button icon="information-circle" size="xs" variant="ghost" />
                            <flux:tooltip.content class="max-w-[20rem] space-y-2">
                                <p>Your transfer will be converted from {{ $transaction->currency }} to {{ $beneficiary->currency }} using the current exchange rate at the time of processing.</p>
                                <p>The final amount received will depend on the exchange rate and any conversion fees applied by the receiving bank.</p>
                            </flux:tooltip.content>
                        </flux:tooltip>
                    </div>
                </div>
                @endif
                
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Transfer Fee:</span>
                    <span class="text-sm font-medium text-gray-900">{{ $transaction->currency }} {{ number_format($transaction->fee_amount, 2) }}</span>
                </div>
                
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Total Amount:</span>
                    <span class="text-sm font-medium text-gray-900">{{ $transaction->currency }} {{ number_format($transaction->net_amount, 2) }}</span>
                </div>
                
                @if($transaction->subcategory === 'international')
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">To:</span>
                    <span class="text-sm font-medium text-gray-900">
                        @if($transaction->metadata['manual_transfer'] ?? false)
                            {{ $transaction->metadata['recipient_details']['name'] ?? 'N/A' }}
                        @else
                            {{ $beneficiary?->name ?? 'N/A' }}
                        @endif
                    </span>
                </div>
                
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Account Number:</span>
                    <span class="text-sm font-medium text-gray-900">
                        @if($transaction->metadata['manual_transfer'] ?? false)
                            {{ $transaction->metadata['recipient_details']['account_number'] ?? 'N/A' }}
                        @else
                            {{ $beneficiary?->account_number ?? 'N/A' }}
                        @endif
                    </span>
                </div>
                
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Country:</span>
                    <span class="text-sm font-medium text-gray-900">
                        @if($transaction->metadata['manual_transfer'] ?? false)
                            {{ $transaction->metadata['recipient_details']['country'] ?? 'N/A' }}
                        @else
                            {{ $beneficiary?->country ?? 'N/A' }}
                        @endif
                    </span>
                </div>
                
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Address:</span>
                    <span class="text-sm font-medium text-gray-900">
                        @if($transaction->metadata['manual_transfer'] ?? false)
                            {{ $transaction->metadata['recipient_details']['address'] ?? 'N/A' }}
                        @else
                            {{ $beneficiary?->address ?? 'N/A' }}
                        @endif
                    </span>
                </div>
                @endif
                
                @if($transaction->metadata['manual_transfer'] ?? false)
                    @if($transaction->metadata['recipient_details']['iban'] ?? false)
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-sm text-gray-600">IBAN:</span>
                        <span class="text-sm font-medium text-gray-900">{{ $transaction->metadata['recipient_details']['iban'] }}</span>
                    </div>
                    @endif
                    
                    @if($transaction->metadata['recipient_details']['swift_code'] ?? false)
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-sm text-gray-600">SWIFT Code:</span>
                        <span class="text-sm font-medium text-gray-900">{{ $transaction->metadata['recipient_details']['swift_code'] }}</span>
                    </div>
                    @endif
                @else
                    @if($beneficiary?->iban)
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-sm text-gray-600">IBAN:</span>
                        <span class="text-sm font-medium text-gray-900">{{ $beneficiary->iban }}</span>
                    </div>
                    @endif
                    
                    @if($beneficiary?->swift_code)
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-sm text-gray-600">SWIFT Code:</span>
                        <span class="text-sm font-medium text-gray-900">{{ $beneficiary->swift_code }}</span>
                    </div>
                    @endif
                @endif
                
                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                    <span class="text-sm text-gray-600">Status:</span>
                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium 
                        @if($transaction->status === 'completed') bg-green-100 text-green-800
                        @elseif($transaction->status === 'pending') bg-yellow-100 text-yellow-800
                        @elseif($transaction->status === 'processing') bg-blue-100 text-blue-800
                        @elseif($transaction->status === 'failed') bg-red-100 text-red-800
                        @elseif($transaction->status === 'cancelled') bg-gray-100 text-gray-800
                        @else bg-gray-100 text-gray-800 @endif">
                        {{ ucfirst($transaction->status) }}
                    </span>
                </div>
                
                <div class="flex justify-between items-center py-2">
                    <span class="text-sm text-gray-600">Date:</span>
                    <span class="text-sm font-medium text-gray-900">{{ $transaction->created_at->format('M d, Y h:i A') }}</span>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="flex flex-col sm:flex-row gap-3 mb-4">
            <flux:button 
                wire:navigate.hover
                href="{{ route('dashboard') }}"
                variant="primary" 
                class="flex-1 py-2"
                icon="home"
            >
                Return to Dashboard
            </flux:button>
            
            <flux:button 
                variant="outline" 
                class="flex-1 py-2"
                icon="document-text"
                wire:click="generateReceipt"
            >
                Download Receipt
            </flux:button>
        </div>

        <!-- Additional Information -->
        <div class="bg-blue-50 rounded-lg p-3">
            <div class="flex items-start">
                <flux:icon name="information-circle" class="w-4 h-4 text-blue-600 mt-0.5 mr-2 flex-shrink-0" />
                <div class="text-xs text-blue-800">
                    <p class="font-medium mb-1">Important Information:</p>
                    <ul class="list-disc list-inside space-y-0.5">
                        <li>Your transfer has been processed and will be credited to the recipient's account within 1-3 business days.</li>
                        <li>You will receive an email confirmation shortly.</li>
                        <li>Keep this transaction ID for your records: <strong>{{ $transaction->transaction_id }}</strong></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>