<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Deposit History
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">View and track your deposit transactions</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            <flux:button variant="primary" size="sm" class="flex items-center gap-1 px-2.5 py-1 text-xs" href="{{ route('user.deposit.cheque') }}" wire:navigate>
                <flux:icon name="plus" class="w-3 h-3" />
                New Deposit
            </flux:button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4 mb-6">
        <!-- Total Deposits -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 mb-1">Total Deposits</p>
                    <p class="text-lg font-bold text-gray-900">{{ $stats['total_deposits'] }}</p>
                </div>
                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="arrow-down-tray" class="w-4 h-4 text-blue-600" />
                </div>
            </div>
        </div>

        <!-- Completed Deposits -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 mb-1">Completed</p>
                    <p class="text-lg font-bold text-green-600">{{ $stats['completed_deposits'] }}</p>
                </div>
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="check-circle" class="w-4 h-4 text-green-600" />
                </div>
            </div>
        </div>

        <!-- Pending Deposits -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 mb-1">Pending</p>
                    <p class="text-lg font-bold text-yellow-600">{{ $stats['pending_deposits'] }}</p>
                </div>
                <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="clock" class="w-4 h-4 text-yellow-600" />
                </div>
            </div>
        </div>

        <!-- Total Amount -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 mb-1">Total Amount</p>
                    <p class="text-lg font-bold text-gray-900">${{ number_format((float)$stats['total_amount'], 2) }}</p>
                </div>
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="banknotes" class="w-4 h-4 text-green-600" />
                </div>
            </div>
        </div>

        <!-- Pending Amount -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 mb-1">Pending Amount</p>
                    <p class="text-lg font-bold text-yellow-600">${{ number_format((float)$stats['pending_amount'], 2) }}</p>
                </div>
                <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="clock" class="w-4 h-4 text-yellow-600" />
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <h3 class="text-sm font-semibold text-gray-900">Filter Deposits</h3>
            
            <div class="flex flex-col lg:flex-row gap-3 flex-1">
                <!-- Status Filter -->
                <div class="min-w-[150px]">
                    <flux:field>
                        <flux:select wire:model.live="statusFilter" placeholder="All Status">
                            <option value="">All Status</option>
                            <option value="pending">Pending</option>
                            <option value="processing">Processing</option>
                            <option value="completed">Completed</option>
                            <option value="failed">Rejected</option>
                        </flux:select>
                    </flux:field>
                </div>

                <!-- Account Filter -->
                <div class="min-w-[200px]">
                    <flux:field>
                        <flux:select wire:model.live="accountFilter" placeholder="All Accounts">
                            <option value="">All Accounts</option>
                            @foreach($userAccounts as $account)
                                <option value="{{ $account->id }}">
                                    {{ $account->account_name }} - {{ $account->account_number }}
                                </option>
                            @endforeach
                        </flux:select>
                    </flux:field>
                </div>

                <!-- Date Range -->
                <div class="flex gap-2">
                    <flux:field>
                        <flux:date-picker wire:model.live="dateFrom" placeholder="Select start date" selectable-header />
                    </flux:field>
                    <flux:field>
                        <flux:date-picker wire:model.live="dateTo" placeholder="Select end date" selectable-header />
                    </flux:field>
                </div>

                <!-- Amount Range -->
                <div class="flex gap-2">
                    <flux:field>
                        <flux:input wire:model.live="amountFrom" type="number" step="0.01" placeholder="Min Amount" />
                    </flux:field>
                    <flux:field>
                        <flux:input wire:model.live="amountTo" type="number" step="0.01" placeholder="Max Amount" />
                    </flux:field>
                </div>

                <!-- Clear Filters -->
                <flux:button variant="outline" size="sm" wire:click="clearFilters">
                    Clear
                </flux:button>
            </div>
        </div>
    </div>

    <!-- Deposits Table -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-base font-semibold text-gray-900">Deposit Transactions</h3>
        </div>

        <!-- Desktop Table -->
        <div class="hidden md:block overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transaction</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Account</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($deposits as $deposit)
                        <tr class="hover:bg-gray-50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="w-10 h-10 rounded-xl bg-blue-100 flex items-center justify-center">
                                        <flux:icon name="{{ $this->getDepositTypeIcon($deposit->subcategory) }}" class="w-5 h-5 text-blue-600" />
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">
                                            {{ $this->getDepositTypeLabel($deposit->subcategory) }}
                                        </div>
                                        <div class="text-sm text-gray-500">
                                            {{ $deposit->transaction_id }}
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-semibold text-green-600">
                                    +${{ number_format((float)$deposit->amount, 2) }}
                                </div>
                                <div class="text-sm text-gray-500">{{ $deposit->currency }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-900">
                                    {{ $deposit->toAccount->account_name ?? 'N/A' }}
                                </div>
                                <div class="text-sm text-gray-500">
                                    {{ $deposit->toAccount->account_number ?? 'N/A' }}
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($deposit->status) }}">
                                    <flux:icon name="{{ $this->getStatusIcon($deposit->status) }}" class="w-3 h-3 mr-1" />
                                    {{ $this->getStatusLabel($deposit->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                {{ $deposit->created_at->format('M j, Y') }}
                                <div class="text-xs">{{ $deposit->created_at->format('h:i A') }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <flux:modal.trigger name="deposit-details-{{ $deposit->id }}">
                                    <flux:button variant="outline" size="sm" class="text-xs">
                                        View Details
                                    </flux:button>
                                </flux:modal.trigger>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <flux:icon name="arrow-down-tray" class="w-12 h-12 text-gray-300 mb-4" />
                                    <h3 class="text-sm font-medium text-gray-900 mb-1">No deposits found</h3>
                                    <p class="text-sm text-gray-500">Your deposit history will appear here</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Mobile Cards -->
        <div class="md:hidden divide-y divide-gray-200">
            @forelse($deposits as $deposit)
                <div class="p-4">
                    <div class="flex items-center justify-between mb-3">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-xl bg-blue-100 flex items-center justify-center">
                                <flux:icon name="{{ $this->getDepositTypeIcon($deposit->subcategory) }}" class="w-5 h-5 text-blue-600" />
                            </div>
                            <div class="ml-3 flex-1">
                                <p class="text-sm font-medium text-gray-900">
                                    {{ $this->getDepositTypeLabel($deposit->subcategory) }}
                                </p>
                                <p class="text-sm text-gray-500">{{ $deposit->transaction_id }}</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-semibold text-green-600">
                                +${{ number_format((float)$deposit->amount, 2) }}
                            </p>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($deposit->status) }}">
                                {{ $this->getStatusLabel($deposit->status) }}
                            </span>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-4 text-sm text-gray-600">
                        <div>
                            <span class="font-medium">Account:</span>
                            <p>{{ $deposit->toAccount->account_name ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <span class="font-medium">Date:</span>
                            <p>{{ $deposit->created_at->format('M j, Y h:i A') }}</p>
                        </div>
                    </div>
                </div>
            @empty
                <div class="p-8 text-center">
                    <flux:icon name="arrow-down-tray" class="w-12 h-12 text-gray-300 mb-4 mx-auto" />
                    <h3 class="text-sm font-medium text-gray-900 mb-1">No deposits found</h3>
                    <p class="text-sm text-gray-500">Your deposit history will appear here</p>
                </div>
            @endforelse
        </div>

        <!-- Pagination -->
        @if($deposits->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $deposits->links() }}
            </div>
        @endif
    </div>

    <!-- Deposit Details Modals -->
    @foreach($deposits as $deposit)
        <flux:modal name="deposit-details-{{ $deposit->id }}" class="md:w-192">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">Deposit Details</flux:heading>
                    <flux:text class="mt-2">Transaction ID: {{ $deposit->transaction_id }}</flux:text>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Deposit Information -->
                    <div class="space-y-4">
                        <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                            <h3 class="text-sm font-semibold text-gray-900">Deposit Information</h3>
                            <div class="space-y-2">
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Amount:</span>
                                    <span class="text-sm font-medium text-green-600">
                                        +${{ number_format((float)$deposit->amount, 2) }}
                                    </span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Type:</span>
                                    <span class="text-sm font-medium text-gray-900">
                                        {{ $this->getDepositTypeLabel($deposit->subcategory) }}
                                    </span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Status:</span>
                                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($deposit->status) }}">
                                        <flux:icon name="{{ $this->getStatusIcon($deposit->status) }}" class="w-3 h-3 mr-1" />
                                        {{ $this->getStatusLabel($deposit->status) }}
                                    </span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Date:</span>
                                    <span class="text-sm font-medium text-gray-900">
                                        {{ $deposit->created_at->format('M j, Y h:i A') }}
                                    </span>
                                </div>
                                @if($deposit->description)
                                    <div class="flex justify-between">
                                        <span class="text-sm text-gray-600">Description:</span>
                                        <span class="text-sm font-medium text-gray-900">{{ $deposit->description }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Cheque Details (if available) -->
                        @if($deposit->subcategory === 'cheque_deposit' && isset($deposit->metadata['cheque_details']))
                            @php $chequeDetails = $deposit->metadata['cheque_details']; @endphp
                            <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                                <h3 class="text-sm font-semibold text-gray-900">Cheque Details</h3>
                                <div class="space-y-2">
                                    @if(isset($chequeDetails['cheque_number']))
                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-600">Cheque Number:</span>
                                            <span class="text-sm font-medium text-gray-900">{{ $chequeDetails['cheque_number'] }}</span>
                                        </div>
                                    @endif
                                    @if(isset($chequeDetails['bank_name']))
                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-600">Bank:</span>
                                            <span class="text-sm font-medium text-gray-900">{{ $chequeDetails['bank_name'] }}</span>
                                        </div>
                                    @endif
                                    @if(isset($chequeDetails['routing_number']))
                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-600">Routing Number:</span>
                                            <span class="text-sm font-medium text-gray-900">{{ $chequeDetails['routing_number'] }}</span>
                                        </div>
                                    @endif
                                    @if(isset($chequeDetails['account_number']))
                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-600">Account Number:</span>
                                            <span class="text-sm font-medium text-gray-900">{{ $chequeDetails['account_number'] }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Cheque Images (if available) -->
                    @if($deposit->subcategory === 'cheque_deposit' && isset($deposit->metadata['cheque_details']))
                        @php $chequeDetails = $deposit->metadata['cheque_details']; @endphp
                        <div class="space-y-4">
                            @if(isset($chequeDetails['front_image']))
                                <div>
                                    <h3 class="text-sm font-semibold text-gray-900 mb-2">Front of Cheque</h3>
                                    <div class="bg-gray-50 rounded-lg p-4">
                                        <img 
                                            src="{{ Storage::url($chequeDetails['front_image']) }}" 
                                            alt="Front of cheque"
                                            class="w-full h-auto rounded-lg border border-gray-200"
                                            style="max-height: 300px; object-fit: contain;"
                                        />
                                    </div>
                                </div>
                            @endif

                            @if(isset($chequeDetails['back_image']))
                                <div>
                                    <h3 class="text-sm font-semibold text-gray-900 mb-2">Back of Cheque</h3>
                                    <div class="bg-gray-50 rounded-lg p-4">
                                        <img 
                                            src="{{ Storage::url($chequeDetails['back_image']) }}" 
                                            alt="Back of cheque"
                                            class="w-full h-auto rounded-lg border border-gray-200"
                                            style="max-height: 300px; object-fit: contain;"
                                        />
                                    </div>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="flex items-center justify-center h-full">
                            <div class="text-center">
                                <flux:icon name="document-text" class="w-12 h-12 text-gray-300 mb-2 mx-auto" />
                                <p class="text-sm text-gray-500">No images available</p>
                            </div>
                        </div>
                    @endif
                </div>

                <!-- Action Buttons -->
                <div class="flex justify-end pt-4">
                    <flux:button 
                        variant="outline" 
                        x-on:click="$dispatch('modal-close', { name: 'deposit-details-{{ $deposit->id }}' })"
                    >
                        Close
                    </flux:button>
                </div>
            </div>
        </flux:modal>
    @endforeach
</div>
