<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Account Management
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Manage your banking accounts, settings, and limits</p>
        </div>
    </div>

    <!-- Account Management Interface -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Left Column - Account List -->
        <div class="lg:col-span-1 space-y-4">
            <!-- Account List Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <div class="flex items-center justify-between">
                            <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                                Your Accounts
                                <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                            </h3>
                            <div class="text-xs text-gray-600">
                                {{ $this->getAccountCountInfo()['current'] }}/{{ $this->getAccountCountInfo()['max'] }}
                            </div>
                        </div>
                    </div>

                    <div class="space-y-3">
                        @forelse($accounts as $account)
                            <div class="cursor-pointer p-3 rounded-lg border transition-colors {{ $selectedAccount && $selectedAccount->id === $account->id ? 'border-[#04327c] bg-blue-50' : 'border-gray-200 hover:border-gray-300' }}"
                                 wire:click="selectAccount({{ $account->id }})">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center space-x-2">
                                        <div class="w-3 h-3 rounded-full {{ $account->is_master_account ? 'bg-[#04327c]' : 'bg-gray-300' }}"></div>
                                        <span class="text-sm font-medium text-gray-900">{{ $account->account_name }}</span>
                                        @if($account->is_master_account)
                                            <span class="inline-flex items-center px-1.5 py-0.5 rounded-full text-xs font-medium bg-[#04327c] text-white">
                                                <flux:icon name="star" class="w-2.5 h-2.5 mr-0.5" />
                                                Primary
                                            </span>
                                        @endif
                                    </div>
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $this->getAccountStatusColor($account->status) }}">
                                        {{ ucfirst($account->status) }}
                                    </span>
                                </div>
                                
                                <div class="flex items-center justify-between text-xs text-gray-600">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $this->getAccountTypeColor($account->account_type) }}">
                                        {{ ucfirst($account->account_type) }}
                                    </span>
                                    <span class="font-mono">{{ $account->account_number }}</span>
                                </div>
                                
                                <div class="mt-2 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Balance:</span>
                                        <span class="font-semibold text-gray-900">{{ \App\Helpers\CurrencyHelper::format($account->balance, $account->currency) }}</span>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-6 text-gray-500">
                                <flux:icon name="credit-card" class="w-8 h-8 mx-auto mb-2 text-gray-300" />
                                <p class="text-sm">No accounts found</p>
                                <p class="text-xs">Create your first account to get started</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>

            <!-- Quick Actions Card -->
            @if($selectedAccount)
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                    <div class="px-4 py-4">
                        <div class="text-left mb-4">
                            <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                                Quick Actions
                                <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                            </h3>
                        </div>

                        <div class="grid grid-cols-2 gap-2">
                        @if($selectedAccount->status === 'active')
                                <flux:button icon="cog" wire:click="showSettings" class="w-full text-sm cursor-pointer">
                                    Settings
                                </flux:button>
                                <flux:button icon="shield-check" wire:click="showLimits" class="w-full text-sm cursor-pointer">
                                    Limits
                                </flux:button>
                            @endif
                            @if($selectedAccount->status === 'active' && !$selectedAccount->is_master_account)
                                <!--    <flux:button icon="lock-closed" wire:click="showClosure" class="w-full text-sm cursor-pointer">
                                        Suspend
                                    </flux:button> -->
                            @elseif($selectedAccount->status === 'suspended')
                               <!-- <flux:button icon="lock-open" wire:click="activateAccount" class="w-full text-sm cursor-pointer">
                                        Activate
                                    </flux:button> -->
                            @endif
                        </div>

                        <!-- Add Account Button - Only show if master account is active and no pending accounts -->
                        @php
                            $masterAccount = $accounts->where('is_master_account', true)->first();
                            $hasPendingAccounts = $accounts->where('status', 'pending')->count() > 0;
                            $accountCount = $accounts->count();
                            $canAddAccount = $masterAccount && $masterAccount->status === 'active' && !$hasPendingAccounts && $accountCount < 3;
                        @endphp
                        
                        @if($canAddAccount)
                            <div class="mt-3 pt-3 border-t border-gray-100">
                                <flux:button icon="plus" wire:click="openAddAccount" class="w-full text-sm cursor-pointer">
                                    Add New Account
                                </flux:button>
                            </div>
                        @endif
                    </div>
                </div>
            @endif
        </div>

        <!-- Right Column - Account Details & Management -->
        <div class="lg:col-span-2 space-y-4">
            @if($selectedAccount)
                <!-- Account Overview Card -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                    <div class="px-4 py-4">
                        <div class="text-left mb-4">
                            <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                                Account Overview
                                <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                            </h3>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="space-y-3">
                                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                                    <span class="text-gray-600 text-xs">Account Name</span>
                                    <span class="text-xs font-medium">{{ $selectedAccount->account_name }}</span>
                                </div>
                                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                                    <span class="text-gray-600 text-xs">Account Type</span>
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $this->getAccountTypeColor($selectedAccount->account_type) }}">
                                        {{ ucfirst($selectedAccount->account_type) }}
                                    </span>
                                </div>
                                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                                    <span class="text-gray-600 text-xs">Account Number</span>
                                    <span class="font-mono text-xs">{{ $selectedAccount->account_number }}</span>
                                </div>
                                <div class="flex justify-between items-center py-1.5">
                                    <span class="text-gray-600 text-xs">Currency</span>
                                    <span class="text-xs font-medium">{{ $selectedAccount->currency }}</span>
                                </div>
                            </div>

                            <div class="space-y-3">
                                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                                    <span class="text-gray-600 text-xs">Status</span>
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $this->getAccountStatusColor($selectedAccount->status) }}">
                                        {{ ucfirst($selectedAccount->status) }}
                                    </span>
                                </div>
                                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                                    <span class="text-gray-600 text-xs">Balance</span>
                                    <span class="text-xs font-medium font-semibold">{{ \App\Helpers\CurrencyHelper::format($selectedAccount->balance, $selectedAccount->currency) }}</span>
                                </div>
                                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                                    <span class="text-gray-600 text-xs">Available</span>
                                    <span class="text-xs font-medium">{{ \App\Helpers\CurrencyHelper::format($selectedAccount->available_balance, $selectedAccount->currency) }}</span>
                                </div>
                                <div class="flex justify-between items-center py-1.5">
                                    <span class="text-gray-600 text-xs">Created</span>
                                    <span class="text-xs font-medium">{{ $selectedAccount->created_at->format('M d, Y') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Account Settings Form -->
                @if($showAccountSettings)
                    <div id="account-settings-form" class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                        <div class="px-4 py-4">
                            <div class="text-left mb-4">
                                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                                    Account Settings
                                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                                </h3>
                            </div>

                            <div class="space-y-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <flux:input
                                            wire:model="account_name"
                                            :label="__('Account Name')"
                                            type="text"
                                            required
                                            placeholder="Enter account name"
                                            class="w-full text-sm"
                                            icon:leading="credit-card"
                                        />
                                        @error('account_name')
                                            <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <flux:textarea
                                            wire:model="description"
                                            :label="__('Description')"
                                            placeholder="Enter account description"
                                            rows="2"
                                            class="w-full text-sm"
                                        />
                                        @error('description')
                                            <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="space-y-3">
                                    <h4 class="text-sm font-medium text-gray-900">Access Controls</h4>
                                    
                                    <div class="space-y-2">
                                        <flux:checkbox wire:model="online_banking_enabled" :label="__('Enable Online Banking')" class="text-sm" />
                                        <flux:checkbox wire:model="mobile_banking_enabled" :label="__('Enable Mobile Banking')" class="text-sm" />
                                        <flux:checkbox wire:model="two_factor_required" :label="__('Require Two-Factor Authentication')" class="text-sm" />
                                    </div>
                                </div>

                                <!-- Master Account Section -->
                                <div class="space-y-3 pt-4 border-t border-gray-100">
                                    <div class="flex items-center justify-between">
                                        <div>
                                            <h4 class="text-sm font-medium text-gray-900">Master Account</h4>
                                            <p class="text-xs text-gray-600 mt-1">Set this account as your primary account for banking operations</p>
                                        </div>
                                        @if($selectedAccount->is_master_account)
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-[#04327c] text-white">
                                                <flux:icon name="star" class="w-3 h-3 mr-1" />
                                                Primary
                                            </span>
                                        @endif
                                    </div>
                                    
                                    @if($selectedAccount->status === 'active' && !$selectedAccount->is_master_account)
                                        <div class="bg-amber-50 border border-amber-200 rounded-lg p-3">
                                            <div class="flex items-center">
                                                <flux:icon name="information-circle" class="w-4 h-4 text-amber-600 mr-2" />
                                                <div class="text-sm text-amber-800">
                                                    <p class="font-medium">Change Master Account</p>
                                                    <p class="text-xs mt-1">Setting this as your master account will remove master status from your current master account.</p>
                                                </div>
                                            </div>
                                            <div class="mt-3">
                                                <flux:button icon="star" wire:click="changeMasterAccount" class="text-xs cursor-pointer">
                                                    Set as Primary Account
                                                </flux:button>
                                            </div>
                                        </div>
                                    @endif
                                </div>

                                <div class="flex space-x-3 pt-4 border-t border-gray-100">
                                    <flux:button icon="check" wire:click="updateAccountSettings" class="px-6 py-2 text-sm cursor-pointer">
                                        Save Settings
                                    </flux:button>
                                    
                                    <flux:button icon="x" wire:click="showSettings" class="px-6 py-2 text-sm cursor-pointer">
                                        Cancel
                                    </flux:button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Account Limits Form -->
                @if($showAccountLimits)
                    <div id="account-limits-form" class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                        <div class="px-4 py-4">
                            <div class="text-left mb-4">
                                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                                    Account Limits
                                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                                </h3>
                            </div>

                            <div class="space-y-4">
                                <!-- Default Limits Info -->
                                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                                    <div class="flex items-center">
                                        <flux:icon name="information-circle" class="w-5 h-5 text-blue-600 mr-3" />
                                        <div>
                                            <h4 class="text-sm font-medium text-blue-800">Default Limits</h4>
                                            <p class="text-sm text-blue-700 mt-1">You can adjust your limits up to the default maximum values shown below.</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Default Limits Display -->
                                <div class="grid grid-cols-2 gap-4 text-xs">
                                    <div class="bg-gray-50 rounded-lg p-3">
                                        <div class="font-medium text-gray-700 mb-1">Daily Transfer</div>
                                        <div class="text-gray-900 font-mono">{{ $this->formatCurrency($this->getDefaultLimits()['daily_transfer'], $selectedAccount->currency ?? 'USD') }}</div>
                                    </div>
                                    <div class="bg-gray-50 rounded-lg p-3">
                                        <div class="font-medium text-gray-700 mb-1">Monthly Transfer</div>
                                        <div class="text-gray-900 font-mono">{{ $this->formatCurrency($this->getDefaultLimits()['monthly_transfer'], $selectedAccount->currency ?? 'USD') }}</div>
                                    </div>
                                    <div class="bg-gray-50 rounded-lg p-3">
                                        <div class="font-medium text-gray-700 mb-1">Daily Withdrawal</div>
                                        <div class="text-gray-900 font-mono">{{ $this->formatCurrency($this->getDefaultLimits()['daily_withdrawal'], $selectedAccount->currency ?? 'USD') }}</div>
                                    </div>
                                    <div class="bg-gray-50 rounded-lg p-3">
                                        <div class="font-medium text-gray-700 mb-1">Monthly Withdrawal</div>
                                        <div class="text-gray-900 font-mono">{{ $this->formatCurrency($this->getDefaultLimits()['monthly_withdrawal'], $selectedAccount->currency ?? 'USD') }}</div>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <flux:input
                                            wire:model="daily_transfer_limit"
                                            :label="__('Daily Transfer Limit')"
                                            type="number"
                                            required
                                            placeholder="Enter daily limit"
                                            class="w-full text-sm"
                                            icon:leading="arrow-right-left"
                                        />
                                        @error('daily_transfer_limit')
                                            <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <flux:input
                                            wire:model="monthly_transfer_limit"
                                            :label="__('Monthly Transfer Limit')"
                                            type="number"
                                            required
                                            placeholder="Enter monthly limit"
                                            class="w-full text-sm"
                                            icon:leading="calendar"
                                        />
                                        @error('monthly_transfer_limit')
                                            <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <flux:input
                                            wire:model="daily_withdrawal_limit"
                                            :label="__('Daily Withdrawal Limit')"
                                            type="number"
                                            required
                                            placeholder="Enter daily limit"
                                            class="w-full text-sm"
                                            icon:leading="arrow-down-tray"
                                        />
                                        @error('daily_withdrawal_limit')
                                            <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <flux:input
                                            wire:model="monthly_withdrawal_limit"
                                            :label="__('Monthly Withdrawal Limit')"
                                            type="number"
                                            required
                                            placeholder="Enter monthly limit"
                                            class="w-full text-sm"
                                            icon:leading="calendar"
                                        />
                                        @error('monthly_withdrawal_limit')
                                            <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="flex space-x-3 pt-4 border-t border-gray-100">
                                    <flux:button wire:click="updateAccountLimits" variant="primary" class="px-6 py-2 text-sm cursor-pointer">
                                        Update Limits
                                    </flux:button>
                                    
                                    <flux:button wire:click="showLimits" variant="filled" class="px-6 py-2 text-sm cursor-pointer">
                                        Cancel
                                    </flux:button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Account Closure Form -->
                @if($showAccountClosure)
                    <div id="account-closure-form" class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                        <div class="px-4 py-4">
                            <div class="text-left mb-4">
                                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                                    Account Management
                                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                                </h3>
                            </div>

                            <div class="space-y-4">
                                @if($selectedAccount->is_master_account)
                                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                                        <div class="flex items-center">
                                            <flux:icon name="information-circle" class="w-5 h-5 text-blue-600 mr-3" />
                                            <div>
                                                <h4 class="text-sm font-medium text-blue-800">Primary Account Protection</h4>
                                                <p class="text-sm text-blue-700 mt-1">Your primary account cannot be suspended as it's essential for banking operations. You can change your primary account in the settings if needed.</p>
                                            </div>
                                        </div>
                                    </div>
                                @else
                                    <div class="bg-amber-50 border border-amber-200 rounded-lg p-4">
                                        <div class="flex items-center">
                                            <flux:icon name="exclamation-triangle" class="w-5 h-5 text-amber-600 mr-3" />
                                            <div>
                                                <h4 class="text-sm font-medium text-amber-800">AccountS Suspension</h4>
                                                <p class="text-sm text-amber-700 mt-1">This will temporarily suspend your account. You can reactivate it later.</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex space-x-3 pt-4 border-t border-gray-100">
                                        <flux:button icon="ban" wire:click="suspendAccount" class="px-6 py-2 text-sm cursor-pointer">
                                            Suspend Account
                                        </flux:button>
                                        
                                        <flux:button icon="x" wire:click="showClosure" class="px-6 py-2 text-sm cursor-pointer">
                                            Cancel
                                        </flux:button>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Add Account Form -->
                @if($showAddAccount)
                    <div id="add-account-form" class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                        <div class="px-4 py-4">
                            <div class="text-left mb-4">
                                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                                    Add New Account
                                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                                </h3>
                            </div>

                            <div class="space-y-4">
                                <!-- Account Count Info -->
                                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center">
                                            <flux:icon name="information-circle" class="w-5 h-5 text-blue-600 mr-3" />
                                            <div>
                                                <h4 class="text-sm font-medium text-blue-800">Account Limit</h4>
                                                <p class="text-sm text-blue-700 mt-1">You can create up to {{ $this->getAccountCountInfo()['max'] }} accounts. You currently have {{ $this->getAccountCountInfo()['current'] }} account(s).</p>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <div class="text-lg font-semibold text-blue-800">{{ $this->getAccountCountInfo()['remaining'] }}</div>
                                            <div class="text-xs text-blue-600">Remaining</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="text-center py-6">
                                    <flux:icon name="plus-circle" class="w-12 h-12 mx-auto mb-4 text-blue-500" />
                                    <h4 class="text-lg font-medium text-gray-900 mb-2">Ready to Add Account</h4>
                                    <p class="text-sm text-gray-600 mb-4">Your master account is active and verified. You can now create additional accounts.</p>
                                    
                                    <flux:button icon="arrow-right" wire:click="redirectToAccountCreation" variant="primary" class="px-6 py-2 text-sm cursor-pointer">
                                        Go to Account Creation
                                    </flux:button>
                                </div>

                                <div class="flex justify-center pt-4 border-t border-gray-100">
                                    <flux:button icon="x" wire:click="openAddAccount" variant="filled" class="px-6 py-2 text-sm cursor-pointer">
                                        Cancel
                                    </flux:button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @else
                <!-- No Account Selected or No Accounts Available -->
                @if($accounts->count() === 0)
                    <!-- No Accounts Available -->
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                        <div class="px-4 py-8 text-center">
                            <flux:icon name="credit-card" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                            <h3 class="text-lg font-medium text-gray-900 mb-2">No Accounts Found</h3>
                            <p class="text-sm text-gray-600 mb-6">You don't have any accounts yet. Create your first account to get started with banking.</p>
                            
                            <flux:button 
                                icon="plus" 
                                href="{{ route('account.create') }}" 
                                wire:navigate 
                                variant="primary" 
                                class="px-6 py-2 text-sm"
                            >
                                Create Account
                            </flux:button>
                        </div>
                    </div>
                @else
                    <!-- No Account Selected -->
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                        <div class="px-4 py-8 text-center">
                            <flux:icon name="credit-card" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                            <h3 class="text-lg font-medium text-gray-900 mb-2">No Account Selected</h3>
                            <p class="text-sm text-gray-600 mb-6">Select an account from the list to manage its settings and limits.</p>
                            
                            <div class="flex justify-center space-x-3">
                                <flux:button 
                                    icon="plus" 
                                    href="{{ route('account.create') }}" 
                                    wire:navigate 
                                    variant="primary" 
                                    class="px-6 py-2 text-sm"
                                >
                                    Create Account
                                </flux:button>
                                
                                <flux:button 
                                    icon="arrow-left" 
                                    wire:click="$dispatch('refresh')" 
                                    variant="outline" 
                                    class="px-6 py-2 text-sm"
                                >
                                    Refresh
                                </flux:button>
                            </div>
                        </div>
                    </div>
                @endif
            @endif
        </div>
    </div>
</div>

<script>
document.addEventListener('livewire:navigated', () => {
    Livewire.on('$refresh', () => {
        window.location.reload();
    });
});
</script>
