<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Account History
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">View your master account transaction history</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            <flux:button icon="arrow-left" variant="ghost" size="sm" class="flex items-center gap-1 px-2.5 py-1 text-xs" href="{{ route('dashboard') }}" wire:navigate>
                Back to Dashboard
            </flux:button>
        </div>
    </div>

    @if($masterAccount)
        <!-- Account Info Card -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-1">{{ $masterAccount->account_name }}</h3>
                    <p class="text-xs text-gray-600">Account: {{ $masterAccount->account_number }}</p>
                </div>
                <div class="text-right">
                    <p class="text-lg font-bold text-gray-900">{{ \App\Helpers\CurrencyHelper::format((float)$currentBalance, $currency) }}</p>
                    <p class="text-xs text-gray-600">Available: {{ \App\Helpers\CurrencyHelper::format((float)$availableBalance, $currency) }}</p>
                </div>
            </div>
        </div>

        <!-- Filters Section -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                    Filter Transactions
                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                </h3>
                <flux:button variant="ghost" size="sm" wire:click="clearFilters" class="text-xs">
                    Clear Filters
                </flux:button>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <!-- Transaction Type -->
                <flux:field>
                    <flux:label>Transaction Type</flux:label>
                    <flux:select wire:model.live="transactionType" placeholder="All Types">
                        <option value="">All Types</option>
                        <option value="deposit">Deposit</option>
                        <option value="withdrawal">Withdrawal</option>
                        <option value="transfer">Transfer</option>
                        <option value="payment">Payment</option>
                        <option value="fee">Fee</option>
                        <option value="interest">Interest</option>
                        <option value="refund">Refund</option>
                    </flux:select>
                </flux:field>

                <!-- Status -->
                <flux:field>
                    <flux:label>Status</flux:label>
                    <flux:select wire:model.live="status" placeholder="All Statuses">
                        <option value="">All Statuses</option>
                        <option value="completed">Completed</option>
                        <option value="pending">Pending</option>
                        <option value="failed">Failed</option>
                        <option value="cancelled">Cancelled</option>
                        <option value="processing">Processing</option>
                    </flux:select>
                </flux:field>

                <!-- Date Range -->
                <div class="flex gap-2">
                    <flux:field>
                        <flux:date-picker wire:model.live="dateFrom" placeholder="From Date" selectable-header />
                    </flux:field>
                    <flux:field>
                        <flux:date-picker wire:model.live="dateTo" placeholder="To Date" selectable-header />
                    </flux:field>
                </div>

                <!-- Amount Range -->
                <div class="flex gap-2">
                    <flux:field>
                        <flux:input wire:model.live="amountFrom" type="number" step="0.01" placeholder="Min Amount" />
                    </flux:field>
                    <flux:field>
                        <flux:input wire:model.live="amountTo" type="number" step="0.01" placeholder="Max Amount" />
                    </flux:field>
                </div>
            </div>
        </div>

        <!-- Transactions Table -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                    Transaction History
                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                </h3>
                <p class="text-xs text-gray-600 mt-1.5">Showing {{ $transactions ? $transactions->count() : 0 }} of {{ $transactions ? $transactions->total() : 0 }} transactions</p>
            </div>

            <!-- Desktop Table -->
            <div class="hidden md:block overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transaction</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($transactions ?? [] as $transaction)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center">
                                            <flux:icon name="{{ $this->getTransactionTypeIcon($transaction->type) }}" class="w-5 h-5 {{ $this->getTransactionTypeColor($transaction->type) }}" />
                                        </div>
                                        <div class="ml-3">
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ $transaction->description ?: $this->getTransactionTypeLabel($transaction->type) }}
                                            </div>
                                            <div class="text-sm text-gray-500">{{ $transaction->transaction_id }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm text-gray-900">{{ $this->getTransactionTypeLabel($transaction->type) }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm font-semibold {{ $this->getTransactionAmountColor($transaction) }}">
                                        {{ $this->getTransactionAmount($transaction) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($transaction->status) }}">
                                        <flux:icon name="{{ $this->getStatusIcon($transaction->status) }}" class="w-3 h-3 mr-1" />
                                        {{ $this->getStatusLabel($transaction->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $transaction->created_at->format('M j, Y') }}
                                    <div class="text-xs">{{ $transaction->created_at->format('h:i A') }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <flux:modal.trigger name="transaction-details-{{ $transaction->id }}">
                                        <flux:button variant="outline" size="sm" class="text-xs">
                                            View Details
                                        </flux:button>
                                    </flux:modal.trigger>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-12 text-center">
                                    <div class="flex flex-col items-center">
                                        <flux:icon name="clock" class="w-12 h-12 text-gray-300 mb-4" />
                                        <h3 class="text-sm font-medium text-gray-900 mb-1">No transactions found</h3>
                                        <p class="text-sm text-gray-500">Your transaction history will appear here</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Mobile Cards -->
            <div class="md:hidden divide-y divide-gray-200">
                @forelse($transactions ?? [] as $transaction)
                    <div class="p-4">
                        <div class="flex items-center justify-between mb-3">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center">
                                    <flux:icon name="{{ $this->getTransactionTypeIcon($transaction->type) }}" class="w-5 h-5 {{ $this->getTransactionTypeColor($transaction->type) }}" />
                                </div>
                                <div class="ml-3 flex-1">
                                    <p class="text-sm font-medium text-gray-900">
                                        {{ $transaction->description ?: $this->getTransactionTypeLabel($transaction->type) }}
                                    </p>
                                    <p class="text-sm text-gray-500">{{ $transaction->transaction_id }}</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-semibold {{ $this->getTransactionAmountColor($transaction) }}">
                                    {{ $this->getTransactionAmount($transaction) }}
                                </p>
                                <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($transaction->status) }}">
                                    {{ $this->getStatusLabel($transaction->status) }}
                                </span>
                            </div>
                        </div>
                        <div class="flex items-center justify-between text-xs text-gray-500">
                            <span>{{ $transaction->created_at->format('M j, Y h:i A') }}</span>
                            <flux:modal.trigger name="transaction-details-{{ $transaction->id }}">
                                <flux:button variant="outline" size="sm" class="text-xs">
                                    View Details
                                </flux:button>
                            </flux:modal.trigger>
                        </div>
                    </div>
                @empty
                    <div class="p-8 text-center">
                        <flux:icon name="clock" class="w-12 h-12 text-gray-300 mb-4 mx-auto" />
                        <h3 class="text-sm font-medium text-gray-900 mb-1">No transactions found</h3>
                        <p class="text-sm text-gray-500">Your transaction history will appear here</p>
                    </div>
                @endforelse
            </div>

            <!-- Pagination -->
            @if($transactions && $transactions->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $transactions->links() }}
                </div>
            @endif
        </div>

        <!-- Transaction Details Modals -->
        @foreach($transactions ?? [] as $transaction)
            <flux:modal name="transaction-details-{{ $transaction->id }}" class="md:w-128">
                <div class="space-y-6">
                    <div>
                        <flux:heading size="lg">Transaction Details</flux:heading>
                        <flux:text class="mt-2">Transaction ID: {{ $transaction->transaction_id }}</flux:text>
                    </div>

                    <div class="space-y-4">
                        <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                            <h3 class="text-sm font-semibold text-gray-900">Transaction Information</h3>
                            <div class="space-y-2">
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Amount:</span>
                                    <span class="text-sm font-medium {{ $this->getTransactionAmountColor($transaction) }}">
                                        {{ $this->getTransactionAmount($transaction) }}
                                    </span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Type:</span>
                                    <span class="text-sm font-medium text-gray-900">
                                        {{ $this->getTransactionTypeLabel($transaction->type) }}
                                    </span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Status:</span>
                                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($transaction->status) }}">
                                        <flux:icon name="{{ $this->getStatusIcon($transaction->status) }}" class="w-3 h-3 mr-1" />
                                        {{ $this->getStatusLabel($transaction->status) }}
                                    </span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Date:</span>
                                    <span class="text-sm font-medium text-gray-900">
                                        {{ $transaction->created_at->format('M j, Y h:i A') }}
                                    </span>
                                </div>
                                @if($transaction->description)
                                    <div class="flex justify-between">
                                        <span class="text-sm text-gray-600">Description:</span>
                                        <span class="text-sm font-medium text-gray-900">{{ $transaction->description }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex justify-end pt-4">
                        <flux:button 
                            variant="outline" 
                            x-on:click="$dispatch('modal-close', { name: 'transaction-details-{{ $transaction->id }}' })"
                        >
                            Close
                        </flux:button>
                    </div>
                </div>
            </flux:modal>
        @endforeach

    @else
        <!-- No Master Account Info -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-8 text-center">
            <flux:icon name="exclamation-triangle" class="w-16 h-16 text-amber-500 mx-auto mb-4" />
            <h3 class="text-lg font-semibold text-gray-900 mb-2">No Master Account Found</h3>
            <p class="text-sm text-gray-600 mb-6">
                You don't have a master account set up. Please contact support to set up your master account.
            </p>
            <flux:button variant="primary" href="{{ route('user.account.settings') }}" wire:navigate>
                Go to Account Settings
            </flux:button>
        </div>
    @endif

    <!-- Switch Account Info -->
    <div class="bg-blue-50 border border-blue-200 rounded-xl p-4 mt-6">
        <div class="flex items-start">
            <flux:icon name="information-circle" class="w-5 h-5 text-blue-600 mt-0.5 mr-3 flex-shrink-0" />
            <div class="flex-1">
                <h4 class="text-sm font-medium text-blue-900 mb-1">View Other Account History</h4>
                <p class="text-sm text-blue-700 mb-3">
                    This page shows only your master account history. To view transaction history for other accounts, 
                    please switch to the desired account in your account settings.
                </p>
                <flux:button 
                    variant="primary" 
                    size="sm" 
                    href="{{ route('user.account.settings') }}" 
                    wire:navigate
                    class="text-xs"
                >
                    Go to Account Settings
                </flux:button>
            </div>
        </div>
    </div>
</div>
