<div>

    @if(count($breadcrumbs) > 1)
        <nav class="mb-6" aria-label="Breadcrumb">
            <ol class="flex items-center space-x-2 text-sm text-gray-600">
                @foreach($breadcrumbs as $index => $breadcrumb)
                    <li class="flex items-center">
                        @if($index > 0)
                            <flux:icon name="chevron-right" class="w-4 h-4 text-gray-400 mx-2" />
                        @endif
                        
                        @if($breadcrumb['url'] && $index < count($breadcrumbs) - 1)
                            <a href="{{ $breadcrumb['url'] }}" 
                               class="flex items-center space-x-1 text-[#04327c] hover:text-[#032a6a] transition-colors"
                               wire:navigate>
                                <flux:icon name="{{ $breadcrumb['icon'] }}" class="w-4 h-4" />
                                <span>{{ $breadcrumb['name'] }}</span>
                            </a>
                        @else
                            <span class="flex items-center space-x-1 text-gray-900 font-medium">
                                <flux:icon name="{{ $breadcrumb['icon'] }}" class="w-4 h-4" />
                                <span>{{ $breadcrumb['name'] }}</span>
                            </span>
                        @endif
                    </li>
                @endforeach
            </ol>
        </nav>
    @endif
</div>
