<div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
    <!-- Logo -->
    <div class="px-4 py-3 text-center border-b border-gray-100">
        <div class="flex items-center justify-center">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-12 w-auto">
        </div>
    </div>

    <!-- Email Verification Form -->
    <div class="px-4 py-4">
        <div class="text-center mb-4">
            <div class="mx-auto h-12 w-12 bg-blue-100 rounded-full flex items-center justify-center mb-3">
                <flux:icon name="envelope" class="h-6 w-6 text-blue-600" />
            </div>
            <h2 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Verify Your Email
                <div class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h2>
            <p class="text-xs text-gray-600 mt-2">
                @if($codeSent)
                    Enter the 6-digit verification code sent to your email address.
                @else
                    Click the button below to receive a verification code via email.
                @endif
            </p>
        </div>

        @if($codeSent)
            <!-- Verification Code Form -->
            <form wire:submit="verifyCode" class="space-y-4">
                <div>
                    <flux:input
                        wire:model="verificationCode"
                        label="Verification Code"
                        type="text"
                        maxlength="6"
                        placeholder="000000"
                        class="text-center text-lg tracking-widest"
                        :disabled="$isLoading"
                        autofocus
                    />
                    <flux:error name="verificationCode" />
                </div>

                <!-- Attempts Counter -->
                @if($attempts > 0)
                    <div class="text-center">
                        <p class="text-xs text-amber-600">
                            Failed attempts: {{ $attempts }}/{{ $maxAttempts }}
                        </p>
                    </div>
                @endif

                <!-- Verify Button -->
                <flux:button 
                    type="submit" 
                    variant="primary" 
                    class="w-full py-2 text-sm"
                    :disabled="$isLoading || $attempts >= $maxAttempts"
                >
                    @if($isLoading)
                        <flux:icon name="arrow-path" class="w-4 h-4 mr-2 animate-spin" />
                        Verifying...
                    @else
                        Verify Email
                    @endif
                </flux:button>
            </form>

            <!-- Resend Code -->
            <div class="mt-4 text-center">
                <p class="text-xs text-gray-600 mb-2">Didn't receive the code?</p>
                <flux:button 
                    wire:click="resendCode" 
                    variant="outline" 
                    size="sm"
                    :disabled="$resendCooldown > 0"
                    class="text-xs"
                >
                    @if($resendCooldown > 0)
                        Resend in {{ $resendCooldown }}s
                    @else
                        Resend Code
                    @endif
                </flux:button>
            </div>
        @else
            <!-- Send Code Button -->
            <div class="space-y-4">
                <flux:button 
                    wire:click="sendVerificationCode" 
                    variant="primary" 
                    class="w-full py-2 text-sm"
                >
                    <flux:icon name="envelope" class="w-4 h-4 mr-2" />
                    Send Verification Code
                </flux:button>
            </div>
        @endif

        <!-- Logout Button -->
        <div class="mt-4 text-center">
            <flux:link class="text-xs text-[#04327c] hover:text-[#032a6a] font-medium" wire:click="logout">
                {{ __('Log out') }}
            </flux:link>
        </div>

        <!-- Help Information -->
        <div class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
            <div class="flex items-start">
                <flux:icon name="information-circle" class="w-4 h-4 text-blue-600 mt-0.5 mr-2 flex-shrink-0" />
                <div>
                    <h4 class="text-xs font-medium text-blue-800 mb-1">
                        Didn't receive the code?
                    </h4>
                    <ul class="text-xs text-blue-700 space-y-0.5">
                        <li>• Check your spam or junk folder</li>
                        <li>• Make sure the email address is correct</li>
                        <li>• Wait a few minutes for delivery</li>
                        <li>• Click "Resend Code" above</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Security Notice -->
        <div class="mt-4 p-3 bg-amber-50 border border-amber-200 rounded-lg">
            <div class="flex items-start">
                <flux:icon name="exclamation-triangle" class="w-4 h-4 text-amber-600 mt-0.5 mr-2 flex-shrink-0" />
                <div>
                    <h4 class="text-xs font-medium text-amber-800">
                        Why verify your email?
                    </h4>
                    <p class="text-xs text-amber-700 mt-0.5">
                        Email verification helps protect your account and ensures we can contact you about important account activities.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('livewire:init', () => {
    Livewire.on('start-resend-countdown', () => {
        let cooldown = 60;
        const interval = setInterval(() => {
            cooldown--;
            @this.set('resendCooldown', cooldown);
            
            if (cooldown <= 0) {
                clearInterval(interval);
            }
        }, 1000);
    });
});
</script>
