<div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
    <!-- Logo -->
    <div class="px-4 py-3 text-center border-b border-gray-100">
        <div class="flex items-center justify-center">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-12 w-auto">
        </div>
    </div>

    <!-- Registration Form -->
    <div class="px-4 py-4">
        <div class="text-left mb-4">
            <h2 class="text-base font-bold text-gray-900 mb-1 relative">
                Registration Form
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h2>
            <p class="text-xs text-gray-600 mt-1.5">Create your banking account</p>
        </div>

        <form method="POST" wire:submit="createAccount" class="space-y-4">
            @csrf
            <x-honeypot livewire-model="extraFields" />
            

            <!-- Display general errors -->
            @if ($errors->any())
                <div class="bg-red-50 border border-red-200 rounded-lg p-3 mb-4">
                    <div class="flex">
                        <flux:icon name="exclamation-triangle" class="w-5 h-5 text-red-400 mt-0.5 mr-2" />
                        <div class="text-sm">
                            <p class="font-medium text-red-800">Please correct the following errors:</p>
                            <ul class="mt-1 text-red-700 list-disc list-inside">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Registration Fields -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                <!-- Customer Type Selection -->
                <div>
                    <flux:select
                        wire:model.live="customer_type"
                        :label="__('Customer Type')"
                        required
                        class="w-full text-sm"
                    >
                        <option value="individual">Individual Account</option>
                    </flux:select>
                </div>

                <!-- Email -->
                <div>
                    <flux:input
                        wire:model="email"
                        :label="__('Email')"
                        type="email"
                        required
                        autocomplete="email"
                        placeholder="Enter your email"
                        class="w-full text-sm"
                        icon:leading="envelope"
                    />
                    @error('email')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Full Name -->
                <div>
                    <flux:input
                        wire:model="name"
                        :label="__('Full Name')"
                        type="text"
                        required
                        autocomplete="name"
                        placeholder="Enter your full name"
                        class="w-full text-sm"
                        icon:leading="user"
                    />
                    @error('name')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Username -->
                <div>
                    <flux:input
                        wire:model="username"
                        :label="__('Username')"
                        type="text"
                        required
                        autocomplete="username"
                        placeholder="Choose a unique username"
                        class="w-full text-sm"
                        icon:leading="at-symbol"
                    />
                    @error('username')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div>
                    <flux:input
                        wire:model="password"
                        :label="__('Password')"
                        type="password"
                        required
                        autocomplete="new-password"
                        placeholder="Enter your password"
                        class="w-full text-sm"
                        icon:leading="lock-closed"
                    />
                    @error('password')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Confirm Password -->
                <div>
                    <flux:input
                        wire:model="password_confirmation"
                        :label="__('Confirm Password')"
                        type="password"
                        required
                        autocomplete="new-password"
                        placeholder="Confirm your password"
                        class="w-full text-sm"
                        icon:leading="lock-closed"
                    />
                </div>

                <!-- PIN -->
                <div>
                    <flux:input
                        wire:model="pin"
                        :label="__('6-Digit PIN')"
                        type="password"
                        required
                        maxlength="6"
                        inputmode="numeric"
                        pattern="[0-9]{6}"
                        placeholder="Enter 6-digit PIN (for transactions)"
                        class="w-full text-sm"
                        icon:leading="key"
                    />
                    <p class="text-xs text-gray-500 mt-0.5">This PIN will be used for secure transactions</p>
                    @error('pin')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Confirm PIN -->
                <div>
                    <flux:input
                        wire:model="pin_confirmation"
                        :label="__('Confirm PIN')"
                        type="password"
                        required
                        maxlength="6"
                        inputmode="numeric"
                        pattern="[0-9]{6}"
                        placeholder="Confirm your 6-digit PIN"
                        class="w-full text-sm"
                        icon:leading="key"
                    />
                    @error('pin_confirmation')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex items-center justify-between pt-4 border-t border-gray-100 mt-4">
                <flux:button variant="primary" type="submit" class="px-6 py-2 text-sm">
                    {{ __('Register') }}
                </flux:button>
                <div class="text-xs text-gray-600">
                    {{ __('Already have an account?') }}
                    <flux:link :href="route('login')" class="text-[#04327c] hover:text-[#032a6a] font-medium" wire:navigate>
                        {{ __('Login') }}
                    </flux:link>
                </div>
            </div>
    </form>
    </div>
</div>
