<div class="bg-gray-50 flex items-center justify-center py-4 px-4 sm:px-4 lg:px-4">
    <div class="w-full space-y-8">
        @if(!$accountCreated)
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <!-- Account Creation Form -->
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h2 class="text-base font-bold text-gray-900 mb-0.5 relative">
                            Create Your Banking Account
                            <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
                        </h2>
                        <p class="text-xs text-gray-600 mt-1.5">Set up your primary banking account</p>
                    </div>

                    <form wire:submit="createAccount" class="space-y-4">
                        <!-- Account Type -->
                        <div>
                            <flux:select
                                wire:model.live="account_type"
                                :label="__('Account Type')"
                                required
                                class="w-full text-sm"
                            >
                                <option value="savings">Savings Account</option>
                                <option value="checking">Checking Account</option>
                                <option value="business">Business Account</option>
                                <option value="offshore">Offshore Account</option>
                            </flux:select>
                        </div>

                        <!-- Account Name -->
                        <div>
                            <flux:input
                                wire:model="account_name"
                                :label="__('Account Name')"
                                type="text"
                                required
                                placeholder="Enter account name"
                                class="w-full text-sm"
                                icon:leading="user"
                            />
                        </div>

                        <!-- Currency Selection -->
                        <div>
                            <flux:fieldset>
                                <flux:legend class="text-sm font-medium text-gray-700">Currency</flux:legend>
                                <div class="grid grid-cols-3 gap-2 mt-2">
                                    <!-- USD -->
                                    <label class="relative flex cursor-pointer rounded-lg border p-3 focus:outline-none {{ $currency === 'USD' ? 'border-[#04327c] bg-blue-50' : 'border-gray-200 hover:border-gray-300' }}">
                                        <input type="radio" wire:model.live="currency" value="USD" class="sr-only">
                                        <div class="flex flex-col items-center text-center">
                                            <span class="text-lg font-bold text-gray-900">$</span>
                                            <span class="text-xs font-medium text-gray-700">USD</span>
                                            <span class="text-xs text-gray-500">Dollar</span>
                                        </div>
                                    </label>

                                    <!-- EUR -->
                                    <label class="relative flex cursor-pointer rounded-lg border p-3 focus:outline-none {{ $currency === 'EUR' ? 'border-[#04327c] bg-blue-50' : 'border-gray-200 hover:border-gray-300' }}">
                                        <input type="radio" wire:model.live="currency" value="EUR" class="sr-only">
                                        <div class="flex flex-col items-center text-center">
                                            <span class="text-lg font-bold text-gray-900">€</span>
                                            <span class="text-xs font-medium text-gray-700">EUR</span>
                                            <span class="text-xs text-gray-500">Euro</span>
                                        </div>
                                    </label>

                                    <!-- GBP -->
                                    <label class="relative flex cursor-pointer rounded-lg border p-3 focus:outline-none {{ $currency === 'GBP' ? 'border-[#04327c] bg-blue-50' : 'border-gray-200 hover:border-gray-300' }}">
                                        <input type="radio" wire:model.live="currency" value="GBP" class="sr-only">
                                        <div class="flex flex-col items-center text-center">
                                            <span class="text-lg font-bold text-gray-900">£</span>
                                            <span class="text-xs font-medium text-gray-700">GBP</span>
                                            <span class="text-xs text-gray-500">Pound</span>
                                        </div>
                                    </label>
                                </div>
                            </flux:fieldset>
                        </div>

                        <!-- Description -->
                        <div>
                            <flux:textarea
                                wire:model="description"
                                :label="__('Description (Optional)')"
                                placeholder="Add a description for your account"
                                rows="3"
                                class="w-full text-sm"
                            />
                        </div>

                        <!-- Account Summary -->
                        <div class="bg-gray-50 border border-gray-200 rounded-lg p-3">
                            <h4 class="text-xs font-medium text-gray-800 mb-2">Account Summary</h4>
                            <div class="space-y-1 text-xs text-gray-600">
                                <div class="flex justify-between">
                                    <span>Type:</span>
                                    <span class="font-medium">{{ ucfirst($account_type) }} Account</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Currency:</span>
                                    <span class="font-medium">{{ $this->currency_symbol }} {{ $this->currency_name }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Status:</span>
                                    <span class="font-medium text-amber-600">Pending Verification</span>
                                </div>
                            </div>
                        </div>

                        <!-- Action Button -->
                        <div class="pt-4 border-t border-gray-100">
                            <flux:button type="submit" variant="primary" class="w-full py-2 text-sm">
                                <div class="flex items-center justify-center">
                                    Create Account
                                    <flux:icon.plus class="w-4 h-4 ml-2" />
                                </div>
                            </flux:button>
                        </div>
                    </form>
                </div>
            </div>
        @else
            <!-- Success Section -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <!-- Success Content -->
                <div class="px-4 py-6">
                    <div class="text-center">
                        <div class="mx-auto h-16 w-16 bg-green-100 rounded-full flex items-center justify-center mb-4">
                            <flux:icon name="check-circle" class="h-8 w-8 text-green-600" />
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-2">
                            Account Created Successfully!
                        </h3>
                        <p class="text-sm text-gray-600 mb-6">
                            Your {{ strtolower($createdAccount->account_type) }} account has been created and is pending verification.
                        </p>

                        <!-- Account Details -->
                        <div class="bg-gray-50 border border-gray-200 rounded-lg p-4 mb-6">
                            <h4 class="text-sm font-medium text-gray-800 mb-3">Account Details</h4>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Account Number:</span>
                                    <span class="font-mono font-medium">{{ $createdAccount->account_number }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Account Name:</span>
                                    <span class="font-medium">{{ $createdAccount->account_name }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Currency:</span>
                                    <span class="font-medium">{{ $this->currency_symbol }} {{ $this->currency_name }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Status:</span>
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-amber-100 text-amber-800">
                                        Pending Verification
                                    </span>
                                </div>
                            </div>
                        </div>

                        <flux:button wire:click="proceedToDashboard" variant="primary" class="px-6 py-2">
                            <div class="flex items-center">
                                Go to Dashboard
                                <flux:icon.arrow-right class="w-4 h-4 ml-2" />
                            </div>
                        </flux:button>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
