@extends('errors.layout')

@section('title', 'Page Expired')

@section('content')
<div class="space-y-6">
    <!-- Error Header -->
    <div class="text-center">
        <div class="mx-auto h-20 w-20 bg-orange-100 rounded-full flex items-center justify-center mb-4">
            <svg class="h-10 w-10 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
        </div>
        <h1 class="text-5xl font-bold text-gray-900 mb-2">419</h1>
        <h2 class="text-xl font-semibold text-gray-800 mb-2">Page Expired</h2>
        <p class="text-gray-600">Your session has expired due to inactivity.</p>
    </div>

    <!-- Error Details Card -->
    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-orange-100 text-orange-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">⏰</span>
            What happened?
        </h3>
        <div class="space-y-3 text-sm text-gray-600">
            <p>• Your session expired due to inactivity</p>
            <p>• This is a security measure to protect your account</p>
            <p>• Your data remains safe and secure</p>
        </div>
    </div>

    <!-- Action Card -->
    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">🔄</span>
            What can you do?
        </h3>
        <div class="space-y-4">
            <div class="flex flex-col sm:flex-row gap-3">
                <button onclick="window.location.reload()" 
                        class="flex-1 inline-flex items-center justify-center px-4 py-3 border border-transparent text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                    </svg>
                    Refresh Page
                </button>
                <a href="{{ route('login') }}" 
                   class="flex-1 inline-flex items-center justify-center px-4 py-3 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                    </svg>
                    Login Again
                </a>
            </div>
        </div>
    </div>

    <!-- Security Notice -->
    <div class="bg-green-50 border border-green-200 rounded-lg p-4">
        <div class="flex items-start">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-green-800">Security Feature</h3>
                <div class="mt-2 text-sm text-green-700">
                    <p>This timeout helps protect your account from unauthorized access. Your data remains secure.</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
