@extends('errors.layout')

@section('title', 'Page Not Found')

@section('content')
<div class="space-y-6">
    <!-- Error Header -->
    <div class="text-center">
        <div class="mx-auto h-20 w-20 bg-red-100 rounded-full flex items-center justify-center mb-4">
            <svg class="h-10 w-10 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
            </svg>
        </div>
        <h1 class="text-5xl font-bold text-gray-900 mb-2">404</h1>
        <h2 class="text-xl font-semibold text-gray-800 mb-2">Page Not Found</h2>
        <p class="text-gray-600">The page you're looking for doesn't exist or has been moved.</p>
    </div>

    <!-- Error Details Card -->
    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-red-100 text-red-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">!</span>
            What happened?
        </h3>
        <div class="space-y-3 text-sm text-gray-600">
            <p>• The page may have been moved or deleted</p>
            <p>• You may have entered an incorrect URL</p>
            <p>• The link you followed might be outdated</p>
        </div>
    </div>

    <!-- Action Card -->
    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">→</span>
            What can you do?
        </h3>
        <div class="space-y-4">
            <div class="flex flex-col sm:flex-row gap-3">
                <a href="{{ route('dashboard') }}" 
                   class="flex-1 inline-flex items-center justify-center px-4 py-3 border border-transparent text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Go to Dashboard
                </a>
                <button onclick="history.back()" 
                        class="flex-1 inline-flex items-center justify-center px-4 py-3 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Go Back
                </button>
            </div>
        </div>
    </div>

    <!-- Help Section -->
    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
        <div class="flex items-start">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">Still need help?</h3>
                <div class="mt-2 text-sm text-blue-700">
                    <p>If you continue to experience issues, please contact our support team.</p>
                    <div class="mt-2 flex space-x-4">
                        <a href="#" class="font-medium hover:text-blue-600">Contact Support</a>
                        <a href="#" class="font-medium hover:text-blue-600">Help Center</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
