@component('mail::message')
# Password Reset

Hello {{ $user->name }},

We received a request to reset your password for your {{ $bankName }} account. To proceed with resetting your password, please use the verification code below.

@component('mail::panel')
## Your Password Reset Code

<div style="text-align: center; margin: 30px 0;">
    <div style="background: #f1f5f9; border: 2px dashed #dc2626; border-radius: 12px; padding: 30px; margin: 20px 0;">
        <p style="margin: 0 0 15px; font-weight: 600; color: #374151;">Your password reset code is:</p>
        <div style="font-size: 36px; font-weight: bold; color: #dc2626; letter-spacing: 8px; font-family: 'Courier New', monospace;">{{ $code }}</div>
        <p style="margin: 15px 0 0; font-size: 14px; color: #6b7280;">Enter this code in the password reset form</p>
    </div>
</div>
@endcomponent

## 📋 How to reset your password:

1. Return to the password reset page in your browser
2. Enter the 6-digit code shown above
3. Create a new strong password
4. Confirm your new password and save

## ⚠️ Security Notice:

- This code expires in **15 minutes**
- Never share this code with anyone
- {{ $bankName }} will never ask for this code via phone or email
- If you didn't request this reset, please contact support immediately
- Choose a strong, unique password that you haven't used before

If you didn't request a password reset, you can safely ignore this email. Your password will remain unchanged.

Thanks,<br>
{{ $bankName }} Team
@endcomponent
