<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Thank you for contacting {{ $bank_name }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #1e3a8a;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 5px 5px 0 0;
        }
        .content {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 0 0 5px 5px;
        }
        .highlight {
            background-color: #e3f2fd;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #1e3a8a;
            margin: 20px 0;
        }
        .contact-info {
            background-color: white;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Thank You for Contacting Us!</h1>
        <p>{{ $bank_name }}</p>
    </div>
    
    <div class="content">
        <p>Dear {{ $first_name }},</p>
        
        <p>Thank you for reaching out to us. We have received your message regarding "<strong>{{ $subject }}</strong>" and our team will review it carefully.</p>
        
        <div class="highlight">
            <h3>What happens next?</h3>
            <ul>
                <li>We will review your message within 24 hours</li>
                <li>Our team will respond to your inquiry within 1-2 business days</li>
                <li>If your inquiry is urgent, please call us directly</li>
            </ul>
        </div>
        
        <div class="contact-info">
            <h3>Need immediate assistance?</h3>
            <p><strong>Phone:</strong> {{ $bank_phone ?? 'Contact us for phone number' }}</p>
            <p><strong>Email:</strong> {{ $bank_email }}</p>
            <p><strong>Online Banking:</strong> Available 24/7 at our website</p>
        </div>
        
        <p>We appreciate your interest in {{ $bank_name }} and look forward to serving you.</p>
        
        <p>Best regards,<br>
        The {{ $bank_name }} Team</p>
    </div>
    
    <div class="footer">
        <p>This is an automated message. Please do not reply to this email.</p>
        <p>&copy; {{ date('Y') }} {{ $bank_name }}. All rights reserved.</p>
    </div>
</body>
</html>
