@component('mail::message')
# {{ $notification->title }}

Hello {{ $user->name }},

{{ $notification->message }}

@if($notification->type === 'account_created' && $notification->data)
@component('mail::panel')
## Account Details
- **Account Number:** {{ $notification->data['account_number'] ?? 'N/A' }}
- **Account Type:** {{ ucfirst($notification->data['account_type'] ?? 'N/A') }}
- **Currency:** {{ $notification->data['currency'] ?? 'N/A' }}
- **Account Status:** {{ $notification->data['is_master_account'] ? 'Master Account' : 'Secondary Account' }}
- **Created On:** {{ isset($notification->data['created_at']) ? \Carbon\Carbon::parse($notification->data['created_at'])->format('F j, Y \a\t g:i A') : 'N/A' }}

**Next Steps:**
- Your account is currently pending verification
- You will receive another notification once verification is complete
- You can start using your account for basic transactions once verified
@endcomponent
@elseif($notification->type === 'virtual_card_created' && $notification->data)
@component('mail::panel')
## Virtual Card Details
- **Card Name:** {{ $notification->data['card_name'] ?? 'N/A' }}
- **Card Type:** {{ $notification->data['card_type'] ?? 'N/A' }}
- **Card Brand:** {{ ucfirst($notification->data['card_brand'] ?? 'N/A') }}
- **Last 4 Digits:** **** **** **** {{ $notification->data['last_four_digits'] ?? 'N/A' }}
- **Currency:** {{ $notification->data['currency'] ?? 'N/A' }}
- **Expiry Date:** {{ $notification->data['expiry_date'] ?? 'N/A' }}
- **Linked Account:** {{ $notification->data['account_number'] ?? 'N/A' }}
- **Created On:** {{ isset($notification->data['created_at']) ? \Carbon\Carbon::parse($notification->data['created_at'])->format('F j, Y \a\t g:i A') : 'N/A' }}

**Card Features:**
- Secure online transactions
- Real-time balance monitoring
- Instant funding from your master account
- 24/7 card management through your dashboard
- Multi-currency support
- Advanced fraud protection

**Security Reminders:**
- Never share your card details with anyone
- Always verify transactions before confirming
- Monitor your card activity regularly
- Report any suspicious activity immediately
@endcomponent
@elseif($notification->type === 'transfer_completed' && $notification->data)
@component('mail::panel')
## Transfer Details
- **Amount:** {{ number_format($notification->data['amount'] ?? 0, 2) }} {{ $notification->data['currency'] ?? 'N/A' }}
- **Recipient:** {{ $notification->data['recipient'] ?? 'N/A' }}
- **Reference Number:** {{ $notification->data['reference'] ?? 'N/A' }}
- **Completed On:** {{ isset($notification->data['completed_at']) ? \Carbon\Carbon::parse($notification->data['completed_at'])->format('F j, Y \a\t g:i A') : 'N/A' }}
@endcomponent
@elseif($notification->type === 'inter_account_transfer' && $notification->data)
@component('mail::panel')
## Transfer Details
- **Amount:** {{ number_format($notification->data['amount'] ?? 0, 2) }} {{ $notification->data['currency'] ?? 'N/A' }}
- **From Account:** {{ $notification->data['from_account'] ?? 'N/A' }}
- **To Account:** {{ $notification->data['to_account'] ?? 'N/A' }}
- **Transferred On:** {{ isset($notification->data['transferred_at']) ? \Carbon\Carbon::parse($notification->data['transferred_at'])->format('F j, Y \a\t g:i A') : 'N/A' }}
@endcomponent
@elseif($notification->type === 'cheque_deposit' && $notification->data)
@component('mail::panel')
## Cheque Deposit Details
- **Amount:** {{ number_format($notification->data['amount'] ?? 0, 2) }} {{ $notification->data['currency'] ?? 'N/A' }}
- **Status:** {{ ucfirst($notification->data['status'] ?? 'N/A') }}
- **Processed On:** {{ isset($notification->data['processed_at']) ? \Carbon\Carbon::parse($notification->data['processed_at'])->format('F j, Y \a\t g:i A') : 'N/A' }}
@endcomponent
@elseif($notification->type === 'login_ip_change' && $notification->data)
@component('mail::panel')
## Security Alert Details
- **IP Address:** {{ $notification->data['ip_address'] ?? 'N/A' }}
- **Location:** {{ $notification->data['location'] ?? 'Unknown' }}
- **Login Time:** {{ isset($notification->data['timestamp']) ? \Carbon\Carbon::parse($notification->data['timestamp'])->format('F j, Y \a\t g:i A') : 'N/A' }}

**If this wasn't you:**
- Change your password immediately
- Enable two-factor authentication
- Contact our support team
@endcomponent
@elseif($notification->data)
@component('mail::panel')
**Additional Details:**
@foreach($notification->data as $key => $value)
- **{{ ucfirst(str_replace('_', ' ', $key)) }}:** {{ is_array($value) ? json_encode($value) : $value }}
@endforeach
@endcomponent
@endif

@component('mail::button', ['url' => config('app.url') . '/dashboard'])
View Dashboard
@endcomponent

If you have any questions or concerns, please don't hesitate to contact our support team.

Thanks,<br>
{{ \App\Helpers\SettingsHelper::bankName() }} Team

---
*This is an automated message. Please do not reply to this email.*
@endcomponent
