<!-- Preloader Component -->
<div id="preloader" class="fixed inset-0 z-[9999] flex items-center justify-center bg-gradient-to-br from-[#04327c] via-[#032a6a] to-[#04327c]">
    <!-- Background Pattern -->
    <div class="absolute inset-0 opacity-40">
        <div class="w-full h-full" style="background-image: url('/images/bg-pattern.png'); background-repeat: repeat;"></div>
    </div>
    
    <!-- Loading Content -->
    <div class="relative z-10 flex flex-col items-center justify-center text-white">
        <!-- Bank Logo/Card -->
        <div class="mb-6">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-16 w-auto filter brightness-0 invert">
        </div>
        
        <!-- Loading Text -->
        <div class="text-center">
            <h2 class="text-xl font-semibold mb-2">{{ \App\Helpers\SettingsHelper::bankName() }}</h2>
            <p class="text-sm text-blue-200">Securing your financial future...</p>
        </div>
        
        <!-- Progress Bar -->
        <div class="w-64 bg-white bg-opacity-20 rounded-full h-1 mt-6">
            <div id="progress-bar" class="bg-[#F6DB77] h-1 rounded-full transition-all duration-300 ease-out" style="width: 0%"></div>
        </div>
    </div>
</div>

<script>
(function() {
    let currentInterval = null;

    function hidePreloader() {
        const preloader = document.getElementById('preloader');
        if (preloader) {
            preloader.style.opacity = '0';
            preloader.style.transition = 'opacity 0.5s ease-out';
            
            setTimeout(() => {
                preloader.style.display = 'none';
            }, 500);
        }
    }

    function clearCurrentInterval() {
        if (currentInterval) {
            clearInterval(currentInterval);
            currentInterval = null;
        }
    }

    // Show preloader on Livewire navigation start
    document.addEventListener('livewire:navigating', function() {
        clearCurrentInterval(); // Clear any existing interval
        
        const preloader = document.getElementById('preloader');
        if (preloader) {
            preloader.style.display = 'flex';
            preloader.style.opacity = '1';
            
            // Reset progress bar
            const progressBar = document.getElementById('progress-bar');
            if (progressBar) {
                progressBar.style.width = '0%';
                
                // Smooth progress animation
                let progress = 0;
                currentInterval = setInterval(() => {
                    progress += Math.random() * 8 + 2; // More consistent progress (2-10% increments)
                    if (progress >= 85) {
                        progress = 85; // Stop at 85% until navigation completes
                        clearCurrentInterval();
                    }
                    progressBar.style.width = progress + '%';
                }, 150); // Slower, smoother animation
            }
        }
    });

    // Hide preloader when Livewire navigation completes
    document.addEventListener('livewire:navigated', function() {
        clearCurrentInterval(); // Clear any running interval
        
        const preloader = document.getElementById('preloader');
        if (preloader) {
            const progressBar = document.getElementById('progress-bar');
            
            // Complete progress bar smoothly
            if (progressBar) {
                progressBar.style.width = '100%';
            }
            
            // Hide preloader after completion
            setTimeout(() => {
                hidePreloader();
            }, 200);
        }
    });

    // Initial page load handling
    document.addEventListener('DOMContentLoaded', function() {
        const preloader = document.getElementById('preloader');
        const progressBar = document.getElementById('progress-bar');
        
        if (preloader && progressBar) {
            // Animate progress bar for initial load
            let progress = 0;
            currentInterval = setInterval(() => {
                progress += Math.random() * 8 + 2;
                if (progress >= 100) {
                    progress = 100;
                    clearCurrentInterval();
                    
                    // Hide preloader after progress completes
                    setTimeout(() => {
                        hidePreloader();
                    }, 200);
                }
                progressBar.style.width = progress + '%';
            }, 120);
        }
    });

    // Fallback for regular page loads
    window.addEventListener('load', function() {
        setTimeout(() => {
            clearCurrentInterval();
            hidePreloader();
        }, 800);
    });
})();
</script>