@php
    $currentRoute = request()->route()->getName() ?? '';
    
    function isActiveNav($route, $currentRoute) {
        return $currentRoute === $route || str_starts_with($currentRoute, $route . '.');
    }
@endphp

<!-- Mobile Bottom Navigation -->
<nav class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 z-50">
    <div class="flex items-center justify-around py-1.5">
        <!-- Dashboard -->
        <a href="{{ route('dashboard') }}" 
           class="flex flex-col items-center py-1.5 px-2 rounded-lg transition-colors {{ isActiveNav('dashboard', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-600 hover:bg-gray-100' }}">
            <flux:icon name="home" class="w-5 h-5 {{ isActiveNav('dashboard', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
            <span class="text-xs mt-0.5 font-medium">Home</span>
        </a>

        <!-- Transfers -->
        <a href="{{ route('user.transfer.international') }}" 
           class="flex flex-col items-center py-1.5 px-2 rounded-lg transition-colors {{ isActiveNav('user.transfer', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-600 hover:bg-gray-100' }}">
            <flux:icon name="paper-airplane" class="w-5 h-5 {{ isActiveNav('user.transfer', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
            <span class="text-xs mt-0.5 font-medium">Transfer</span>
        </a>

        <!-- Account -->
        <a href="{{ route('user.account.history') }}" 
           class="flex flex-col items-center py-1.5 px-2 rounded-lg transition-colors {{ isActiveNav('user.account', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-600 hover:bg-gray-100' }}">
            <flux:icon name="clock" class="w-5 h-5 {{ isActiveNav('user.account', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
            <span class="text-xs mt-0.5 font-medium">Account</span>
        </a>

        <!-- Deposits -->
        <a href="{{ route('user.deposit.cheque') }}" 
           class="flex flex-col items-center py-1.5 px-2 rounded-lg transition-colors {{ isActiveNav('user.deposit', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-600 hover:bg-gray-100' }}">
            <flux:icon name="arrow-down-tray" class="w-5 h-5 {{ isActiveNav('user.deposit', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
            <span class="text-xs mt-0.5 font-medium">Deposit</span>
        </a>

        <!-- Profile -->
        <a href="{{ route('user.profile') }}" 
           class="flex flex-col items-center py-1.5 px-2 rounded-lg transition-colors {{ isActiveNav('user.profile', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-600 hover:bg-gray-100' }}">
            <flux:icon name="user" class="w-5 h-5 {{ isActiveNav('user.profile', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
            <span class="text-xs mt-0.5 font-medium">Profile</span>
        </a>
    </div>
</nav>
