<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        @include('partials.head')
    </head>
    <body class="min-h-screen bg-gray-50 antialiased">
        <!-- Preloader -->
        <x-preloader />
        
        <!-- Main Layout Container -->
        <div class="flex h-screen bg-gray-50">
            <!-- Sidebar -->
            @include('components.sidebar')
            
            <!-- Main Content Area -->
            <div class="flex-1 flex flex-col overflow-hidden transition-all duration-300 md:ml-64" id="main-content">
                <!-- Header -->
                <livewire:layout.header />
                
                <!-- Main Content -->
                <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 px-4 py-6">
                    <!-- Breadcrumb Navigation -->
                    <livewire:layout.navigation /> 
                    
                    <!-- Page Content -->
                    <div class="container mx-auto pb-20 md:pb-0">
                        {{ $slot }}
                    </div>
                </main>
            </div>
        </div>
        
        
        <!-- Mobile Bottom Navigation -->
        @include('components.mobile-bottom-nav')
        
        <!-- Toast Notifications -->
        @persist('toast')
            <flux:toast position="top-end" />
        @endpersist
        
        <!-- LiveChat Component -->
        <x-live-chat />
        
        @livewireScripts
        @fluxScripts
    </body>
</html>
