<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ \App\Helpers\SettingsHelper::bankFavicon() }}" sizes="any">
    <link rel="icon" href="{{ \App\Helpers\SettingsHelper::bankFavicon() }}" type="image/svg+xml">
    <link rel="apple-touch-icon" href="{{ \App\Helpers\SettingsHelper::bankFavicon() }}">

    <title>@yield('title', 'Admin Dashboard') - {{ \App\Helpers\SettingsHelper::bankName() }} Admin</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        [x-cloak] { display: none !important; }
        
        /* Hide scrollbar for main content */
        .scrollbar-hide {
            -ms-overflow-style: none;  /* Internet Explorer 10+ */
            scrollbar-width: none;  /* Firefox */
        }
        .scrollbar-hide::-webkit-scrollbar {
            display: none;  /* Safari and Chrome */
        }
        
        /* Custom styled scrollbar for mobile sidebar */
        .scrollbar-styled {
            scrollbar-width: thin;
            scrollbar-color: #cbd5e1 #f1f5f9;
        }
        .scrollbar-styled::-webkit-scrollbar {
            width: 6px;
        }
        .scrollbar-styled::-webkit-scrollbar-track {
            background: #f1f5f9;
            border-radius: 3px;
        }
        .scrollbar-styled::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }
        .scrollbar-styled::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
    </style>
</head>
<body class="min-h-screen bg-gray-50 antialiased">
    <!-- Main Layout Container -->
    <div class="flex h-screen bg-gray-50">
        <!-- Sidebar -->
        @include('components.admin.sidebar')
        
        <!-- Main Content Area -->
        <div class="flex-1 flex flex-col overflow-hidden transition-all duration-300" id="main-content">
            <!-- Header -->
            @include('components.admin.header')
            
            <!-- Main Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 px-4 py-6 scrollbar-styled">
                <!-- Page Content -->
                <div class="container mx-auto pb-20 md:pb-0">
                    @yield('content')
                </div>
            </main>
        </div>
    </div>

    <!-- Mobile Sidebar Overlay -->
    <div id="mobile-overlay" class="fixed inset-0 bg-gray-900/20 z-40 hidden md:hidden" onclick="toggleMobileSidebar()"></div>

    <!-- Mobile Sidebar -->
    @include('components.admin.mobile-sidebar')

    <script>
        function toggleProfileDropdown() {
            const dropdown = document.getElementById('profileDropdown');
            dropdown.classList.toggle('hidden');
        }

        // Close profile dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const profileDropdown = document.getElementById('profileDropdown');
            
            // Close profile dropdown
            if (!profileDropdown.contains(event.target) && !event.target.closest('[onclick="toggleProfileDropdown()"]')) {
                profileDropdown.classList.add('hidden');
            }
        });

        // Close profile dropdown when pressing Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                document.getElementById('profileDropdown').classList.add('hidden');
            }
        });
    </script>
    @fluxScripts
</body>
</html>
