@extends('components.layouts.admin')

@section('title', 'Virtual Card Details')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Virtual Card Details</h1>
            <p class="text-gray-600">View and manage virtual card information</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.virtual-cards.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Cards
            </flux:button>
            <flux:button href="{{ route('admin.virtual-cards.edit', $virtualCard) }}" class="text-xs">
                <flux:icon name="pencil" class="w-4 h-4 mr-2" />
                Edit Card
            </flux:button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Card Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Card Details -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Card Information</flux:heading>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Card Number</label>
                        <div class="flex items-center space-x-2">
                            <span class="text-lg font-mono font-semibold">{{ $virtualCard->masked_card_number }}</span>
                            <flux:button size="sm" variant="outline" onclick="copyToClipboard('{{ $virtualCard->card_number }}')">
                                <flux:icon name="clipboard" class="w-4 h-4" />
                            </flux:button>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">CVV</label>
                        <div class="flex items-center space-x-2">
                            <span class="text-lg font-mono font-semibold">***</span>
                            <form method="POST" action="{{ route('admin.virtual-cards.regenerate-cvv', $virtualCard) }}" class="inline">
                                @csrf
                                <flux:button icon="arrow-path" type="submit" size="sm" variant="outline">
                                    Regenerate
                                </flux:button>
                            </form>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Card Type</label>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                            {{ ucfirst($virtualCard->card_type) }}
                        </span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Card Brand</label>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                            {{ ucfirst($virtualCard->card_brand) }}
                        </span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Expiry Date</label>
                        <div class="flex items-center space-x-2">
                            <span class="text-lg font-semibold">{{ $virtualCard->expiry_date->format('M Y') }}</span>
                            @if($virtualCard->is_expired)
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                    Expired
                                </span>
                            @elseif($virtualCard->days_until_expiry <= 30)
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                    {{ $virtualCard->days_until_expiry }} days left
                                </span>
                            @endif
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Currency</label>
                        <span class="text-lg font-semibold">{{ $virtualCard->currency }}</span>
                    </div>

                    @if($virtualCard->card_name)
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Card Name</label>
                            <span class="text-lg font-semibold">{{ $virtualCard->card_name }}</span>
                        </div>
                    @endif
                </div>
            </flux:card>

            <!-- Financial Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Financial Information</flux:heading>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Current Balance</label>
                        <span class="text-2xl font-bold text-gray-900">{{ $virtualCard->formatted_current_balance }}</span>
                    </div>

                    @if($virtualCard->credit_limit)
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Credit Limit</label>
                            <span class="text-2xl font-bold text-gray-900">{{ $virtualCard->formatted_credit_limit }}</span>
                        </div>
                    @endif

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Daily Limit</label>
                        <span class="text-lg font-semibold">{{ $virtualCard->formatted_daily_limit }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Monthly Limit</label>
                        <span class="text-lg font-semibold">{{ $virtualCard->formatted_monthly_limit }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Total Spent</label>
                        <span class="text-lg font-semibold">{{ \App\Helpers\CurrencyHelper::getSymbol($virtualCard->currency) }}{{ number_format($virtualCard->total_spent, 2) }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Total Transactions</label>
                        <span class="text-lg font-semibold">{{ $virtualCard->total_transactions }}</span>
                    </div>
                </div>
            </flux:card>

            <!-- Features -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Card Features</flux:heading>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="flex items-center space-x-3">
                        <flux:icon name="{{ $virtualCard->online_payments ? 'check-circle' : 'x-circle' }}" 
                            class="w-6 h-6 {{ $virtualCard->online_payments ? 'text-green-500' : 'text-red-500' }}" />
                        <span class="text-sm font-medium">Online Payments</span>
                    </div>

                    <div class="flex items-center space-x-3">
                        <flux:icon name="{{ $virtualCard->atm_withdrawals ? 'check-circle' : 'x-circle' }}" 
                            class="w-6 h-6 {{ $virtualCard->atm_withdrawals ? 'text-green-500' : 'text-red-500' }}" />
                        <span class="text-sm font-medium">ATM Withdrawals</span>
                    </div>

                    <div class="flex items-center space-x-3">
                        <flux:icon name="{{ $virtualCard->international_usage ? 'check-circle' : 'x-circle' }}" 
                            class="w-6 h-6 {{ $virtualCard->international_usage ? 'text-green-500' : 'text-red-500' }}" />
                        <span class="text-sm font-medium">International Usage</span>
                    </div>
                </div>
            </flux:card>

            <!-- Recent Transactions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Recent Transactions</flux:heading>
                @if($recentTransactions->count() > 0)
                    <div class="space-y-4">
                        @foreach($recentTransactions as $transaction)
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                <div class="flex items-center space-x-4">
                                    <div class="flex-shrink-0">
                                        <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                            <flux:icon name="arrow-right" class="w-5 h-5 text-blue-600" />
                                        </div>
                                    </div>
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $transaction->description }}</div>
                                        <div class="text-sm text-gray-500">{{ $transaction->created_at->format('M d, Y H:i') }}</div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="text-sm font-medium {{ $transaction->amount > 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $transaction->amount > 0 ? '+' : '' }}{{ $virtualCard->currency_symbol }}{{ number_format(abs($transaction->amount), 2) }}
                                    </div>
                                    <div class="text-xs text-gray-500">{{ ucfirst($transaction->status) }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-500">
                        <flux:icon name="receipt-percent" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                        <p>No transactions found for this card.</p>
                    </div>
                @endif
            </flux:card>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Status Actions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Status Actions</flux:heading>
                <div class="space-y-3">
                    @if($virtualCard->status === 'active')
                        <form method="POST" action="{{ route('admin.virtual-cards.block', $virtualCard) }}">
                            @csrf
                            <flux:button icon="no-symbol" type="submit" variant="outline" class="w-full text-red-600 hover:text-red-700">
                                Block Card
                            </flux:button>
                        </form>
                        <form method="POST" action="{{ route('admin.virtual-cards.deactivate', $virtualCard) }}">
                            @csrf
                            <flux:button icon="pause" type="submit" variant="outline" class="w-full text-yellow-600 hover:text-yellow-700">
                                Deactivate Card
                            </flux:button>
                        </form>
                    @elseif($virtualCard->status === 'blocked')
                        <form method="POST" action="{{ route('admin.virtual-cards.unblock', $virtualCard) }}">
                            @csrf
                            <flux:button type="submit" class="w-full text-green-600 hover:text-green-700">
                                <flux:icon name="check" class="w-4 h-4 mr-2" />
                                Unblock Card
                            </flux:button>
                        </form>
                    @else
                        <form method="POST" action="{{ route('admin.virtual-cards.activate', $virtualCard) }}">
                            @csrf
                            <flux:button type="submit" class="w-full text-green-600 hover:text-green-700">
                                <flux:icon name="play" class="w-4 h-4 mr-2" />
                                Activate Card
                            </flux:button>
                        </form>
                    @endif
                </div>
            </flux:card>

            <!-- User Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Card Owner</flux:heading>
                <div class="space-y-3">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Name</label>
                        <p class="text-sm text-gray-900">{{ $virtualCard->user->name }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Email</label>
                        <p class="text-sm text-gray-900">{{ $virtualCard->user->email }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Account</label>
                        <p class="text-sm text-gray-900">{{ $virtualCard->account->account_number }}</p>
                    </div>
                    <flux:button href="{{ route('admin.users.show', $virtualCard->user) }}" variant="outline" class="w-full text-xs">
                        <flux:icon name="user" class="w-4 h-4 mr-2" />
                        View User Profile
                    </flux:button>
                </div>
            </flux:card>

            <!-- Card Statistics -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Card Statistics</flux:heading>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Created</span>
                        <span class="text-sm font-medium">{{ $virtualCard->created_at->format('M d, Y') }}</span>
                    </div>
                    @if($virtualCard->activated_at)
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Activated</span>
                            <span class="text-sm font-medium">{{ $virtualCard->activated_at->format('M d, Y') }}</span>
                        </div>
                    @endif
                    @if($virtualCard->last_used_at)
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Last Used</span>
                            <span class="text-sm font-medium">{{ $virtualCard->last_used_at->format('M d, Y') }}</span>
                        </div>
                    @endif
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Status</span>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                            {{ $virtualCard->status === 'active' ? 'bg-green-100 text-green-800' : 
                               ($virtualCard->status === 'blocked' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800') }}">
                            {{ ucfirst($virtualCard->status) }}
                        </span>
                    </div>
                </div>
            </flux:card>

            @if($virtualCard->notes)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">Notes</flux:heading>
                    <p class="text-sm text-gray-700">{{ $virtualCard->notes }}</p>
                </flux:card>
            @endif
        </div>
    </div>
</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // You could add a toast notification here
        console.log('Card number copied to clipboard');
    });
}
</script>
@endsection
