@extends('components.layouts.admin')

@section('title', 'Create Virtual Card')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Create Virtual Card</h1>
            <p class="text-gray-600">Create a new virtual card for a user</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.virtual-cards.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Cards
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.virtual-cards.store') }}" class="space-y-6">
        @csrf
        
        <!-- User and Account Selection -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">User and Account</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="user_id">User</flux:label>
                    <flux:select id="user_id" name="user_id" required>
                        <option value="">Select a user</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                {{ $user->name }} ({{ $user->email }})
                            </option>
                        @endforeach
                    </flux:select>
                    <flux:error name="user_id" />
                </flux:field>

                <flux:field>
                    <flux:label for="account_id">Account</flux:label>
                    <flux:select id="account_id" name="account_id" required>
                        <option value="">Select an account</option>
                        @foreach($accounts as $account)
                            <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                                {{ $account->account_number }} - {{ $account->user->name }} ({{ $account->currency }})
                            </option>
                        @endforeach
                    </flux:select>
                    <flux:error name="account_id" />
                </flux:field>
            </div>
        </flux:card>

        <!-- Card Details -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Card Details</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="card_type">Card Type</flux:label>
                    <flux:select id="card_type" name="card_type" required>
                        <option value="">Select card type</option>
                        <option value="debit" {{ old('card_type') === 'debit' ? 'selected' : '' }}>Debit</option>
                        <option value="credit" {{ old('card_type') === 'credit' ? 'selected' : '' }}>Credit</option>
                        <option value="prepaid" {{ old('card_type') === 'prepaid' ? 'selected' : '' }}>Prepaid</option>
                    </flux:select>
                    <flux:error name="card_type" />
                </flux:field>

                <flux:field>
                    <flux:label for="card_brand">Card Brand</flux:label>
                    <flux:select id="card_brand" name="card_brand" required>
                        <option value="">Select card brand</option>
                        <option value="visa" {{ old('card_brand') === 'visa' ? 'selected' : '' }}>Visa</option>
                        <option value="mastercard" {{ old('card_brand') === 'mastercard' ? 'selected' : '' }}>Mastercard</option>
                        <option value="amex" {{ old('card_brand') === 'amex' ? 'selected' : '' }}>American Express</option>
                    </flux:select>
                    <flux:error name="card_brand" />
                </flux:field>

                <flux:field>
                    <flux:label for="card_name">Card Name (Optional)</flux:label>
                    <flux:input 
                        id="card_name" 
                        name="card_name" 
                        value="{{ old('card_name') }}"
                        placeholder="e.g., My Shopping Card"
                    />
                    <flux:error name="card_name" />
                </flux:field>

                <flux:field>
                    <flux:label for="expiry_date">Expiry Date</flux:label>
                    <flux:date-picker 
                        id="expiry_date" 
                        name="expiry_date" 
                        value="{{ old('expiry_date') }}"
                        required
                    />
                    <flux:error name="expiry_date" />
                </flux:field>

                <flux:field>
                    <flux:label for="currency">Currency</flux:label>
                    <flux:select id="currency" name="currency" required>
                        @foreach(\App\Helpers\CurrencyHelper::getSupportedCurrencies() as $code => $currency)
                            <option value="{{ $code }}" {{ old('currency', 'USD') === $code ? 'selected' : '' }}>
                                {{ $code }} - {{ $currency['name'] }} ({{ $currency['symbol'] }})
                            </option>
                        @endforeach
                    </flux:select>
                    <flux:error name="currency" />
                </flux:field>
            </div>
        </flux:card>

        <!-- Financial Limits -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Financial Limits</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <flux:field>
                    <flux:label for="credit_limit">Credit Limit (Optional)</flux:label>
                    <flux:input 
                        id="credit_limit" 
                        name="credit_limit" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('credit_limit') }}"
                        placeholder="0.00"
                    />
                    <flux:error name="credit_limit" />
                    <flux:description>For credit cards only</flux:description>
                </flux:field>

                <flux:field>
                    <flux:label for="daily_limit">Daily Limit (Optional)</flux:label>
                    <flux:input 
                        id="daily_limit" 
                        name="daily_limit" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('daily_limit') }}"
                        placeholder="0.00"
                    />
                    <flux:error name="daily_limit" />
                </flux:field>

                <flux:field>
                    <flux:label for="monthly_limit">Monthly Limit (Optional)</flux:label>
                    <flux:input 
                        id="monthly_limit" 
                        name="monthly_limit" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('monthly_limit') }}"
                        placeholder="0.00"
                    />
                    <flux:error name="monthly_limit" />
                </flux:field>
            </div>
        </flux:card>

        <!-- Card Features -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Card Features</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <flux:field>
                    <flux:label for="online_payments">Online Payments</flux:label>
                    <flux:select id="online_payments" name="online_payments">
                        <option value="1" {{ old('online_payments', '1') === '1' ? 'selected' : '' }}>Enabled</option>
                        <option value="0" {{ old('online_payments') === '0' ? 'selected' : '' }}>Disabled</option>
                    </flux:select>
                    <flux:error name="online_payments" />
                </flux:field>

                <flux:field>
                    <flux:label for="atm_withdrawals">ATM Withdrawals</flux:label>
                    <flux:select id="atm_withdrawals" name="atm_withdrawals">
                        <option value="1" {{ old('atm_withdrawals', '1') === '1' ? 'selected' : '' }}>Enabled</option>
                        <option value="0" {{ old('atm_withdrawals') === '0' ? 'selected' : '' }}>Disabled</option>
                    </flux:select>
                    <flux:error name="atm_withdrawals" />
                </flux:field>

                <flux:field>
                    <flux:label for="international_usage">International Usage</flux:label>
                    <flux:select id="international_usage" name="international_usage">
                        <option value="0" {{ old('international_usage', '0') === '0' ? 'selected' : '' }}>Disabled</option>
                        <option value="1" {{ old('international_usage') === '1' ? 'selected' : '' }}>Enabled</option>
                    </flux:select>
                    <flux:error name="international_usage" />
                </flux:field>
            </div>
        </flux:card>
        
        <!-- Actions -->
        <div class="flex justify-end space-x-3">
            <flux:button href="{{ route('admin.virtual-cards.index') }}" variant="outline">
                Cancel
            </flux:button>
            <flux:button icon="check" type="submit" class="text-xs">
                Create Virtual Card
            </flux:button>
        </div>
    </form>
</div>
@endsection
