@extends('components.layouts.admin')

@section('title', 'Edit Transfer')

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Edit Transfer</h1>
                <p class="text-gray-600">Update transfer information and status</p>
            </div>
            <div class="flex space-x-3">
                <flux:button icon="eye" href="{{ route('admin.transfers.show', $transfer) }}" variant="outline">
                    View Transfer
                </flux:button>
                <flux:button icon="arrow-left" href="{{ route('admin.transfers.index') }}" variant="outline">
                    Back to Transfers
                </flux:button>
            </div>
        </div>

        <!-- Edit Form -->
        <form method="POST" action="{{ route('admin.transfers.update', $transfer) }}" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Basic Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Transaction ID (Read-only) -->
                    <flux:field>
                        <flux:label>Transaction ID</flux:label>
                        <flux:input 
                            value="{{ $transfer->transaction_id }}" 
                            readonly 
                            class="bg-gray-50"
                        />
                    </flux:field>

                    <!-- Reference Number (Read-only) -->
                    <flux:field>
                        <flux:label>Reference Number</flux:label>
                        <flux:input 
                            value="{{ $transfer->reference_number }}" 
                            readonly 
                            class="bg-gray-50"
                        />
                    </flux:field>

                    <!-- External Reference -->
                    <flux:field>
                        <flux:label>External Reference <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="external_reference" 
                            value="{{ old('external_reference', $transfer->external_reference) }}"
                            placeholder="External reference number"
                        />
                        <flux:error name="external_reference" />
                    </flux:field>

                    <!-- User -->
                    <flux:field>
                        <flux:label>User</flux:label>
                        <flux:select name="user_id">
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('user_id', $transfer->user_id) == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }} ({{ $user->email }})
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="user_id" />
                    </flux:field>

                    <!-- Category -->
                    <flux:field>
                        <flux:label>Category</flux:label>
                        <flux:select name="category">
                            <option value="">Select Category</option>
                            <option value="banking" {{ old('category', $transfer->category) === 'banking' ? 'selected' : '' }}>Banking</option>
                            <option value="investment" {{ old('category', $transfer->category) === 'investment' ? 'selected' : '' }}>Investment</option>
                            <option value="loan" {{ old('category', $transfer->category) === 'loan' ? 'selected' : '' }}>Loan</option>
                            <option value="card" {{ old('category', $transfer->category) === 'card' ? 'selected' : '' }}>Card</option>
                            <option value="atm" {{ old('category', $transfer->category) === 'atm' ? 'selected' : '' }}>ATM</option>
                            <option value="exchange" {{ old('category', $transfer->category) === 'exchange' ? 'selected' : '' }}>Exchange</option>
                            <option value="fee" {{ old('category', $transfer->category) === 'fee' ? 'selected' : '' }}>Fee</option>
                            <option value="interest" {{ old('category', $transfer->category) === 'interest' ? 'selected' : '' }}>Interest</option>
                            <option value="adjustment" {{ old('category', $transfer->category) === 'adjustment' ? 'selected' : '' }}>Adjustment</option>
                            <option value="other" {{ old('category', $transfer->category) === 'other' ? 'selected' : '' }}>Other</option>
                        </flux:select>
                        <flux:error name="category" />
                    </flux:field>

                    <!-- Subcategory -->
                    <flux:field>
                        <flux:label>Subcategory <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="subcategory" 
                            value="{{ old('subcategory', $transfer->subcategory) }}"
                            placeholder="Transfer subcategory"
                        />
                        <flux:error name="subcategory" />
                    </flux:field>

                    <!-- Status -->
                    <flux:field>
                        <flux:label>Status</flux:label>
                        <flux:select name="status">
                            <option value="pending" {{ old('status', $transfer->status) === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="processing" {{ old('status', $transfer->status) === 'processing' ? 'selected' : '' }}>Processing</option>
                            <option value="completed" {{ old('status', $transfer->status) === 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="failed" {{ old('status', $transfer->status) === 'failed' ? 'selected' : '' }}>Failed</option>
                            <option value="cancelled" {{ old('status', $transfer->status) === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            <option value="reversed" {{ old('status', $transfer->status) === 'reversed' ? 'selected' : '' }}>Reversed</option>
                        </flux:select>
                        <flux:error name="status" />
                    </flux:field>

                    <!-- Verification Status -->
                    <flux:field>
                        <flux:label>Verification Status</flux:label>
                        <flux:select name="verification_status">
                            <option value="pending" {{ old('verification_status', $transfer->verification_status) === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="verified" {{ old('verification_status', $transfer->verification_status) === 'verified' ? 'selected' : '' }}>Verified</option>
                            <option value="rejected" {{ old('verification_status', $transfer->verification_status) === 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </flux:select>
                        <flux:error name="verification_status" />
                    </flux:field>
                </div>
            </div>

            <!-- Transfer Details -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Transfer Details</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Transfer Method -->
                    <flux:field>
                        <flux:label>Transfer Method</flux:label>
                        <flux:select name="transfer_method">
                            <option value="wire" {{ old('transfer_method', $transfer->transfer_method) === 'wire' ? 'selected' : '' }}>Wire Transfer</option>
                            <option value="ach" {{ old('transfer_method', $transfer->transfer_method) === 'ach' ? 'selected' : '' }}>ACH</option>
                            <option value="swift" {{ old('transfer_method', $transfer->transfer_method) === 'swift' ? 'selected' : '' }}>SWIFT</option>
                            <option value="sepa" {{ old('transfer_method', $transfer->transfer_method) === 'sepa' ? 'selected' : '' }}>SEPA</option>
                            <option value="instant" {{ old('transfer_method', $transfer->transfer_method) === 'instant' ? 'selected' : '' }}>Instant</option>
                            <option value="domestic" {{ old('transfer_method', $transfer->transfer_method) === 'domestic' ? 'selected' : '' }}>Domestic</option>
                        </flux:select>
                        <flux:error name="transfer_method" />
                    </flux:field>

                    <!-- Transfer Speed -->
                    <flux:field>
                        <flux:label>Transfer Speed</flux:label>
                        <flux:select name="transfer_speed">
                            <option value="instant" {{ old('transfer_speed', $transfer->transfer_speed) === 'instant' ? 'selected' : '' }}>Instant</option>
                            <option value="same_day" {{ old('transfer_speed', $transfer->transfer_speed) === 'same_day' ? 'selected' : '' }}>Same Day</option>
                            <option value="next_day" {{ old('transfer_speed', $transfer->transfer_speed) === 'next_day' ? 'selected' : '' }}>Next Day</option>
                            <option value="standard" {{ old('transfer_speed', $transfer->transfer_speed) === 'standard' ? 'selected' : '' }}>Standard</option>
                        </flux:select>
                        <flux:error name="transfer_speed" />
                    </flux:field>

                    <!-- Estimated Arrival -->
                    <flux:field>
                        <flux:label>Estimated Arrival <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:date-picker 
                            name="estimated_arrival" 
                            value="{{ old('estimated_arrival', $transfer->estimated_arrival?->format('Y-m-d')) }}"
                        />
                        <flux:error name="estimated_arrival" />
                    </flux:field>

                    <!-- Actual Arrival -->
                    <flux:field>
                        <flux:label>Actual Arrival</flux:label>
                        <flux:date-picker 
                            name="actual_arrival" 
                            value="{{ old('actual_arrival', $transfer->actual_arrival?->format('Y-m-d')) }}"
                        />
                        <flux:error name="actual_arrival" />
                    </flux:field>
                </div>
            </div>

            <!-- Financial Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Financial Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Amount -->
                    <flux:field>
                        <flux:label>Amount</flux:label>
                        <flux:input 
                            name="amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('amount', $transfer->amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="amount" />
                    </flux:field>

                    <!-- Currency -->
                    <flux:field>
                        <flux:label>Currency</flux:label>
                        <flux:select name="currency">
                            <option value="USD" {{ old('currency', $transfer->currency) === 'USD' ? 'selected' : '' }}>USD</option>
                            <option value="EUR" {{ old('currency', $transfer->currency) === 'EUR' ? 'selected' : '' }}>EUR</option>
                            <option value="GBP" {{ old('currency', $transfer->currency) === 'GBP' ? 'selected' : '' }}>GBP</option>
                            <option value="NGN" {{ old('currency', $transfer->currency) === 'NGN' ? 'selected' : '' }}>NGN</option>
                        </flux:select>
                        <flux:error name="currency" />
                    </flux:field>

                    <!-- Exchange Rate -->
                    <flux:field>
                        <flux:label>Exchange Rate <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="exchange_rate" 
                            type="number"
                            step="0.0001"
                            value="{{ old('exchange_rate', $transfer->exchange_rate) }}"
                            placeholder="1.0000"
                        />
                        <flux:error name="exchange_rate" />
                    </flux:field>

                    <!-- Converted Amount -->
                    <flux:field>
                        <flux:label>Converted Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="converted_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('converted_amount', $transfer->converted_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="converted_amount" />
                    </flux:field>

                    <!-- Fee Amount -->
                    <flux:field>
                        <flux:label>Fee Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="fee_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('fee_amount', $transfer->fee_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="fee_amount" />
                    </flux:field>

                    <!-- Tax Amount -->
                    <flux:field>
                        <flux:label>Tax Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="tax_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('tax_amount', $transfer->tax_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="tax_amount" />
                    </flux:field>

                    <!-- Net Amount -->
                    <flux:field>
                        <flux:label>Net Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="net_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('net_amount', $transfer->net_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="net_amount" />
                    </flux:field>
                </div>
            </div>

            <!-- Account Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- From Account -->
                    <flux:field>
                        <flux:label>From Account <span class="text-red-600 text-xs font-medium">(Debit)</span></flux:label>
                        <flux:select name="from_account_id">
                            <option value="">Select From Account</option>
                            @foreach($accounts as $account)
                                <option value="{{ $account->id }}" {{ old('from_account_id', $transfer->from_account_id) == $account->id ? 'selected' : '' }}>
                                    {{ $account->account_number }} - {{ $account->account_name }}
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="from_account_id" />
                    </flux:field>

                    <!-- To Account -->
                    <flux:field>
                        <flux:label>To Account <span class="text-green-600 text-xs font-medium">(Credit)</span> <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:select name="to_account_id">
                            <option value="">Select To Account</option>
                            @foreach($accounts as $account)
                                <option value="{{ $account->id }}" {{ old('to_account_id', $transfer->to_account_id) == $account->id ? 'selected' : '' }}>
                                    {{ $account->account_number }} - {{ $account->account_name }}
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="to_account_id" />
                    </flux:field>

                    <!-- Beneficiary -->
                    <flux:field>
                        <flux:label>Beneficiary <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:select name="beneficiary_id">
                            <option value="">Select Beneficiary</option>
                            @foreach($beneficiaries as $beneficiary)
                                <option value="{{ $beneficiary->id }}" {{ old('beneficiary_id', $transfer->beneficiary_id) == $beneficiary->id ? 'selected' : '' }}>
                                    {{ $beneficiary->name }} ({{ $beneficiary->email }})
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="beneficiary_id" />
                    </flux:field>
                </div>
            </div>

            <!-- Description and Notes -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Description & Notes</h3>
                <div class="space-y-6">
                    <!-- Description -->
                    <flux:field>
                        <flux:label>Description</flux:label>
                        <flux:textarea 
                            name="description" 
                            rows="3"
                            placeholder="Transfer description"
                        >{{ old('description', $transfer->description) }}</flux:textarea>
                        <flux:error name="description" />
                    </flux:field>

                    <!-- Notes -->
                    <flux:field>
                        <flux:label>Notes <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:textarea 
                            name="notes" 
                            rows="3"
                            placeholder="Additional notes"
                        >{{ old('notes', $transfer->notes) }}</flux:textarea>
                        <flux:error name="notes" />
                    </flux:field>
                </div>
            </div>

            <!-- Technical Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Technical Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Created At -->
                    <flux:field>
                        <flux:label>Created At</flux:label>
                        <flux:input 
                            name="created_at" 
                            type="datetime-local"
                            value="{{ old('created_at', $transfer->created_at?->format('Y-m-d\TH:i')) }}"
                        />
                        <flux:error name="created_at" />
                    </flux:field>

                    <!-- IP Address -->
                    <flux:field>
                        <flux:label>IP Address <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="ip_address" 
                            value="{{ old('ip_address', $transfer->ip_address) }}"
                            placeholder="192.168.1.1"
                        />
                        <flux:error name="ip_address" />
                    </flux:field>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="flex justify-end space-x-3">
                <flux:button href="{{ route('admin.transfers.show', $transfer) }}" variant="outline">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" variant="primary">
                    Update Transfer
                </flux:button>
            </div>
        </form>
    </div>
@endsection
