@extends('components.layouts.admin')

@section('title', 'Edit Transaction')

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Edit Transaction</h1>
                <p class="text-gray-600">Update transaction information and status</p>
            </div>
            <div class="flex space-x-3">
                <flux:button href="{{ route('admin.transactions.show', $transaction) }}" variant="outline">
                    <flux:icon name="eye" class="w-4 h-4 mr-2" />
                    View Transaction
                </flux:button>
                <flux:button href="{{ route('admin.transactions.index') }}" variant="outline">
                    <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                    Back to Transactions
                </flux:button>
            </div>
        </div>

        <!-- Edit Form -->
        <form method="POST" action="{{ route('admin.transactions.update', $transaction) }}" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Basic Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Transaction ID (Read-only) -->
                    <flux:field>
                        <flux:label>Transaction ID</flux:label>
                        <flux:input 
                            value="{{ $transaction->transaction_id }}" 
                            readonly 
                            class="bg-gray-50"
                        />
                    </flux:field>

                    <!-- Reference Number (Read-only) -->
                    <flux:field>
                        <flux:label>Reference Number</flux:label>
                        <flux:input 
                            value="{{ $transaction->reference_number }}" 
                            readonly 
                            class="bg-gray-50"
                        />
                    </flux:field>

                    <!-- External Reference -->
                    <flux:field>
                        <flux:label>External Reference <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="external_reference" 
                            value="{{ old('external_reference', $transaction->external_reference) }}"
                            placeholder="External reference number"
                        />
                        <flux:error name="external_reference" />
                    </flux:field>

                    <!-- User -->
                    <flux:field>
                        <flux:label>User</flux:label>
                        <flux:select name="user_id">
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('user_id', $transaction->user_id) == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }} ({{ $user->email }})
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="user_id" />
                    </flux:field>

                    <!-- Type -->
                    <flux:field>
                        <flux:label>Type</flux:label>
                        <flux:select name="type">
                            <option value="deposit" {{ old('type', $transaction->type) === 'deposit' ? 'selected' : '' }}>Deposit</option>
                            <option value="withdrawal" {{ old('type', $transaction->type) === 'withdrawal' ? 'selected' : '' }}>Withdrawal</option>
                            <option value="transfer" {{ old('type', $transaction->type) === 'transfer' ? 'selected' : '' }}>Transfer</option>
                            <option value="payment" {{ old('type', $transaction->type) === 'payment' ? 'selected' : '' }}>Payment</option>
                            <option value="fee" {{ old('type', $transaction->type) === 'fee' ? 'selected' : '' }}>Fee</option>
                            <option value="interest" {{ old('type', $transaction->type) === 'interest' ? 'selected' : '' }}>Interest</option>
                            <option value="refund" {{ old('type', $transaction->type) === 'refund' ? 'selected' : '' }}>Refund</option>
                            <option value="exchange" {{ old('type', $transaction->type) === 'exchange' ? 'selected' : '' }}>Exchange</option>
                        </flux:select>
                        <flux:error name="type" />
                    </flux:field>

                    <!-- Category -->
                    <flux:field>
                        <flux:label>Category</flux:label>
                        <flux:select name="category">
                            <option value="">Select Category</option>
                            <option value="banking" {{ old('category', $transaction->category) === 'banking' ? 'selected' : '' }}>Banking</option>
                            <option value="investment" {{ old('category', $transaction->category) === 'investment' ? 'selected' : '' }}>Investment</option>
                            <option value="loan" {{ old('category', $transaction->category) === 'loan' ? 'selected' : '' }}>Loan</option>
                            <option value="card" {{ old('category', $transaction->category) === 'card' ? 'selected' : '' }}>Card</option>
                            <option value="atm" {{ old('category', $transaction->category) === 'atm' ? 'selected' : '' }}>ATM</option>
                            <option value="exchange" {{ old('category', $transaction->category) === 'exchange' ? 'selected' : '' }}>Exchange</option>
                            <option value="fee" {{ old('category', $transaction->category) === 'fee' ? 'selected' : '' }}>Fee</option>
                            <option value="interest" {{ old('category', $transaction->category) === 'interest' ? 'selected' : '' }}>Interest</option>
                            <option value="adjustment" {{ old('category', $transaction->category) === 'adjustment' ? 'selected' : '' }}>Adjustment</option>
                            <option value="other" {{ old('category', $transaction->category) === 'other' ? 'selected' : '' }}>Other</option>
                        </flux:select>
                        <flux:error name="category" />
                    </flux:field>

                    <!-- Subcategory -->
                    <flux:field>
                        <flux:label>Subcategory <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="subcategory" 
                            value="{{ old('subcategory', $transaction->subcategory) }}"
                            placeholder="Transaction subcategory"
                        />
                        <flux:error name="subcategory" />
                    </flux:field>

                    <!-- Status -->
                    <flux:field>
                        <flux:label>Status</flux:label>
                        <flux:select name="status">
                            <option value="pending" {{ old('status', $transaction->status) === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="processing" {{ old('status', $transaction->status) === 'processing' ? 'selected' : '' }}>Processing</option>
                            <option value="completed" {{ old('status', $transaction->status) === 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="failed" {{ old('status', $transaction->status) === 'failed' ? 'selected' : '' }}>Failed</option>
                            <option value="cancelled" {{ old('status', $transaction->status) === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            <option value="reversed" {{ old('status', $transaction->status) === 'reversed' ? 'selected' : '' }}>Reversed</option>
                        </flux:select>
                        <flux:error name="status" />
                    </flux:field>

                    <!-- Verification Status -->
                    <flux:field>
                        <flux:label>Verification Status</flux:label>
                        <flux:select name="verification_status">
                            <option value="pending" {{ old('verification_status', $transaction->verification_status) === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="verified" {{ old('verification_status', $transaction->verification_status) === 'verified' ? 'selected' : '' }}>Verified</option>
                            <option value="rejected" {{ old('verification_status', $transaction->verification_status) === 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </flux:select>
                        <flux:error name="verification_status" />
                    </flux:field>
                </div>
            </div>

            <!-- Financial Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Financial Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Amount -->
                    <flux:field>
                        <flux:label>Amount</flux:label>
                        <flux:input 
                            name="amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('amount', $transaction->amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="amount" />
                    </flux:field>

                    <!-- Currency -->
                    <flux:field>
                        <flux:label>Currency</flux:label>
                        <flux:select name="currency">
                            <option value="USD" {{ old('currency', $transaction->currency) === 'USD' ? 'selected' : '' }}>USD</option>
                            <option value="EUR" {{ old('currency', $transaction->currency) === 'EUR' ? 'selected' : '' }}>EUR</option>
                            <option value="GBP" {{ old('currency', $transaction->currency) === 'GBP' ? 'selected' : '' }}>GBP</option>
                            <option value="NGN" {{ old('currency', $transaction->currency) === 'NGN' ? 'selected' : '' }}>NGN</option>
                        </flux:select>
                        <flux:error name="currency" />
                    </flux:field>

                    <!-- Exchange Rate -->
                    <flux:field>
                        <flux:label>Exchange Rate <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="exchange_rate" 
                            type="number"
                            step="0.0001"
                            value="{{ old('exchange_rate', $transaction->exchange_rate) }}"
                            placeholder="1.0000"
                        />
                        <flux:error name="exchange_rate" />
                    </flux:field>

                    <!-- Converted Amount -->
                    <flux:field>
                        <flux:label>Converted Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="converted_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('converted_amount', $transaction->converted_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="converted_amount" />
                    </flux:field>

                    <!-- Fee Amount -->
                    <flux:field>
                        <flux:label>Fee Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="fee_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('fee_amount', $transaction->fee_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="fee_amount" />
                    </flux:field>

                    <!-- Tax Amount -->
                    <flux:field>
                        <flux:label>Tax Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="tax_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('tax_amount', $transaction->tax_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="tax_amount" />
                    </flux:field>

                    <!-- Net Amount -->
                    <flux:field>
                        <flux:label>Net Amount <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="net_amount" 
                            type="number"
                            step="0.01"
                            value="{{ old('net_amount', $transaction->net_amount) }}"
                            placeholder="0.00"
                        />
                        <flux:error name="net_amount" />
                    </flux:field>
                </div>
            </div>

            <!-- Account Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Information (Select at least one account)</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- From Account -->
                    <flux:field>
                        <flux:label>From Account <span class="text-red-600 text-xs font-medium">(Debit)</span> <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:select name="from_account_id">
                            <option value="">Select From Account</option>
                            @foreach($accounts as $account)
                                <option value="{{ $account->id }}" {{ old('from_account_id', $transaction->from_account_id) == $account->id ? 'selected' : '' }}>
                                    {{ $account->account_number }} - {{ $account->account_name }}
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="from_account_id" />
                    </flux:field>

                    <!-- To Account -->
                    <flux:field>
                        <flux:label>To Account <span class="text-green-600 text-xs font-medium">(Credit)</span> <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:select name="to_account_id">
                            <option value="">Select To Account</option>
                            @foreach($accounts as $account)
                                <option value="{{ $account->id }}" {{ old('to_account_id', $transaction->to_account_id) == $account->id ? 'selected' : '' }}>
                                    {{ $account->account_number }} - {{ $account->account_name }}
                                </option>
                            @endforeach
                        </flux:select>
                        <flux:error name="to_account_id" />
                    </flux:field>
                </div>
            </div>

            <!-- Description and Notes -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Description & Notes</h3>
                <div class="space-y-6">
                    <!-- Description -->
                    <flux:field>
                        <flux:label>Description</flux:label>
                        <flux:textarea 
                            name="description" 
                            rows="3"
                            placeholder="Transaction description"
                        >{{ old('description', $transaction->description) }}</flux:textarea>
                        <flux:error name="description" />
                    </flux:field>

                    <!-- Notes -->
                    <flux:field>
                        <flux:label>Notes <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:textarea 
                            name="notes" 
                            rows="3"
                            placeholder="Additional notes"
                        >{{ old('notes', $transaction->notes) }}</flux:textarea>
                        <flux:error name="notes" />
                    </flux:field>
                </div>
            </div>

            <!-- Technical Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Technical Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Created At -->
                    <flux:field>
                        <flux:label>Created At</flux:label>
                        <flux:input 
                            name="created_at" 
                            type="datetime-local"
                            value="{{ old('created_at', $transaction->created_at?->format('Y-m-d\TH:i')) }}"
                        />
                        <flux:error name="created_at" />
                    </flux:field>

                    <!-- IP Address -->
                    <flux:field>
                        <flux:label>IP Address <span class="text-gray-500 text-xs">(Optional)</span></flux:label>
                        <flux:input 
                            name="ip_address" 
                            value="{{ old('ip_address', $transaction->ip_address) }}"
                            placeholder="192.168.1.1"
                        />
                        <flux:error name="ip_address" />
                    </flux:field>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="flex justify-end space-x-3">
                <flux:button href="{{ route('admin.transactions.show', $transaction) }}" variant="outline">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" variant="primary">
                    Update Transaction
                </flux:button>
            </div>
        </form>
    </div>
@endsection
