@extends('components.layouts.admin')

@section('title', 'System Settings')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">System Settings</h1>
            <p class="text-gray-600">Configure bank settings, limits, compliance, and system preferences</p>
        </div>
    </div>

    <!-- Settings Overview Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- Bank Settings -->
        <flux:card class="hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='{{ route('admin.settings.bank') }}'">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="building-office" class="w-12 h-12 text-blue-600" />
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-gray-900">Bank Settings</h3>
                    <p class="text-sm text-gray-500">Configure bank information, contact details, and branding</p>
                    <div class="mt-2 text-xs text-gray-400">
                        Bank: {{ $settings['bank']['bank_name'] ?? 'Not configured' }}
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Transaction Limits -->
        <flux:card class="hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='{{ route('admin.settings.limits') }}'">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="currency-dollar" class="w-12 h-12 text-green-600" />
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-gray-900">Transaction Limits</h3>
                    <p class="text-sm text-gray-500">Set daily, monthly, and per-transaction limits</p>
                    <div class="mt-2 text-xs text-gray-400">
                        Daily Limit: ${{ number_format($settings['limits']['daily_transfer_limit']) }}
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Compliance Settings -->
        <flux:card class="hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='{{ route('admin.settings.compliance') }}'">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="shield-check" class="w-12 h-12 text-purple-600" />
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-gray-900">Compliance Settings</h3>
                    <p class="text-sm text-gray-500">Configure KYC, AML, and regulatory compliance</p>
                    <div class="mt-2 text-xs text-gray-400">
                        KYC Required: {{ $settings['compliance']['kyc_required'] ? 'Yes' : 'No' }}
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Notification Settings -->
        <flux:card class="hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='{{ route('admin.settings.notifications') }}'">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="bell" class="w-12 h-12 text-orange-600" />
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-gray-900">Notifications</h3>
                    <p class="text-sm text-gray-500">Configure email verification and SMTP settings</p>
                    <div class="mt-2 text-xs text-gray-400">
                        Email Verification: {{ $settings['notifications']['email_verification_enabled'] ? 'Enabled' : 'Disabled' }}
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- System Settings -->
        <flux:card class="hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='{{ route('admin.settings.system') }}'">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="cog-6-tooth" class="w-12 h-12 text-gray-600" />
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-gray-900">System Settings</h3>
                    <p class="text-sm text-gray-500">Configure security, maintenance, and system preferences</p>
                    <div class="mt-2 text-xs text-gray-400">
                        Debug: {{ $settings['system']['debug_mode'] ? 'On' : 'Off' }}
                    </div>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Current Configuration Summary -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Current Configuration Summary</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Bank Info -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-2">Bank Information</h4>
                <div class="space-y-1 text-sm text-gray-600">
                    <div><strong>Name:</strong> {{ $settings['bank']['bank_name'] }}</div>
                    <div><strong>Code:</strong> {{ $settings['bank']['bank_code'] }}</div>
                </div>
            </div>

            <!-- Transaction Limits -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-2">Transaction Limits</h4>
                <div class="space-y-1 text-sm text-gray-600">
                    <div><strong>Daily Transfer:</strong> ${{ number_format($settings['limits']['daily_transfer_limit']) }}</div>
                    <div><strong>Monthly Transfer:</strong> ${{ number_format($settings['limits']['monthly_transfer_limit']) }}</div>
                 </div>
            </div>

            <!-- Compliance -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-2">Compliance</h4>
                <div class="space-y-1 text-sm text-gray-600">
                    <div><strong>KYC Required:</strong> {{ $settings['compliance']['kyc_required'] ? 'Yes' : 'No' }}</div>
                    <div><strong>AML Monitoring:</strong> {{ $settings['compliance']['aml_monitoring'] ? 'Yes' : 'No' }}</div>
                    </div>
            </div>

            <!-- Notifications -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-2">Notifications</h4>
                <div class="space-y-1 text-sm text-gray-600">
                    <div><strong>Email Verification:</strong> {{ $settings['notifications']['email_verification_enabled'] ? 'Enabled' : 'Disabled' }}</div>
                    <div><strong>SMTP Driver:</strong> {{ ucfirst($settings['notifications']['smtp_driver'] ?? 'smtp') }}</div>
                    <div><strong>SMTP Host:</strong> {{ $settings['notifications']['smtp_host'] ?? 'Not configured' }}</div>
                    <div><strong>From Email:</strong> {{ $settings['notifications']['from_email'] ?? 'Not configured' }}</div>
                </div>
            </div>
        </div>
    </flux:card>

    <!-- System Status -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">System Status</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="text-center p-4 {{ $settings['system']['maintenance_mode'] ? 'bg-yellow-50' : 'bg-green-50' }} rounded-lg">
                <flux:icon name="{{ $settings['system']['maintenance_mode'] ? 'exclamation-triangle' : 'check-circle' }}" class="w-8 h-8 mx-auto {{ $settings['system']['maintenance_mode'] ? 'text-yellow-600' : 'text-green-600' }}" />
                <div class="mt-2 text-sm font-medium {{ $settings['system']['maintenance_mode'] ? 'text-yellow-800' : 'text-green-800' }}">
                    {{ $settings['system']['maintenance_mode'] ? 'Maintenance Mode' : 'Operational' }}
                </div>
            </div>
            <div class="text-center p-4 {{ $settings['system']['debug_mode'] ? 'bg-blue-50' : 'bg-gray-50' }} rounded-lg">
                <flux:icon name="bug-ant" class="w-8 h-8 mx-auto {{ $settings['system']['debug_mode'] ? 'text-blue-600' : 'text-gray-600' }}" />
                <div class="mt-2 text-sm font-medium {{ $settings['system']['debug_mode'] ? 'text-blue-800' : 'text-gray-800' }}">
                    Debug {{ $settings['system']['debug_mode'] ? 'Enabled' : 'Disabled' }}
                </div>
            </div>
        </div>
    </flux:card>
</div>
@endsection
