@extends('components.layouts.admin')

@section('title', 'Bank Settings')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Bank Settings</h1>
            <p class="text-gray-600">Configure bank information, contact details, and branding</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.settings.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Settings
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.settings.bank.update') }}" enctype="multipart/form-data" class="space-y-6">
        @csrf
        
        <!-- Basic Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="bank_name">Bank Name</flux:label>
                    <flux:input 
                        id="bank_name" 
                        name="bank_name" 
                        value="{{ old('bank_name', $settings['bank_name']) }}"
                        placeholder="Enter bank name"
                        required
                    />
                    <flux:error name="bank_name" />
                </flux:field>

                <flux:field>
                    <flux:label for="bank_code">Bank Code</flux:label>
                    <flux:input 
                        id="bank_code" 
                        name="bank_code" 
                        value="{{ old('bank_code', $settings['bank_code']) }}"
                        placeholder="e.g., CYB"
                        maxlength="10"
                        required
                    />
                    <flux:error name="bank_code" />
                </flux:field>

                <flux:field>
                    <flux:label for="swift_code">SWIFT Code</flux:label>
                    <flux:input 
                        id="swift_code" 
                        name="swift_code" 
                        value="{{ old('swift_code', $settings['swift_code']) }}"
                        placeholder="e.g., CYBKENA"
                        maxlength="11"
                        required
                    />
                    <flux:error name="swift_code" />
                </flux:field>

            </div>
        </flux:card>

        <!-- Contact Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Contact Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="phone_number">Phone Number</flux:label>
                    <flux:input 
                        id="phone_number" 
                        name="phone_number" 
                        value="{{ old('phone_number', $settings['phone_number']) }}"
                        placeholder="+254 700 000 000"
                        required
                    />
                    <flux:error name="phone_number" />
                </flux:field>

                <flux:field>
                    <flux:label for="email">Main Email</flux:label>
                    <flux:input 
                        id="email" 
                        name="email" 
                        type="email"
                        value="{{ old('email', $settings['email']) }}"
                        placeholder="info@cycloversebank.com"
                        required
                    />
                    <flux:error name="email" />
                </flux:field>

                <flux:field>
                    <flux:label for="support_email">Support Email</flux:label>
                    <flux:input 
                        id="support_email" 
                        name="support_email" 
                        type="email"
                        value="{{ old('support_email', $settings['support_email']) }}"
                        placeholder="support@cycloversebank.com"
                        required
                    />
                    <flux:error name="support_email" />
                </flux:field>

                <flux:field>
                    <flux:label for="compliance_email">Compliance Email</flux:label>
                    <flux:input 
                        id="compliance_email" 
                        name="compliance_email" 
                        type="email"
                        value="{{ old('compliance_email', $settings['compliance_email']) }}"
                        placeholder="compliance@cycloversebank.com"
                        required
                    />
                    <flux:error name="compliance_email" />
                </flux:field>
            </div>
        </flux:card>

        <!-- Address and Location -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Address and Location</flux:heading>
            <div class="space-y-6">
                <flux:field>
                    <flux:label for="bank_address">Bank Address</flux:label>
                    <flux:textarea 
                        id="bank_address" 
                        name="bank_address" 
                        rows="3"
                        placeholder="Enter complete bank address"
                        required
                    >{{ old('bank_address', $settings['bank_address']) }}</flux:textarea>
                    <flux:error name="bank_address" />
                </flux:field>

                <flux:field>
                    <flux:label for="website">Website URL</flux:label>
                    <flux:input 
                        id="website" 
                        name="website" 
                        type="url"
                        value="{{ old('website', $settings['website']) }}"
                        placeholder="https://bank.cycloverseworld.info"
                        required
                    />
                    <flux:error name="website" />
                </flux:field>
            </div>
        </flux:card>

        <!-- Branding -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Branding</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="logo">Bank Logo</flux:label>
                    <flux:input 
                        id="logo" 
                        name="logo" 
                        type="file"
                        accept="image/*"
                    />
                    <flux:error name="logo" />
                    <flux:description>Upload bank logo (PNG, JPG, SVG - Max 2MB)</flux:description>
                    @if(isset($settings['logo_url']) && $settings['logo_url'])
                        <div class="mt-2">
                            <p class="text-sm text-gray-600">Current logo:</p>
                            <img src="{{ $settings['logo_url'] }}" alt="Current Logo" class="mt-1 h-16 w-auto object-contain">
                        </div>
                    @endif
                </flux:field>

                <flux:field>
                    <flux:label for="favicon">Favicon</flux:label>
                    <flux:input 
                        id="favicon" 
                        name="favicon" 
                        type="file"
                        accept="image/*"
                    />
                    <flux:error name="favicon" />
                    <flux:description>Upload favicon (ICO, PNG - Max 1MB, 32x32px recommended)</flux:description>
                    @if(isset($settings['favicon_url']) && $settings['favicon_url'])
                        <div class="mt-2">
                            <p class="text-sm text-gray-600">Current favicon:</p>
                            <img src="{{ $settings['favicon_url'] }}" alt="Current Favicon" class="mt-1 h-8 w-8 object-contain">
                        </div>
                    @endif
                </flux:field>
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-between items-center">
            <flux:button type="button" variant="outline" onclick="resetForm()" class="text-xs">
                <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                Reset Form
            </flux:button>
            
            <div class="flex space-x-3">
                <flux:button type="button" variant="outline" href="{{ route('admin.settings.index') }}" class="text-xs">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" class="text-xs">
                    Save Bank Settings
                </flux:button>
            </div>
        </div>
    </form>
</div>

<script>
function resetForm() {
    if (confirm('Are you sure you want to reset the form? All unsaved changes will be lost.')) {
        document.querySelector('form').reset();
    }
}
</script>
@endsection
