@extends('components.layouts.admin')

@section('title', 'Role Details')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Role Details</h1>
            <p class="text-gray-600">View and manage role information and permissions</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.roles.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Roles
            </flux:button>
            <flux:button href="{{ route('admin.roles.edit', $role) }}" class="text-xs">
                <flux:icon name="pencil" class="w-4 h-4 mr-2" />
                Edit Role
            </flux:button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Role Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Role Name</label>
                        <div class="flex items-center space-x-2">
                            <span class="text-lg font-semibold text-gray-900">{{ ucfirst(str_replace('-', ' ', $role->name)) }}</span>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                {{ $role->name }}
                            </span>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Guard Name</label>
                        <span class="text-lg font-semibold text-gray-900">{{ $role->guard_name }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Created</label>
                        <span class="text-sm text-gray-900">{{ $role->created_at->format('M d, Y H:i') }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Last Updated</label>
                        <span class="text-sm text-gray-900">{{ $role->updated_at->format('M d, Y H:i') }}</span>
                    </div>
                </div>
            </flux:card>

            <!-- Permissions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Permissions ({{ $role->permissions->count() }})</flux:heading>
                @if($role->permissions->count() > 0)
                    <div class="space-y-4">
                        @foreach($role->permissions->groupBy(function ($permission) {
                            return explode('-', $permission->name)[0];
                        }) as $category => $categoryPermissions)
                            <div class="border border-gray-200 rounded-lg p-4">
                                <h4 class="text-sm font-medium text-gray-900 mb-3 capitalize">{{ str_replace('-', ' ', $category) }}</h4>
                                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-2">
                                    @foreach($categoryPermissions as $permission)
                                        <div class="flex items-center p-2 bg-gray-50 rounded-lg">
                                            <flux:icon name="check" class="w-4 h-4 text-green-500 mr-2" />
                                            <div>
                                                <div class="text-sm font-medium text-gray-900">
                                                    {{ ucfirst(str_replace('-', ' ', $permission->name)) }}
                                                </div>
                                                <div class="text-xs text-gray-500">{{ $permission->name }}</div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-500">
                        <flux:icon name="key" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                        <p>No permissions assigned to this role.</p>
                    </div>
                @endif
            </flux:card>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Statistics -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Statistics</flux:heading>
                <div class="space-y-4">
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Total Permissions</span>
                        <span class="text-lg font-bold text-gray-900">{{ $role->permissions->count() }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Users with this Role</span>
                        <span class="text-lg font-bold text-gray-900">{{ $role->users->count() }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Created</span>
                        <span class="text-sm text-gray-900">{{ $role->created_at->format('M d, Y') }}</span>
                    </div>
                </div>
            </flux:card>

            <!-- Quick Actions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Quick Actions</flux:heading>
                <div class="space-y-3">
                    <flux:button href="{{ route('admin.roles.edit', $role) }}" class="w-full">
                        <flux:icon name="pencil" class="w-4 h-4 mr-2" />
                        Edit Role
                    </flux:button>
                    <flux:button href="{{ route('admin.permissions.index') }}" variant="outline" class="w-full">
                        <flux:icon name="key" class="w-4 h-4 mr-2" />
                        Manage Permissions
                    </flux:button>
                    @if($role->users->count() == 0)
                        <form method="POST" action="{{ route('admin.roles.destroy', $role) }}" onsubmit="return confirm('Are you sure you want to delete this role?')">
                            @csrf
                            @method('DELETE')
                            <flux:button type="submit" variant="outline" class="w-full text-red-600 hover:text-red-700">
                                <flux:icon name="trash" class="w-4 h-4 mr-2" />
                                Delete Role
                            </flux:button>
                        </form>
                    @else
                        <flux:button disabled variant="outline" class="w-full text-gray-400 cursor-not-allowed" title="Cannot delete role with assigned users">
                            <flux:icon name="trash" class="w-4 h-4 mr-2" />
                            Delete Role
                        </flux:button>
                    @endif
                </div>
            </flux:card>
        </div>
    </div>

    <!-- Users with this Role -->
    @if($users->count() > 0)
        <flux:card>
            <flux:heading size="lg" class="mb-4">Users with this Role ({{ $users->total() }})</flux:heading>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Joined</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($users as $user)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 h-10 w-10">
                                            <div class="h-10 w-10 rounded-full bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                                                <span class="text-sm font-medium text-white">{{ substr($user->name, 0, 1) }}</span>
                                            </div>
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium text-gray-900">{{ $user->name }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $user->email }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($user->customer_status === 'active')
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                            Active
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                            Inactive
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $user->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <div class="flex items-center justify-end space-x-2">
                                        <flux:button href="{{ route('admin.users.show', $user) }}" variant="outline" size="sm">
                                            <flux:icon name="eye" class="w-4 h-4" />
                                        </flux:button>
                                        <form method="POST" action="{{ route('admin.roles.remove-user', ['role' => $role, 'userId' => $user->id]) }}" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <flux:button type="submit" variant="outline" size="sm" class="text-red-600 hover:text-red-700">
                                                <flux:icon name="user-minus" class="w-4 h-4" />
                                            </flux:button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if($users->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $users->links() }}
                </div>
            @endif
        </flux:card>
    @endif
</div>
@endsection
