@extends('components.layouts.admin')

@section('title', 'Roles Management')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Roles Management</h1>
            <p class="text-gray-600">Manage user roles and their permissions</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline" class="text-xs">
                <flux:icon name="key" class="w-4 h-4 mr-2" />
                Permissions
            </flux:button>
            <flux:button href="{{ route('admin.roles.create') }}" class="text-xs">
                <flux:icon name="plus" class="w-4 h-4 mr-2" />
                Create Role
            </flux:button>
        </div>
    </div>

    <!-- Filters -->
    <flux:card>
        <form method="GET" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <flux:field>
                    <flux:label>Search</flux:label>
                    <flux:input 
                        name="search" 
                        value="{{ request('search') }}"
                        placeholder="Search by role name..."
                    />
                </flux:field>

                <flux:field>
                    <flux:label>Sort By</flux:label>
                    <flux:select name="sort_by">
                        <option value="name" {{ request('sort_by') === 'name' ? 'selected' : '' }}>Name</option>
                        <option value="created_at" {{ request('sort_by') === 'created_at' ? 'selected' : '' }}>Created Date</option>
                        <option value="permissions_count" {{ request('sort_by') === 'permissions_count' ? 'selected' : '' }}>Permissions Count</option>
                        <option value="users_count" {{ request('sort_by') === 'users_count' ? 'selected' : '' }}>Users Count</option>
                    </flux:select>
                </flux:field>
            </div>

            <div class="flex justify-between items-center">
                <flux:button icon="magnifying-glass" type="submit" variant="outline" class="text-xs">
                    Apply Filters
                </flux:button>
                <flux:button icon="x-mark" href="{{ route('admin.roles.index') }}" variant="outline" class="text-xs">
                    Clear Filters
                </flux:button>
            </div>
        </form>
    </flux:card>

    <!-- Roles Table -->
    <flux:card>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'name', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Role Name
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'permissions_count', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Permissions
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'users_count', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Users
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Guard</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'created_at', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Created
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($roles as $role)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10">
                                        <div class="h-10 w-10 rounded-lg bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                                            <flux:icon name="shield-check" class="w-6 h-6 text-white" />
                                        </div>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">
                                            {{ ucfirst(str_replace('-', ' ', $role->name)) }}
                                        </div>
                                        <div class="text-sm text-gray-500">{{ $role->name }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        {{ $role->permissions_count }} permissions
                                    </span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        {{ $role->users_count }} users
                                    </span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $role->guard_name }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                {{ $role->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <div class="flex items-center justify-end space-x-2">
                                    <flux:button href="{{ route('admin.roles.show', $role) }}" variant="outline" size="sm">
                                        <flux:icon name="eye" class="w-4 h-4" />
                                    </flux:button>
                                    <flux:button href="{{ route('admin.roles.edit', $role) }}" variant="outline" size="sm">
                                        <flux:icon name="pencil" class="w-4 h-4" />
                                    </flux:button>
                                    
                                    @if($role->users_count == 0)
                                        <form method="POST" action="{{ route('admin.roles.destroy', $role) }}" class="inline" onsubmit="return confirm('Are you sure you want to delete this role?')">
                                            @csrf
                                            @method('DELETE')
                                            <flux:button type="submit" variant="outline" size="sm" class="text-red-600 hover:text-red-700">
                                                <flux:icon name="trash" class="w-4 h-4" />
                                            </flux:button>
                                        </form>
                                    @else
                                        <flux:button disabled variant="outline" size="sm" class="text-gray-400 cursor-not-allowed" title="Cannot delete role with assigned users">
                                            <flux:icon name="trash" class="w-4 h-4" />
                                        </flux:button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                                <flux:icon name="shield-check" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                                <p class="text-lg font-medium">No roles found</p>
                                <p class="text-sm">Get started by creating a new role.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($roles->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $roles->links() }}
            </div>
        @endif
    </flux:card>
</div>
@endsection
