@extends('components.layouts.admin')

@section('title', 'Edit Role')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Edit Role</h1>
            <p class="text-gray-600">Update role information and permissions</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.roles.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Roles
            </flux:button>
            <flux:button href="{{ route('admin.roles.show', $role) }}" variant="outline" class="text-xs">
                <flux:icon name="eye" class="w-4 h-4 mr-2" />
                View Role
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.roles.update', $role) }}" class="space-y-6">
        @csrf
        @method('PUT')
        
        <!-- Basic Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="name">Role Name</flux:label>
                    <flux:input 
                        id="name" 
                        name="name" 
                        value="{{ old('name', $role->name) }}"
                        placeholder="e.g., customer-service, branch-manager"
                        required
                    />
                    <flux:error name="name" />
                    <flux:description>Use lowercase with hyphens (e.g., customer-service)</flux:description>
                </flux:field>

                <flux:field>
                    <flux:label for="guard_name">Guard Name</flux:label>
                    <flux:select id="guard_name" name="guard_name" required>
                        <option value="web" {{ old('guard_name', $role->guard_name) === 'web' ? 'selected' : '' }}>Web</option>
                        <option value="api" {{ old('guard_name', $role->guard_name) === 'api' ? 'selected' : '' }}>API</option>
                    </flux:select>
                    <flux:error name="guard_name" />
                    <flux:description>Authentication guard for this role</flux:description>
                </flux:field>
            </div>
        </flux:card>

        <!-- Current Assignment Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Current Assignment Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Assigned Permissions</label>
                    <div class="text-center py-4">
                        <div class="text-3xl font-bold text-gray-900">{{ $role->permissions->count() }}</div>
                        <p class="text-sm text-gray-500">permissions assigned</p>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Users with this Role</label>
                    <div class="text-center py-4">
                        <div class="text-3xl font-bold text-gray-900">{{ $role->users->count() }}</div>
                        <p class="text-sm text-gray-500">users assigned</p>
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Permissions -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Permissions</flux:heading>
            <p class="text-sm text-gray-600 mb-6">Select the permissions to assign to this role. Permissions are grouped by category for easier management.</p>
            
            <div class="space-y-6">
                @foreach($permissions as $category => $categoryPermissions)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <div class="flex items-center justify-between mb-4">
                            <h4 class="text-lg font-medium text-gray-900 capitalize">{{ str_replace('-', ' ', $category) }}</h4>
                            <div class="flex items-center space-x-2">
                                <flux:button type="button" variant="outline" size="sm" onclick="selectAllInCategory('{{ $category }}')">
                                    Select All
                                </flux:button>
                                <flux:button type="button" variant="outline" size="sm" onclick="deselectAllInCategory('{{ $category }}')">
                                    Deselect All
                                </flux:button>
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                            @foreach($categoryPermissions as $permission)
                                <label class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer">
                                    <flux:input 
                                        type="checkbox" 
                                        name="permissions[]" 
                                        value="{{ $permission->id }}"
                                        class="permission-checkbox category-{{ $category }}"
                                        {{ in_array($permission->id, old('permissions', $rolePermissions)) ? 'checked' : '' }}
                                    />
                                    <div class="ml-3">
                                        <div class="text-sm font-medium text-gray-900">
                                            {{ ucfirst(str_replace('-', ' ', $permission->name)) }}
                                        </div>
                                        <div class="text-xs text-gray-500">{{ $permission->name }}</div>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-end space-x-3">
            <flux:button href="{{ route('admin.roles.index') }}" variant="outline">
                Cancel
            </flux:button>
            <flux:button icon="check" type="submit" class="text-xs">
                Update Role
            </flux:button>
        </div>
    </form>
</div>

<script>
function selectAllInCategory(category) {
    const checkboxes = document.querySelectorAll(`.category-${category}`);
    checkboxes.forEach(checkbox => {
        checkbox.checked = true;
    });
}

function deselectAllInCategory(category) {
    const checkboxes = document.querySelectorAll(`.category-${category}`);
    checkboxes.forEach(checkbox => {
        checkbox.checked = false;
    });
}

// Select all functionality
document.addEventListener('DOMContentLoaded', function() {
    // Add select all button for all permissions
    const permissionsCard = document.querySelector('flux\\:card:last-of-type');
    if (permissionsCard) {
        const header = permissionsCard.querySelector('flux\\:heading');
        if (header) {
            const selectAllBtn = document.createElement('flux\\:button');
            selectAllBtn.type = 'button';
            selectAllBtn.className = 'ml-4 text-xs';
            selectAllBtn.innerHTML = '<flux\\:icon name="check" class="w-4 h-4 mr-1" />Select All';
            selectAllBtn.onclick = function() {
                document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
                    checkbox.checked = true;
                });
            };
            header.appendChild(selectAllBtn);
        }
    }
});
</script>
@endsection
