@extends('components.layouts.admin')

@section('title', 'User Reports')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">User Reports</h1>
            <p class="text-gray-600">Comprehensive user analytics and registration trends</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.reports.export.users', request()->query()) }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export CSV
            </flux:button>
            <flux:button href="{{ route('admin.reports.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Reports
            </flux:button>
        </div>
    </div>

    <!-- Filters -->
    <flux:card>
        <form method="GET" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Start Date -->
                <div>
                    <flux:label for="start_date">Start Date</flux:label>
                    <flux:date-picker 
                        id="start_date" 
                        name="start_date" 
                        value="{{ $startDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- End Date -->
                <div>
                    <flux:label for="end_date">End Date</flux:label>
                    <flux:date-picker 
                        id="end_date" 
                        name="end_date" 
                        value="{{ $endDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- Group By -->
                <div>
                    <flux:label for="group_by">Group By</flux:label>
                    <flux:select id="group_by" name="group_by">
                        <option value="day" {{ $groupBy === 'day' ? 'selected' : '' }}>Day</option>
                        <option value="week" {{ $groupBy === 'week' ? 'selected' : '' }}>Week</option>
                        <option value="month" {{ $groupBy === 'month' ? 'selected' : '' }}>Month</option>
                        <option value="year" {{ $groupBy === 'year' ? 'selected' : '' }}>Year</option>
                    </flux:select>
                </div>

                <!-- Filter Button -->
                <div class="flex items-end">
                    <flux:button type="submit" variant="primary" class="text-xs">
                        <flux:icon name="magnifying-glass" class="w-4 h-4 mr-2" />
                        Apply Filters
                    </flux:button>
                </div>
            </div>
        </form>
    </flux:card>

    <!-- Status Summary -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="users" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Users</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['total_users']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Active Users</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['active_users']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="shield-check" class="w-8 h-8 text-purple-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Verified Users</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['verified_users']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="clock" class="w-8 h-8 text-yellow-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Pending KYC</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['pending_kyc']) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Registration Trends Chart -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Registration Trends</flux:heading>
            @if($registrationReport->count() > 0)
                <div class="space-y-3">
                    @foreach($registrationReport as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ \Carbon\Carbon::parse($data->period)->format('M j, Y') }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ ($data->count / $registrationReport->max('count')) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $data->count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No registration data available for the selected period.</p>
            @endif
        </flux:card>

        <!-- User Status Breakdown -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">User Status Breakdown</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Active Users</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full" style="width: {{ ($statusReport['active_users'] / $statusReport['total_users']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['active_users']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Inactive Users</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-red-600 h-2 rounded-full" style="width: {{ ($statusReport['inactive_users'] / $statusReport['total_users']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['inactive_users']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Verified Users</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-purple-600 h-2 rounded-full" style="width: {{ ($statusReport['verified_users'] / $statusReport['total_users']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['verified_users']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Pending KYC</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-yellow-600 h-2 rounded-full" style="width: {{ ($statusReport['pending_kyc'] / $statusReport['total_users']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['pending_kyc']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Rejected KYC</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-red-600 h-2 rounded-full" style="width: {{ ($statusReport['rejected_kyc'] / $statusReport['total_users']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['rejected_kyc']) }}</span>
                    </div>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- User Activity Table -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Recent User Activity</flux:heading>
        @if($activityReport->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Accounts</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">KYC Documents</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transactions</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Joined</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($activityReport->take(10) as $user)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $user->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $user->email }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $user->is_account_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $user->is_account_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $user->accounts_count }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $user->kyc_documents_count }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $user->transactions_count }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $user->created_at->format('M j, Y') }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <p class="text-sm text-gray-500">No user activity data available for the selected period.</p>
        @endif
    </flux:card>
</div>
@endsection
