@extends('components.layouts.admin')

@section('title', 'Reports Dashboard')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Reports Dashboard</h1>
            <p class="text-gray-600">Comprehensive analytics and reporting for your banking platform</p>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Users Summary -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="users" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Users</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($summary['users']['total']) }}</p>
                    <p class="text-xs text-gray-500">{{ $summary['users']['new_today'] }} new today</p>
                </div>
            </div>
        </flux:card>

        <!-- Accounts Summary -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="credit-card" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Accounts</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($summary['accounts']['total']) }}</p>
                    <p class="text-xs text-gray-500">{{ $summary['accounts']['new_today'] }} new today</p>
                </div>
            </div>
        </flux:card>

        <!-- Transactions Summary -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="arrow-path" class="w-8 h-8 text-purple-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Transactions</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($summary['transactions']['total']) }}</p>
                    <p class="text-xs text-gray-500">{{ $summary['transactions']['today'] }} today</p>
                </div>
            </div>
        </flux:card>

        <!-- KYC Summary -->
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="identification" class="w-8 h-8 text-orange-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">KYC Documents</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($summary['kyc']['total_documents']) }}</p>
                    <p class="text-xs text-gray-500">{{ $summary['kyc']['pending'] }} pending</p>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Report Categories -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- User Reports -->
        <flux:card>
            <div class="flex items-center justify-between mb-4">
                <flux:heading size="lg">User Reports</flux:heading>
                <flux:icon name="users" class="w-6 h-6 text-blue-600" />
            </div>
            <p class="text-sm text-gray-600 mb-4">Comprehensive user analytics including registration trends, activity patterns, and status breakdowns.</p>
            <div class="space-y-2">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Active Users</span>
                    <span class="text-sm font-medium text-gray-900">{{ number_format($summary['users']['active']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">New This Month</span>
                    <span class="text-sm font-medium text-gray-900">{{ number_format($summary['users']['new_this_month']) }}</span>
                </div>
            </div>
            <div class="mt-4">
                <flux:button href="{{ route('admin.reports.users') }}" variant="primary" class="w-full">
                    <flux:icon name="chart-bar" class="w-4 h-4 mr-2" />
                    View User Reports
                </flux:button>
            </div>
        </flux:card>

        <!-- Account Reports -->
        <flux:card>
            <div class="flex items-center justify-between mb-4">
                <flux:heading size="lg">Account Reports</flux:heading>
                <flux:icon name="credit-card" class="w-6 h-6 text-green-600" />
            </div>
            <p class="text-sm text-gray-600 mb-4">Account creation trends, status analysis, and type distribution across your platform.</p>
            <div class="space-y-2">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Active Accounts</span>
                    <span class="text-sm font-medium text-gray-900">{{ number_format($summary['accounts']['active']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">New This Month</span>
                    <span class="text-sm font-medium text-gray-900">{{ number_format($summary['accounts']['new_this_month']) }}</span>
                </div>
            </div>
            <div class="mt-4">
                <flux:button href="{{ route('admin.reports.accounts') }}" variant="primary" class="w-full">
                    <flux:icon name="chart-bar" class="w-4 h-4 mr-2" />
                    View Account Reports
                </flux:button>
            </div>
        </flux:card>

        <!-- Transaction Reports -->
        <flux:card>
            <div class="flex items-center justify-between mb-4">
                <flux:heading size="lg">Transaction Reports</flux:heading>
                <flux:icon name="arrow-path" class="w-6 h-6 text-purple-600" />
            </div>
            <p class="text-sm text-gray-600 mb-4">Transaction volume analysis, type breakdowns, and status monitoring for financial insights.</p>
            <div class="space-y-2">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Total Volume</span>
                    <span class="text-sm font-medium text-gray-900">${{ number_format($summary['transactions']['total_volume'], 2) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Today's Volume</span>
                    <span class="text-sm font-medium text-gray-900">${{ number_format($summary['transactions']['today_volume'], 2) }}</span>
                </div>
            </div>
            <div class="mt-4">
                <flux:button href="{{ route('admin.reports.transactions') }}" variant="primary" class="w-full">
                    <flux:icon name="chart-bar" class="w-4 h-4 mr-2" />
                    View Transaction Reports
                </flux:button>
            </div>
        </flux:card>

        <!-- KYC Reports -->
        <flux:card>
            <div class="flex items-center justify-between mb-4">
                <flux:heading size="lg">KYC Reports</flux:heading>
                <flux:icon name="identification" class="w-6 h-6 text-orange-600" />
            </div>
            <p class="text-sm text-gray-600 mb-4">KYC document submission trends, approval rates, and verification status analytics.</p>
            <div class="space-y-2">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Approved</span>
                    <span class="text-sm font-medium text-gray-900">{{ number_format($summary['kyc']['approved']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Rejected</span>
                    <span class="text-sm font-medium text-gray-900">{{ number_format($summary['kyc']['rejected']) }}</span>
                </div>
            </div>
            <div class="mt-4">
                <flux:button href="{{ route('admin.reports.kyc') }}" variant="primary" class="w-full">
                    <flux:icon name="chart-bar" class="w-4 h-4 mr-2" />
                    View KYC Reports
                </flux:button>
            </div>
        </flux:card>
    </div>

    <!-- Compliance Reports -->
    <flux:card>
        <div class="flex items-center justify-between mb-4">
            <flux:heading size="lg">Compliance Reports</flux:heading>
            <flux:icon name="exclamation-triangle" class="w-6 h-6 text-red-600" />
        </div>
        <p class="text-sm text-gray-600 mb-4">Compliance monitoring, risk assessment trends, and audit trail analytics for regulatory reporting.</p>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
            <div class="text-center p-4 bg-gray-50 rounded-lg">
                <div class="text-2xl font-bold text-gray-900">{{ number_format($summary['compliance']['total_logs']) }}</div>
                <div class="text-sm text-gray-500">Total Logs</div>
            </div>
            <div class="text-center p-4 bg-gray-50 rounded-lg">
                <div class="text-2xl font-bold text-gray-900">{{ number_format($summary['compliance']['pending']) }}</div>
                <div class="text-sm text-gray-500">Pending</div>
            </div>
            <div class="text-center p-4 bg-gray-50 rounded-lg">
                <div class="text-2xl font-bold text-gray-900">{{ number_format($summary['compliance']['high_priority']) }}</div>
                <div class="text-sm text-gray-500">High Priority</div>
            </div>
        </div>
        <div>
            <flux:button href="{{ route('admin.reports.compliance') }}" variant="primary" class="w-full">
                <flux:icon name="chart-bar" class="w-4 h-4 mr-2" />
                View Compliance Reports
            </flux:button>
        </div>
    </flux:card>

    <!-- Quick Actions -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Quick Actions</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
            <flux:button href="{{ route('admin.reports.export.users') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export Users
            </flux:button>
            <flux:button href="{{ route('admin.reports.export.accounts') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export Accounts
            </flux:button>
            <flux:button href="{{ route('admin.reports.export.transactions') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export Transactions
            </flux:button>
            <flux:button href="{{ route('admin.reports.export.kyc') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export KYC
            </flux:button>
            <flux:button href="{{ route('admin.reports.export.compliance') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export Compliance
            </flux:button>
        </div>
    </flux:card>
</div>
@endsection
