@extends('components.layouts.admin')

@section('title', 'Compliance Reports')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Compliance Reports</h1>
            <p class="text-gray-600">Compliance monitoring and risk assessment analytics</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.reports.export.compliance', request()->query()) }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export CSV
            </flux:button>
            <flux:button href="{{ route('admin.reports.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Reports
            </flux:button>
        </div>
    </div>

    <!-- Filters -->
    <flux:card>
        <form method="GET" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Start Date -->
                <div>
                    <flux:label for="start_date">Start Date</flux:label>
                    <flux:date-picker 
                        id="start_date" 
                        name="start_date" 
                        value="{{ $startDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- End Date -->
                <div>
                    <flux:label for="end_date">End Date</flux:label>
                    <flux:date-picker 
                        id="end_date" 
                        name="end_date" 
                        value="{{ $endDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- Group By -->
                <div>
                    <flux:label for="group_by">Group By</flux:label>
                    <flux:select id="group_by" name="group_by">
                        <option value="day" {{ $groupBy === 'day' ? 'selected' : '' }}>Day</option>
                        <option value="week" {{ $groupBy === 'week' ? 'selected' : '' }}>Week</option>
                        <option value="month" {{ $groupBy === 'month' ? 'selected' : '' }}>Month</option>
                        <option value="year" {{ $groupBy === 'year' ? 'selected' : '' }}>Year</option>
                    </flux:select>
                </div>

                <!-- Filter Button -->
                <div class="flex items-end">
                    <flux:button type="submit" variant="primary" class="text-xs">
                        <flux:icon name="magnifying-glass" class="w-4 h-4 mr-2" />
                        Apply Filters
                    </flux:button>
                </div>
            </div>
        </form>
    </flux:card>

    <!-- Status Summary -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="exclamation-triangle" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Logs</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['total_logs']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="clock" class="w-8 h-8 text-yellow-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Pending</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['pending_logs']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="exclamation-circle" class="w-8 h-8 text-red-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Critical</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['critical_severity']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Approved</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['approved_logs']) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Compliance Flag Trends -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Compliance Flag Trends</flux:heading>
            @if($flagReport->count() > 0)
                <div class="space-y-3">
                    @foreach($flagReport as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ \Carbon\Carbon::parse($data->period)->format('M j, Y') }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-red-600 h-2 rounded-full" style="width: {{ ($data->count / $flagReport->max('count')) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $data->count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No compliance flag data available for the selected period.</p>
            @endif
        </flux:card>

        <!-- Severity Distribution -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Severity Distribution</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Critical</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-red-600 h-2 rounded-full" style="width: {{ ($statusReport['critical_severity'] / $statusReport['total_logs']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['critical_severity']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">High</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-orange-600 h-2 rounded-full" style="width: {{ ($statusReport['high_severity'] / $statusReport['total_logs']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['high_severity']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Medium</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-yellow-600 h-2 rounded-full" style="width: {{ ($statusReport['medium_severity'] / $statusReport['total_logs']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['medium_severity']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Low</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full" style="width: {{ ($statusReport['low_severity'] / $statusReport['total_logs']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['low_severity']) }}</span>
                    </div>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Status Breakdown -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Compliance Status Breakdown</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
            <div class="text-center p-4 bg-yellow-50 rounded-lg">
                <flux:icon name="clock" class="w-8 h-8 text-yellow-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-yellow-900">{{ number_format($statusReport['pending_logs']) }}</div>
                <div class="text-sm text-yellow-700">Pending</div>
            </div>
            <div class="text-center p-4 bg-blue-50 rounded-lg">
                <flux:icon name="eye" class="w-8 h-8 text-blue-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-blue-900">{{ number_format($statusReport['under_review']) }}</div>
                <div class="text-sm text-blue-700">Under Review</div>
            </div>
            <div class="text-center p-4 bg-green-50 rounded-lg">
                <flux:icon name="check-circle" class="w-8 h-8 text-green-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-green-900">{{ number_format($statusReport['approved_logs']) }}</div>
                <div class="text-sm text-green-700">Approved</div>
            </div>
            <div class="text-center p-4 bg-red-50 rounded-lg">
                <flux:icon name="x-circle" class="w-8 h-8 text-red-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-red-900">{{ number_format($statusReport['rejected_logs']) }}</div>
                <div class="text-sm text-red-700">Rejected</div>
            </div>
            <div class="text-center p-4 bg-purple-50 rounded-lg">
                <flux:icon name="exclamation-triangle" class="w-8 h-8 text-purple-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-purple-900">{{ number_format($statusReport['escalated_logs']) }}</div>
                <div class="text-sm text-purple-700">Escalated</div>
            </div>
        </div>
    </flux:card>

    <!-- Compliance Type Analysis -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Compliance Type Analysis</flux:heading>
        @if($typeReport->count() > 0)
            <div class="space-y-4">
                @foreach($typeReport as $data)
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-900">
                            {{ ucfirst(str_replace('_', ' ', $data->type)) }}
                        </span>
                        <div class="flex items-center space-x-2">
                            <div class="w-48 bg-gray-200 rounded-full h-2">
                                <div class="bg-red-600 h-2 rounded-full" style="width: {{ ($data->count / $typeReport->max('count')) * 100 }}%"></div>
                            </div>
                            <span class="text-sm text-gray-500 w-12 text-right">{{ $data->count }}</span>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500">No compliance type data available for the selected period.</p>
        @endif
    </flux:card>

    <!-- Risk Assessment Summary -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Risk Assessment Summary</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center p-6 bg-red-50 rounded-lg">
                <div class="text-3xl font-bold text-red-900">{{ number_format($statusReport['critical_severity']) }}</div>
                <div class="text-sm text-red-700">Critical Issues</div>
                <div class="text-xs text-red-600 mt-1">Requires immediate attention</div>
            </div>
            <div class="text-center p-6 bg-orange-50 rounded-lg">
                <div class="text-3xl font-bold text-orange-900">{{ number_format($statusReport['high_severity']) }}</div>
                <div class="text-sm text-orange-700">High Priority</div>
                <div class="text-xs text-orange-600 mt-1">Should be reviewed soon</div>
            </div>
            <div class="text-center p-6 bg-yellow-50 rounded-lg">
                <div class="text-3xl font-bold text-yellow-900">{{ number_format($statusReport['medium_severity']) }}</div>
                <div class="text-sm text-yellow-700">Medium Priority</div>
                <div class="text-xs text-yellow-600 mt-1">Monitor regularly</div>
            </div>
        </div>
    </flux:card>
</div>
@endsection
