@extends('components.layouts.admin')

@section('title', 'Admin Profile')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Admin Profile</h1>
            <p class="text-gray-600">Manage your profile information and preferences</p>
        </div>
        <div class="flex space-x-3">
            <flux:button icon="pencil" href="{{ route('admin.profile.edit') }}" class="text-xs">
                Edit Profile
            </flux:button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Profile Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
                <div class="flex items-start space-x-6">
                    <!-- Avatar -->
                    <div class="flex-shrink-0">
                        @if($admin->avatar)
                            <img src="{{ Storage::url($admin->avatar) }}" alt="Avatar" class="h-24 w-24 rounded-full object-cover">
                        @else
                            <div class="h-24 w-24 rounded-full bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                                <span class="text-2xl font-bold text-white">{{ substr($admin->name, 0, 1) }}</span>
                            </div>
                        @endif
                    </div>

                    <!-- Profile Details -->
                    <div class="flex-1">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                                <p class="text-lg font-semibold text-gray-900">{{ $admin->name }}</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                                <p class="text-lg font-semibold text-gray-900">{{ $admin->email }}</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Phone</label>
                                <p class="text-sm text-gray-900">{{ $admin->phone ?? 'Not provided' }}</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Member Since</label>
                                <p class="text-sm text-gray-900">{{ $admin->created_at->format('M d, Y') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </flux:card>

            <!-- Contact Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Contact Information</flux:heading>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                        <p class="text-sm text-gray-900">{{ $admin->address ?? 'Not provided' }}</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">City</label>
                        <p class="text-sm text-gray-900">{{ $admin->city ?? 'Not provided' }}</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">State</label>
                        <p class="text-sm text-gray-900">{{ $admin->state ?? 'Not provided' }}</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Country</label>
                        <p class="text-sm text-gray-900">{{ $admin->country ?? 'Not provided' }}</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Postal Code</label>
                        <p class="text-sm text-gray-900">{{ $admin->postal_code ?? 'Not provided' }}</p>
                    </div>
                </div>
            </flux:card>

            <!-- Bio -->
            @if($admin->bio)
                <flux:card>
                    <flux:heading size="lg" class="mb-4">Bio</flux:heading>
                    <p class="text-sm text-gray-900">{{ $admin->bio }}</p>
                </flux:card>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Quick Actions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Quick Actions</flux:heading>
                <div class="space-y-3">
                    <flux:button icon="pencil" href="{{ route('admin.profile.edit') }}" class="w-full">
                        Edit Profile
                    </flux:button>
                </div>
            </flux:card>

            <!-- Roles & Permissions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Roles & Permissions</flux:heading>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Roles</label>
                        <div class="space-y-2">
                            @forelse($admin->roles as $role)
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    {{ ucfirst(str_replace('-', ' ', $role->name)) }}
                                </span>
                            @empty
                                <p class="text-sm text-gray-500">No roles assigned</p>
                            @endforelse
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Direct Permissions</label>
                        <div class="text-sm text-gray-500">
                            {{ $admin->permissions->count() }} permissions
                        </div>
                    </div>
                </div>
            </flux:card>

            <!-- Account Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Account Information</flux:heading>
                <div class="space-y-3">
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Status</span>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                            Active
                        </span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Last Login</span>
                        <span class="text-sm text-gray-900">{{ $admin->last_login_at ? $admin->last_login_at->format('M d, Y H:i') : 'Never' }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Email Verified</span>
                        <span class="text-sm text-gray-900">{{ $admin->email_verified_at ? 'Yes' : 'No' }}</span>
                    </div>
                </div>
            </flux:card>
        </div>
    </div>
</div>
@endsection
