@extends('components.layouts.admin')

@section('title', 'Edit Permission')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Edit Permission</h1>
            <p class="text-gray-600">Update permission information</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Permissions
            </flux:button>
            <flux:button href="{{ route('admin.permissions.show', $permission) }}" variant="outline" class="text-xs">
                <flux:icon name="eye" class="w-4 h-4 mr-2" />
                View Permission
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.permissions.update', $permission) }}" class="space-y-6">
        @csrf
        @method('PUT')
        
        <!-- Basic Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="name">Permission Name</flux:label>
                    <flux:input 
                        id="name" 
                        name="name" 
                        value="{{ old('name', $permission->name) }}"
                        placeholder="e.g., view-users, create-accounts, approve-transactions"
                        required
                    />
                    <flux:error name="name" />
                    <flux:description>Use lowercase with hyphens (e.g., view-users, create-accounts)</flux:description>
                </flux:field>

                <flux:field>
                    <flux:label for="guard_name">Guard Name</flux:label>
                    <flux:select id="guard_name" name="guard_name" required>
                        <option value="web" {{ old('guard_name', $permission->guard_name) === 'web' ? 'selected' : '' }}>Web</option>
                        <option value="api" {{ old('guard_name', $permission->guard_name) === 'api' ? 'selected' : '' }}>API</option>
                    </flux:select>
                    <flux:error name="guard_name" />
                    <flux:description>Authentication guard for this permission</flux:description>
                </flux:field>
            </div>
        </flux:card>

        <!-- Current Assignment Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Current Assignment Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Assigned to Roles</label>
                    @if($permission->roles->count() > 0)
                        <div class="space-y-2">
                            @foreach($permission->roles as $role)
                                <div class="flex items-center justify-between p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                    <div class="flex items-center">
                                        <flux:icon name="shield-check" class="w-5 h-5 text-blue-500 mr-3" />
                                        <div>
                                            <div class="text-sm font-medium text-gray-900">{{ ucfirst(str_replace('-', ' ', $role->name)) }}</div>
                                            <div class="text-xs text-gray-500">{{ $role->name }}</div>
                                        </div>
                                    </div>
                                    <span class="text-xs text-gray-500">{{ $role->users->count() }} users</span>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-4 text-gray-500">
                            <flux:icon name="shield-check" class="w-8 h-8 mx-auto mb-2 text-gray-300" />
                            <p class="text-sm">Not assigned to any roles</p>
                        </div>
                    @endif
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Total Users</label>
                    <div class="text-center py-4">
                        <div class="text-3xl font-bold text-gray-900">{{ $permission->users->count() }}</div>
                        <p class="text-sm text-gray-500">users have this permission</p>
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Permission Categories Reference -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Permission Categories Reference</flux:heading>
            <p class="text-sm text-gray-600 mb-4">Here are the common permission categories used in the system:</p>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($categories as $category)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <h4 class="text-sm font-medium text-gray-900 mb-2 capitalize">{{ str_replace('-', ' ', $category) }}</h4>
                        <div class="space-y-1 text-xs text-gray-600">
                            @php
                                $categoryPermissions = \Spatie\Permission\Models\Permission::where('name', 'like', $category . '-%')->take(3)->get();
                            @endphp
                            @foreach($categoryPermissions as $perm)
                                <div class="font-mono {{ $perm->id === $permission->id ? 'text-blue-600 font-semibold' : '' }}">{{ $perm->name }}</div>
                            @endforeach
                            @if($categoryPermissions->count() > 3)
                                <div class="text-gray-400">... and {{ \Spatie\Permission\Models\Permission::where('name', 'like', $category . '-%')->count() - 3 }} more</div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-end space-x-3">
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline">
                Cancel
            </flux:button>
            <flux:button icon="check" type="submit" class="text-xs">
                Update Permission
            </flux:button>
        </div>
    </form>
</div>
@endsection
