@extends('components.layouts.admin')

@section('title', 'Create Permission')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Create Permission</h1>
            <p class="text-gray-600">Create a new system permission</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Permissions
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.permissions.store') }}" class="space-y-6">
        @csrf
        
        <!-- Basic Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="name">Permission Name</flux:label>
                    <flux:input 
                        id="name" 
                        name="name" 
                        value="{{ old('name') }}"
                        placeholder="e.g., view-users, create-accounts, approve-transactions"
                        required
                    />
                    <flux:error name="name" />
                    <flux:description>Use lowercase with hyphens (e.g., view-users, create-accounts)</flux:description>
                </flux:field>

                <flux:field>
                    <flux:label for="guard_name">Guard Name</flux:label>
                    <flux:select id="guard_name" name="guard_name" required>
                        <option value="web" {{ old('guard_name', 'web') === 'web' ? 'selected' : '' }}>Web</option>
                        <option value="api" {{ old('guard_name') === 'api' ? 'selected' : '' }}>API</option>
                    </flux:select>
                    <flux:error name="guard_name" />
                    <flux:description>Authentication guard for this permission</flux:description>
                </flux:field>
            </div>
        </flux:card>

        <!-- Permission Categories Reference -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Permission Categories Reference</flux:heading>
            <p class="text-sm text-gray-600 mb-4">Here are the common permission categories used in the system:</p>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($categories as $category)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <h4 class="text-sm font-medium text-gray-900 mb-2 capitalize">{{ str_replace('-', ' ', $category) }}</h4>
                        <div class="space-y-1 text-xs text-gray-600">
                            @php
                                $categoryPermissions = \Spatie\Permission\Models\Permission::where('name', 'like', $category . '-%')->take(3)->get();
                            @endphp
                            @foreach($categoryPermissions as $permission)
                                <div class="font-mono">{{ $permission->name }}</div>
                            @endforeach
                            @if($categoryPermissions->count() > 3)
                                <div class="text-gray-400">... and {{ \Spatie\Permission\Models\Permission::where('name', 'like', $category . '-%')->count() - 3 }} more</div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-end space-x-3">
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline">
                Cancel
            </flux:button>
            <flux:button icon="check" type="submit" class="text-xs">
                Create Permission
            </flux:button>
        </div>
    </form>
</div>
@endsection
