@extends('components.layouts.admin')

@section('title', 'System Logs')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">System Logs</h1>
            <p class="text-gray-600">View and manage system log files</p>
        </div>
    </div>

    <!-- Log Files -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Log Files</flux:heading>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">File Name</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Size</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Last Modified</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($logFiles as $file)
                        <tr class="hover:bg-gray-50 {{ $selectedFile === $file['name'] ? 'bg-blue-50' : '' }}">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <flux:icon name="document-text" class="w-5 h-5 text-gray-400 mr-3" />
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $file['name'] }}</div>
                                        @if($selectedFile === $file['name'])
                                            <div class="text-xs text-blue-600">Currently viewing</div>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $file['size'] }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                {{ date('M d, Y H:i', $file['modified']) }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <div class="flex items-center justify-end space-x-2">
                                    <flux:button href="{{ route('admin.logs.show', $file['name']) }}" variant="outline" size="sm">
                                        <flux:icon name="eye" class="w-4 h-4" />
                                    </flux:button>
                                    <flux:button href="{{ route('admin.logs.download', $file['name']) }}" variant="outline" size="sm">
                                        <flux:icon name="arrow-down-tray" class="w-4 h-4" />
                                    </flux:button>
                                    <form method="POST" action="{{ route('admin.logs.clear', $file['name']) }}" class="inline" onsubmit="return confirm('Are you sure you want to clear this log file?')">
                                        @csrf
                                        @method('DELETE')
                                        <flux:button type="submit" variant="outline" size="sm" class="text-red-600 hover:text-red-700">
                                            <flux:icon name="trash" class="w-4 h-4" />
                                        </flux:button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                                <flux:icon name="document-text" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                                <p class="text-lg font-medium">No log files found</p>
                                <p class="text-sm">Log files will appear here as they are created.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </flux:card>

    <!-- Log Entries -->
    @if($selectedFile && $logs->count() > 0)
        <flux:card>
            <flux:heading size="lg" class="mb-4">Log Entries - {{ $selectedFile }}</flux:heading>
            
            <!-- Filters -->
            <div class="mb-4 p-4 bg-gray-50 rounded-lg">
                <form method="GET" class="flex flex-wrap gap-4 items-end">
                    <input type="hidden" name="file" value="{{ $selectedFile }}">
                    
                    <flux:field>
                        <flux:label>Search</flux:label>
                        <flux:input 
                            name="search" 
                            value="{{ request('search') }}"
                            placeholder="Search log entries..."
                        />
                    </flux:field>

                    <flux:field>
                        <flux:label>Level</flux:label>
                        <flux:select name="level">
                            <option value="">All Levels</option>
                            <option value="emergency" {{ request('level') === 'emergency' ? 'selected' : '' }}>Emergency</option>
                            <option value="alert" {{ request('level') === 'alert' ? 'selected' : '' }}>Alert</option>
                            <option value="critical" {{ request('level') === 'critical' ? 'selected' : '' }}>Critical</option>
                            <option value="error" {{ request('level') === 'error' ? 'selected' : '' }}>Error</option>
                            <option value="warning" {{ request('level') === 'warning' ? 'selected' : '' }}>Warning</option>
                            <option value="notice" {{ request('level') === 'notice' ? 'selected' : '' }}>Notice</option>
                            <option value="info" {{ request('level') === 'info' ? 'selected' : '' }}>Info</option>
                            <option value="debug" {{ request('level') === 'debug' ? 'selected' : '' }}>Debug</option>
                        </flux:select>
                    </flux:field>

                    <flux:button icon="magnifying-glass" type="submit" variant="outline" size="sm">
                        Filter
                    </flux:button>
                    
                    <flux:button icon="x-mark" href="{{ route('admin.logs.index', ['file' => $selectedFile]) }}" variant="outline" size="sm">
                        Clear
                    </flux:button>
                </form>
            </div>

            <!-- Log Entries -->
            <div class="space-y-2 max-h-96 overflow-y-auto">
                @foreach($logs as $log)
                    <div class="p-3 border border-gray-200 rounded-lg hover:bg-gray-50">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center space-x-2 mb-1">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                        @if($log['level'] === 'ERROR' || $log['level'] === 'CRITICAL' || $log['level'] === 'EMERGENCY') bg-red-100 text-red-800
                                        @elseif($log['level'] === 'WARNING' || $log['level'] === 'ALERT') bg-yellow-100 text-yellow-800
                                        @elseif($log['level'] === 'INFO' || $log['level'] === 'NOTICE') bg-blue-100 text-blue-800
                                        @else bg-gray-100 text-gray-800
                                        @endif">
                                        {{ $log['level'] }}
                                    </span>
                                    @if($log['timestamp'])
                                        <span class="text-xs text-gray-500">{{ $log['timestamp'] }}</span>
                                    @endif
                                    @if($log['environment'])
                                        <span class="text-xs text-gray-500">{{ $log['environment'] }}</span>
                                    @endif
                                </div>
                                <div class="text-sm text-gray-900 font-mono">{{ $log['message'] }}</div>
                            </div>
                            <div class="text-xs text-gray-400 ml-4">
                                Line {{ $log['line_number'] }}
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            @if($pagination && $pagination['last_page'] > 1)
                <div class="mt-4 flex items-center justify-between">
                    <div class="text-sm text-gray-700">
                        Showing {{ $pagination['from'] }} to {{ $pagination['to'] }} of {{ $pagination['total'] }} entries
                    </div>
                    <div class="flex space-x-2">
                        @if($pagination['current_page'] > 1)
                            <flux:button href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1]) }}" variant="outline" size="sm">
                                Previous
                            </flux:button>
                        @endif
                        
                        @if($pagination['has_more_pages'])
                            <flux:button href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1]) }}" variant="outline" size="sm">
                                Next
                            </flux:button>
                        @endif
                    </div>
                </div>
            @endif
        </flux:card>
    @endif
</div>
@endsection
