@extends('components.layouts.admin')

@section('title', 'KYC Statistics')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">KYC Statistics</h1>
                <p class="text-gray-600">Comprehensive overview of KYC documents and user verification status</p>
            </div>
            <div class="flex space-x-3">
                <flux:button icon="arrow-left" href="{{ route('admin.kyc.index') }}" variant="outline">
                    Back to KYC
                </flux:button>
            </div>
        </div>

        <!-- Document Statistics -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="document-text" class="w-5 h-5 text-blue-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Total Documents</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['total_documents']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="clock" class="w-5 h-5 text-yellow-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Pending Review</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['pending_documents']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="check-circle" class="w-5 h-5 text-green-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Approved</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['approved_documents']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="x-circle" class="w-5 h-5 text-red-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Rejected</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['rejected_documents']) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- User Verification Status -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="user-check" class="w-5 h-5 text-green-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">KYC Verified Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['kyc_verified_users']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="clock" class="w-5 h-5 text-yellow-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">KYC Pending Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['kyc_pending_users']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="user-x" class="w-5 h-5 text-red-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">KYC Rejected Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['kyc_rejected_users']) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- AML & Compliance Status -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="shield-check" class="w-5 h-5 text-green-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">AML Clear Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['aml_clear_users']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="exclamation-triangle" class="w-5 h-5 text-yellow-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">AML Flagged Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['aml_flagged_users']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="shield-exclamation" class="w-5 h-5 text-red-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">AML Blocked Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['aml_blocked_users']) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Compliance Status -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="check-circle" class="w-5 h-5 text-green-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Compliant Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['compliant_users']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="x-circle" class="w-5 h-5 text-red-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Non-Compliant Users</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['non_compliant_users']) }}</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                            <flux:icon name="clock" class="w-5 h-5 text-yellow-600" />
                        </div>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Pending Review</p>
                        <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['pending_review_users']) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Document Type Breakdown -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Document Type Breakdown</h3>
                <div class="space-y-3">
                    @foreach($documentTypeStats as $type => $count)
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full bg-blue-500 mr-3"></div>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ \App\Models\KycDocument::DOCUMENT_TYPES[$type] ?? $type }}
                                </span>
                            </div>
                            <div class="flex items-center">
                                <span class="text-sm text-gray-500 mr-2">{{ $count }}</span>
                                <div class="w-20 bg-gray-200 rounded-full h-2">
                                    <div class="bg-blue-500 h-2 rounded-full" style="width: {{ $stats['total_documents'] > 0 ? ($count / $stats['total_documents']) * 100 : 0 }}%"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Status Breakdown -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Document Status Breakdown</h3>
                <div class="space-y-3">
                    @foreach($statusStats as $status => $count)
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full {{ 
                                    $status === 'approved' ? 'bg-green-500' : 
                                    ($status === 'rejected' ? 'bg-red-500' : 
                                    ($status === 'expired' ? 'bg-gray-500' : 'bg-yellow-500')) 
                                }} mr-3"></div>
                                <span class="text-sm font-medium text-gray-900">
                                    {{ \App\Models\KycDocument::STATUSES[$status] ?? $status }}
                                </span>
                            </div>
                            <div class="flex items-center">
                                <span class="text-sm text-gray-500 mr-2">{{ $count }}</span>
                                <div class="w-20 bg-gray-200 rounded-full h-2">
                                    <div class="h-2 rounded-full {{ 
                                        $status === 'approved' ? 'bg-green-500' : 
                                        ($status === 'rejected' ? 'bg-red-500' : 
                                        ($status === 'expired' ? 'bg-gray-500' : 'bg-yellow-500')) 
                                    }}" style="width: {{ $stats['total_documents'] > 0 ? ($count / $stats['total_documents']) * 100 : 0 }}%"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl p-6 text-white">
                <div class="flex items-center">
                    <flux:icon name="chart-bar" class="w-8 h-8 mr-4" />
                    <div>
                        <h3 class="text-lg font-semibold">Document Processing Rate</h3>
                        <p class="text-2xl font-bold">
                            {{ $stats['total_documents'] > 0 ? round(($stats['approved_documents'] / $stats['total_documents']) * 100, 1) : 0 }}%
                        </p>
                        <p class="text-blue-100">Documents approved out of total</p>
                    </div>
                </div>
            </div>

            <div class="bg-gradient-to-r from-green-500 to-green-600 rounded-xl p-6 text-white">
                <div class="flex items-center">
                    <flux:icon name="user-check" class="w-8 h-8 mr-4" />
                    <div>
                        <h3 class="text-lg font-semibold">User Verification Rate</h3>
                        <p class="text-2xl font-bold">
                            {{ ($stats['kyc_verified_users'] + $stats['kyc_pending_users'] + $stats['kyc_rejected_users']) > 0 ? 
                               round(($stats['kyc_verified_users'] / ($stats['kyc_verified_users'] + $stats['kyc_pending_users'] + $stats['kyc_rejected_users'])) * 100, 1) : 0 }}%
                        </p>
                        <p class="text-green-100">Users with verified KYC</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
