@extends('components.layouts.admin')

@section('title', 'Deposit Details')

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Deposit Details</h1>
                <p class="text-gray-600">View and manage deposit information</p>
            </div>
            <div class="flex space-x-3">
                <flux:button icon="pencil" href="{{ route('admin.deposits.edit', $deposit) }}" variant="outline">
                    Edit Deposit
                </flux:button>
                <flux:button icon="arrow-left" href="{{ route('admin.deposits.index') }}" variant="outline">
                    Back to Deposits
                </flux:button>
            </div>
        </div>

        <!-- Deposit Actions -->
        @if($deposit->status === 'pending')
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <flux:icon name="exclamation-triangle" class="w-5 h-5 text-yellow-600 mr-2" />
                        <span class="text-yellow-800 font-medium">This deposit is pending approval</span>
                    </div>
                    <div class="flex space-x-2">
                        <form method="POST" action="{{ route('admin.deposits.approve', $deposit) }}" class="inline">
                            @csrf
                            <flux:button icon="check" type="submit" variant="primary" size="sm">
                                Approve
                            </flux:button>
                        </form>
                        <form method="POST" action="{{ route('admin.deposits.reject', $deposit) }}" class="inline">
                            @csrf
                            <flux:button icon="x-mark" type="submit" variant="outline" size="sm" class="text-red-600 hover:text-red-700">
                                Reject
                            </flux:button>
                        </form>
                    </div>
                </div>
            </div>
        @endif

        @if($deposit->status === 'completed')
            <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <flux:icon name="check-circle" class="w-5 h-5 text-green-600 mr-2" />
                        <span class="text-green-800 font-medium">This deposit has been completed</span>
                    </div>
                    <form method="POST" action="{{ route('admin.deposits.reverse', $deposit) }}" class="inline">
                        @csrf
                        <flux:button icon="arrow-uturn-left" type="submit" variant="outline" size="sm" class="text-purple-600 hover:text-purple-700">
                            Reverse Deposit
                        </flux:button>
                    </form>
                </div>
            </div>
        @endif

        <!-- Deposit Information -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Deposit Details -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Basic Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Deposit Information</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Transaction ID</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->transaction_id }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Reference Number</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->reference_number }}</dd>
                        </div>
                        @if($deposit->external_reference)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">External Reference</dt>
                                <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->external_reference }}</dd>
                            </div>
                        @endif
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Type</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    Deposit
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Deposit Type</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    {{ ucfirst(str_replace('_', ' ', $deposit->subcategory ?? 'N/A')) }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Payment Method</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                    {{ ucfirst(str_replace('_', ' ', $deposit->payment_method ?? 'N/A')) }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                    @if($deposit->status === 'completed') bg-green-100 text-green-800
                                    @elseif($deposit->status === 'pending') bg-yellow-100 text-yellow-800
                                    @elseif($deposit->status === 'processing') bg-blue-100 text-blue-800
                                    @elseif($deposit->status === 'failed') bg-red-100 text-red-800
                                    @elseif($deposit->status === 'cancelled') bg-gray-100 text-gray-800
                                    @elseif($deposit->status === 'reversed') bg-purple-100 text-purple-800
                                    @else bg-gray-100 text-gray-800
                                    @endif">
                                    {{ ucfirst($deposit->status) }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Verification Status</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                    @if($deposit->verification_status === 'verified') bg-green-100 text-green-800
                                    @elseif($deposit->verification_status === 'pending') bg-yellow-100 text-yellow-800
                                    @elseif($deposit->verification_status === 'rejected') bg-red-100 text-red-800
                                    @else bg-gray-100 text-gray-800
                                    @endif">
                                    {{ ucfirst($deposit->verification_status) }}
                                </span>
                            </dd>
                        </div>
                    </dl>
                </div>

                <!-- Financial Details -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Financial Information</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Amount</dt>
                            <dd class="mt-1 text-lg font-semibold text-gray-900">
                                {{ $deposit->currency }}{{ number_format($deposit->amount, 2) }}
                            </dd>
                        </div>
                        @if($deposit->exchange_rate)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Exchange Rate</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ number_format($deposit->exchange_rate, 4) }}</dd>
                            </div>
                        @endif
                        @if($deposit->converted_amount)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Converted Amount</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $deposit->currency }}{{ number_format($deposit->converted_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                        @if($deposit->fee_amount > 0)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Fee Amount</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $deposit->currency }}{{ number_format($deposit->fee_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                        @if($deposit->tax_amount > 0)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Tax Amount</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $deposit->currency }}{{ number_format($deposit->tax_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                        @if($deposit->net_amount)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Net Amount</dt>
                                <dd class="mt-1 text-sm font-semibold text-gray-900">
                                    {{ $deposit->currency }}{{ number_format($deposit->net_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                    </dl>
                </div>

                <!-- Account Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Information</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @if($deposit->toAccount)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">To Account</dt>
                                <dd class="mt-1">
                                    <div class="text-sm text-gray-900">{{ $deposit->toAccount->account_name }}</div>
                                    <div class="text-sm text-gray-500 font-mono">{{ $deposit->toAccount->account_number }}</div>
                                </dd>
                            </div>
                        @endif
                    </dl>
                </div>

                <!-- Deposit-Specific Details -->
                @if($deposit->metadata)
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Deposit Details</h3>
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            @if(isset($deposit->metadata['cheque_details']))
                                <div class="md:col-span-2">
                                    <h4 class="text-sm font-medium text-gray-700 mb-2">Cheque Information</h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Cheque Number</dt>
                                            <dd class="mt-1 text-sm text-gray-900">{{ $deposit->metadata['cheque_details']['cheque_number'] ?? 'N/A' }}</dd>
                                        </div>
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Bank Name</dt>
                                            <dd class="mt-1 text-sm text-gray-900">{{ $deposit->metadata['cheque_details']['bank_name'] ?? 'N/A' }}</dd>
                                        </div>
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Routing Number</dt>
                                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->metadata['cheque_details']['routing_number'] ?? 'N/A' }}</dd>
                                        </div>
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Account Number</dt>
                                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->metadata['cheque_details']['account_number'] ?? 'N/A' }}</dd>
                                        </div>
                                    </div>
                                    
                                    <!-- Cheque Images -->
                                    @if(isset($deposit->metadata['cheque_details']['front_image']) || isset($deposit->metadata['cheque_details']['back_image']))
                                        <div class="mt-6">
                                            <h5 class="text-sm font-medium text-gray-700 mb-3">Cheque Images</h5>
                                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                                @if(isset($deposit->metadata['cheque_details']['front_image']))
                                                    <div>
                                                        <dt class="text-sm font-medium text-gray-500 mb-2">Front Image</dt>
                                                        <div class="relative group">
                                                            <img 
                                                                src="{{  asset($deposit->metadata['cheque_details']['front_image']) }}" 
                                                                alt="Cheque Front" 
                                                                class="w-full h-48 object-cover rounded-lg border z-50 border-gray-200 cursor-pointer hover:shadow-lg transition-shadow"
                                                            />
                                                            <div class="absolute inset-0 bg-gray-900/50 group-hover:bg-opacity-20 transition-all duration-200 rounded-lg flex items-center justify-center"  onclick="openImageModal('{{  asset($deposit->metadata['cheque_details']['front_image']) }}', 'Cheque Front')">
                                                                <flux:icon name="eye" class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity" />
                                                            </div>
                                                        </div>
                                                        <a 
                                                            href="{{  asset($deposit->metadata['cheque_details']['front_image']) }}" 
                                                            target="_blank" 
                                                            class="text-xs text-blue-600 hover:text-blue-800 mt-1 inline-block"
                                                        >
                                                            View Full Size
                                                        </a>
                                                    </div>
                                                @endif
                                                
                                                @if(isset($deposit->metadata['cheque_details']['back_image']))
                                                    <div>
                                                        <dt class="text-sm font-medium text-gray-500 mb-2">Back Image</dt>
                                                        <div class="relative group">
                                                            <img 
                                                                src="{{  asset($deposit->metadata['cheque_details']['back_image']) }}" 
                                                                alt="Cheque Back" 
                                                                class="w-full h-48 object-cover rounded-lg border z-50 border-gray-200 cursor-pointer hover:shadow-lg transition-shadow"
                                                            />
                                                            <div class="absolute inset-0 bg-gray-900/50 group-hover:bg-opacity-20 transition-all duration-200 rounded-lg flex items-center justify-center"  onclick="openImageModal('{{  asset($deposit->metadata['cheque_details']['back_image']) }}', 'Cheque Back')">
                                                                <flux:icon name="eye" class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity" />
                                                            </div>
                                                        </div>
                                                        <a 
                                                            href="{{  asset($deposit->metadata['cheque_details']['back_image']) }}" 
                                                            target="_blank" 
                                                            class="text-xs text-blue-600 hover:text-blue-800 mt-1 inline-block"
                                                        >
                                                            View Full Size
                                                        </a>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif

                            @if(isset($deposit->metadata['card_details']))
                                <div class="md:col-span-2">
                                    <h4 class="text-sm font-medium text-gray-700 mb-2">Card Information</h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Card Last Four</dt>
                                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->metadata['card_details']['card_last_four'] ?? 'N/A' }}</dd>
                                        </div>
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Card Type</dt>
                                            <dd class="mt-1 text-sm text-gray-900">{{ $deposit->metadata['card_details']['card_type'] ?? 'N/A' }}</dd>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if(isset($deposit->metadata['wire_details']))
                                <div class="md:col-span-2">
                                    <h4 class="text-sm font-medium text-gray-700 mb-2">Wire Information</h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Wire Reference</dt>
                                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->metadata['wire_details']['wire_reference'] ?? 'N/A' }}</dd>
                                        </div>
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500">Wire Instructions</dt>
                                            <dd class="mt-1 text-sm text-gray-900">{{ $deposit->metadata['wire_details']['wire_instructions'] ?? 'N/A' }}</dd>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </dl>
                    </div>
                @endif

                <!-- Description and Notes -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Description & Notes</h3>
                    <div class="space-y-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Description</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $deposit->description }}</dd>
                        </div>
                        @if($deposit->notes)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Notes</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $deposit->notes }}</dd>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- User Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">User Information</h3>
                    <div class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Name</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $deposit->user->name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Email</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $deposit->user->email }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Customer ID</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->user->customer_id }}</dd>
                        </div>
                    </div>
                </div>

                <!-- Timestamps -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Timeline</h3>
                    <div class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Created</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $deposit->created_at->format('M d, Y g:i A') }}
                            </dd>
                        </div>
                        @if($deposit->processed_at)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Processed</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $deposit->processed_at->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                        @if($deposit->completed_at)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Completed</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $deposit->completed_at->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                        @if($deposit->reversed_at)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reversed</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $deposit->reversed_at->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Last Updated</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $deposit->updated_at->format('M d, Y g:i A') }}
                            </dd>
                        </div>
                    </div>
                </div>

                <!-- Technical Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Technical Details</h3>
                    <div class="space-y-3">
                        @if($deposit->ip_address)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">IP Address</dt>
                                <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $deposit->ip_address }}</dd>
                            </div>
                        @endif
                        @if($deposit->reversal_reason)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reversal Reason</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $deposit->reversal_reason }}</dd>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Image Modal -->
    <div id="imageModal" class="fixed inset-0 bg-black bg-opacity-75 z-50 hidden" onclick="closeImageModal()">
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="relative max-w-4xl max-h-full" onclick="event.stopPropagation()">
                <button 
                    onclick="closeImageModal()" 
                    class="absolute -top-10 right-0 text-white hover:text-gray-300 transition-colors"
                >
                    <flux:icon name="x-mark" class="w-8 h-8" />
                </button>
                <img id="modalImage" src="" alt="" class="max-w-full max-h-full rounded-lg shadow-2xl" />
                <div class="mt-2 text-center">
                    <p id="modalImageTitle" class="text-white text-lg font-medium"></p>
                </div>
            </div>
        </div>
    </div>

    <script>
        function openImageModal(imageSrc, imageTitle) {
            document.getElementById('modalImage').src = imageSrc;
            document.getElementById('modalImageTitle').textContent = imageTitle;
            document.getElementById('imageModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeImageModal() {
            document.getElementById('imageModal').classList.add('hidden');
            document.body.style.overflow = 'auto';
        }

        // Close modal on Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                closeImageModal();
            }
        });
    </script>
@endsection
