@extends('components.layouts.admin')

@section('title', 'Admin Dashboard')

@section('content')
<div class="min-h-screen bg-gray-50 p-2">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Admin Dashboard
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Manage your banking system</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            <flux:button variant="primary" href="{{ route('admin.users.create') }}" class="flex items-center gap-1 px-2.5 py-1 text-xs">
                <flux:icon name="plus" class="w-3 h-3" />
                Add User
            </flux:button>
            <flux:button variant="filled" href="{{ route('admin.accounts.create') }}" class="bg-green-600 hover:bg-green-700 flex items-center gap-1 px-2.5 py-1 text-xs">
                <flux:icon name="credit-card" class="w-3 h-3" />
                Create Account
            </flux:button>
        </div>
    </div>

    <!-- Welcome Card -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-lg font-bold text-gray-900">
                    Welcome back, {{ auth()->user()->name }}!
                </h2>
                <p class="text-sm text-gray-600 mt-1">
                    You are logged in as: <span class="font-semibold text-[#04327c]">{{ auth()->user()->roles->first()->name ?? 'No Role' }}</span>
                </p>
            </div>
            <div class="hidden sm:block">
                <div class="text-right">
                    <p class="text-xs text-gray-500">Date/Time</p>
                    <p class="text-sm font-medium text-gray-900">
                       {{ now()->format('M j, Y g:i A') }} UTC
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <!-- Total Users -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="users" class="w-4 h-4 text-blue-600" />
                </div>
                @if(isset($growthStats['user_growth']))
                <div class="text-right">
                    <span class="text-xs {{ $growthStats['user_growth'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        {{ $growthStats['user_growth'] >= 0 ? '+' : '' }}{{ $growthStats['user_growth'] }}%
                    </span>
                </div>
                @endif
            </div>
            <p class="text-gray-600 text-xs mb-1">Total Users</p>
            <p class="text-lg font-bold text-gray-900 mb-1">{{ number_format($stats['total_users']) }}</p>
            <p class="text-xs text-gray-500">{{ $stats['active_users'] }} active, {{ $stats['pending_users'] }} pending</p>
        </div>

        <!-- Active Accounts -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="credit-card" class="w-4 h-4 text-green-600" />
                </div>
                @if(isset($growthStats['account_growth']))
                <div class="text-right">
                    <span class="text-xs {{ $growthStats['account_growth'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        {{ $growthStats['account_growth'] >= 0 ? '+' : '' }}{{ $growthStats['account_growth'] }}%
                    </span>
                </div>
                @endif
            </div>
            <p class="text-gray-600 text-xs mb-1">Active Accounts</p>
            <p class="text-lg font-bold text-gray-900 mb-1">{{ number_format($stats['active_accounts']) }}</p>
            <p class="text-xs text-gray-500">{{ $stats['pending_accounts'] }} pending approval</p>
        </div>

        <!-- Pending Transactions -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="clock" class="w-4 h-4 text-yellow-600" />
                </div>
                @if(isset($growthStats['transaction_growth']))
                <div class="text-right">
                    <span class="text-xs {{ $growthStats['transaction_growth'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        {{ $growthStats['transaction_growth'] >= 0 ? '+' : '' }}{{ $growthStats['transaction_growth'] }}%
                    </span>
                </div>
                @endif
            </div>
            <p class="text-gray-600 text-xs mb-1">Pending Transactions</p>
            <p class="text-lg font-bold text-gray-900 mb-1">{{ number_format($stats['pending_transactions']) }}</p>
            <p class="text-xs text-gray-500">{{ $stats['completed_transactions'] }} completed today</p>
        </div>

        <!-- KYC Pending -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="identification" class="w-4 h-4 text-purple-600" />
                </div>
                <div class="text-right">
                    <span class="text-xs text-gray-600">{{ $stats['kyc_approved'] }} approved</span>
                </div>
            </div>
            <p class="text-gray-600 text-xs mb-1">KYC Pending</p>
            <p class="text-lg font-bold text-gray-900 mb-1">{{ number_format($stats['kyc_pending']) }}</p>
            <p class="text-xs text-gray-500">Verification needed</p>
        </div>
    </div>

    <!-- Financial Overview -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <!-- Total Balance -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-emerald-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="banknotes" class="w-4 h-4 text-emerald-600" />
                </div>
            </div>
            <p class="text-gray-600 text-xs mb-1">Total Balance</p>
            <p class="text-lg font-bold text-gray-900 mb-1">${{ number_format($financialStats['total_balance'], 2) }}</p>
            <p class="text-xs text-gray-500">${{ number_format($financialStats['total_available_balance'], 2) }} available</p>
        </div>

        <!-- Today's Volume -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-indigo-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="arrow-right-left" class="w-4 h-4 text-indigo-600" />
                </div>
            </div>
            <p class="text-gray-600 text-xs mb-1">Today's Volume</p>
            <p class="text-lg font-bold text-gray-900 mb-1">${{ number_format($financialStats['today_transactions_volume'], 2) }}</p>
            <p class="text-xs text-gray-500">This month: ${{ number_format($financialStats['this_month_transactions_volume'], 2) }}</p>
        </div>

        <!-- Compliance Flags -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="exclamation-triangle" class="w-4 h-4 text-red-600" />
                </div>
            </div>
            <p class="text-gray-600 text-xs mb-1">Compliance Flags</p>
            <p class="text-lg font-bold text-gray-900 mb-1">{{ number_format($stats['compliance_flags']) }}</p>
            <p class="text-xs text-gray-500">Require review</p>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
        <h2 class="text-sm font-semibold text-gray-900 mb-3">Quick Actions</h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3">
            <a href="{{ route('admin.users.create') }}" class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                    <flux:icon name="plus" class="w-4 h-4 text-blue-600" />
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-900">Add User</p>
                    <p class="text-xs text-gray-500">Create new user account</p>
                </div>
            </a>

            <a href="{{ route('admin.accounts.create') }}" class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                    <flux:icon name="credit-card" class="w-4 h-4 text-green-600" />
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-900">Create Account</p>
                    <p class="text-xs text-gray-500">Open new bank account</p>
                </div>
            </a>

            <a href="{{ route('admin.kyc.index') }}" class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                    <flux:icon name="check-circle" class="w-4 h-4 text-purple-600" />
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-900">Review KYC</p>
                    <p class="text-xs text-gray-500">Verify customer documents</p>
                </div>
            </a>

            <a href="{{ route('admin.reports.index') }}" class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                <div class="w-8 h-8 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                    <flux:icon name="chart-bar" class="w-4 h-4 text-orange-600" />
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-900">Generate Report</p>
                    <p class="text-xs text-gray-500">Create system reports</p>
                </div>
            </a>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
        <div class="flex items-center justify-between mb-3">
            <h2 class="text-sm font-semibold text-gray-900">Recent Activity</h2>
            <a href="{{ route('admin.transactions.index') }}" class="text-xs text-[#04327c] hover:text-[#032a6a]">View all</a>
        </div>
        <div class="space-y-3">
            @forelse($recentActivity as $activity)
            <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                <div class="w-8 h-8 bg-{{ $activity['icon_color'] }}-100 rounded-full flex items-center justify-center mr-3">
                    <flux:icon name="{{ $activity['icon'] }}" class="w-4 h-4 text-{{ $activity['icon_color'] }}-600" />
                </div>
                <div class="flex-1">
                    <p class="text-sm font-medium text-gray-900">{{ $activity['title'] }}</p>
                    <p class="text-xs text-gray-500">{{ $activity['description'] }}</p>
                </div>
                <div class="text-xs text-gray-500">{{ $activity['time']->diffForHumans() }}</div>
            </div>
            @empty
            <div class="flex items-center justify-center p-8 text-gray-500">
                <div class="text-center">
                    <flux:icon name="inbox" class="w-8 h-8 mx-auto mb-2 text-gray-400" />
                    <p class="text-sm">No recent activity</p>
                </div>
            </div>
            @endforelse
        </div>
    </div>
</div>
@endsection
