@extends('components.layouts.admin')

@section('title', 'Credit/Debit Management')

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Credit/Debit Management</h1>
                <p class="text-gray-600">Manage account credits and debits with optional transaction records</p>
            </div>
        </div>

        <!-- Accounts Table -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Account
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                User
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Balance
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Status
                            </th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($accounts as $account)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div>
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ $account->account_name }}
                                            </div>
                                            <div class="text-sm text-gray-500">
                                                {{ $account->account_number }}
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">
                                        {{ $account->user->first_name }} {{ $account->user->last_name }}
                                    </div>
                                    <div class="text-sm text-gray-500">
                                        {{ $account->user->email }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ $account->currency_symbol }}{{ number_format($account->balance, 2) }}
                                    </div>
                                    <div class="text-sm text-gray-500">
                                        Available: {{ $account->currency_symbol }}{{ number_format($account->available_balance, 2) }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $account->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $account->account_status_label }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <flux:modal.trigger name="credit-debit-modal-{{ $account->id }}">
                                        <flux:button 
                                            variant="outline" 
                                            size="sm"
                                        >
                                            Credit/Debit
                                        </flux:button>
                                    </flux:modal.trigger>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center">
                                    <div class="text-gray-500">
                                        <flux:icon name="credit-card" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                                        <p class="text-lg font-medium">No accounts found</p>
                                        <p class="text-sm">No active accounts available for credit/debit operations.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($accounts->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $accounts->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Credit/Debit Modals -->
    @foreach($accounts as $account)
        <flux:modal name="credit-debit-modal-{{ $account->id }}" title="Credit/Debit Account" class="md:w-128">
            <div class="space-y-6">
                <!-- Account Info -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="text-lg font-medium text-gray-900">{{ $account->account_name }}</h3>
                    <p class="text-sm text-gray-600">Account: {{ $account->account_number }}</p>
                    <p class="text-sm text-gray-600">Current Balance: {{ $account->currency_symbol }}{{ number_format($account->balance, 2) }}</p>
                </div>

                <!-- Transaction Form -->
                <form method="POST" action="{{ route('admin.credit-debit.transaction', $account) }}" class="space-y-4">
                    @csrf
                    
                    <!-- Transaction Type -->
                    <flux:field>
                        <flux:label>Transaction Type</flux:label>
                        <flux:select name="type" required>
                            <option value="">Select Type</option>
                            <option value="credit">Credit (Add Money)</option>
                            <option value="debit">Debit (Remove Money)</option>
                        </flux:select>
                    </flux:field>

                    <!-- Amount -->
                    <flux:field>
                        <flux:label>Amount ({{ $account->currency }})</flux:label>
                        <flux:input 
                            type="number" 
                            name="amount" 
                            step="0.01" 
                            min="0.01" 
                            placeholder="0.00"
                            required
                        />
                    </flux:field>

                    <!-- Create Transaction Checkbox -->
                    <flux:field>
                        <flux:checkbox 
                            name="create_transaction" 
                            value="1"
                        />
                        <flux:label>Create Transaction Record</flux:label>
                        <flux:description>Check this to create a formal transaction record in the system</flux:description>
                    </flux:field>

                    <!-- Submit Buttons -->
                    <div class="flex justify-end space-x-3 pt-4">
                        <flux:button type="button" variant="outline" @click="$dispatch('close-modal', 'credit-debit-modal-{{ $account->id }}')">
                            Cancel
                        </flux:button>
                        <flux:button type="submit" variant="primary">
                            Process Transaction
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endforeach
@endsection
