@extends('components.layouts.admin')

@section('title', 'Edit Compliance Log')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Edit Compliance Log</h1>
            <p class="text-gray-600">Update compliance log #{{ $compliance->id }}</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.compliance.show', $compliance) }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Details
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.compliance.update', $compliance) }}" class="space-y-6">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Basic Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
                <div class="space-y-4">
                    <!-- Status -->
                    <div>
                        <flux:label for="status">Status</flux:label>
                        <flux:select id="status" name="status">
                            @foreach(['pending', 'under_review', 'approved', 'rejected', 'escalated'] as $status)
                                <option value="{{ $status }}" {{ old('status', $compliance->status) == $status ? 'selected' : '' }}>
                                    {{ ucfirst(str_replace('_', ' ', $status)) }}
                                </option>
                            @endforeach
                        </flux:select>
                        @error('status')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Admin Notes -->
                    <div>
                        <flux:label for="admin_notes">Admin Notes</flux:label>
                        <flux:textarea 
                            id="admin_notes" 
                            name="admin_notes" 
                            rows="4"
                            placeholder="Enter admin notes..."
                        >{{ old('admin_notes', $compliance->admin_notes) }}</flux:textarea>
                        @error('admin_notes')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Resolution Notes -->
                    <div>
                        <flux:label for="resolution_notes">Resolution Notes</flux:label>
                        <flux:textarea 
                            id="resolution_notes" 
                            name="resolution_notes" 
                            rows="4"
                            placeholder="Enter resolution notes..."
                        >{{ old('resolution_notes', $compliance->resolution_notes) }}</flux:textarea>
                        @error('resolution_notes')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Resolution Status -->
                    <div>
                        <flux:label for="resolution_status">Resolution Status</flux:label>
                        <flux:select id="resolution_status" name="resolution_status">
                            <option value="">Select Resolution Status</option>
                            @foreach(['resolved', 'false_positive', 'requires_action'] as $status)
                                <option value="{{ $status }}" {{ old('resolution_status', $compliance->resolution_status) == $status ? 'selected' : '' }}>
                                    {{ ucfirst(str_replace('_', ' ', $status)) }}
                                </option>
                            @endforeach
                        </flux:select>
                        @error('resolution_status')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </flux:card>

            <!-- Log Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Log Information</flux:heading>
                <div class="space-y-4">
                    <!-- Type -->
                    <div>
                        <flux:label>Type</flux:label>
                        <div class="mt-1 text-sm text-gray-900">{{ $compliance->type_label }}</div>
                    </div>

                    <!-- Category -->
                    <div>
                        <flux:label>Category</flux:label>
                        <div class="mt-1 text-sm text-gray-900">{{ $compliance->category_label }}</div>
                    </div>

                    <!-- Severity -->
                    <div>
                        <flux:label>Severity</flux:label>
                        <div class="mt-1">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $compliance->severity_color }}">
                                {{ ucfirst($compliance->severity) }}
                            </span>
                        </div>
                    </div>

                    <!-- Description -->
                    <div>
                        <flux:label>Description</flux:label>
                        <div class="mt-1 text-sm text-gray-900">{{ $compliance->description }}</div>
                    </div>

                    <!-- Created At -->
                    <div>
                        <flux:label>Created</flux:label>
                        <div class="mt-1 text-sm text-gray-900">{{ $compliance->created_at->format('M j, Y g:i A') }}</div>
                    </div>

                    <!-- Last Updated -->
                    <div>
                        <flux:label>Last Updated</flux:label>
                        <div class="mt-1 text-sm text-gray-900">{{ $compliance->updated_at->format('M j, Y g:i A') }}</div>
                    </div>
                </div>
            </flux:card>
        </div>

        <!-- Related Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Related Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- User -->
                @if($compliance->user)
                    <div>
                        <flux:label>User</flux:label>
                        <div class="mt-1">
                            <div class="text-sm font-medium text-gray-900">{{ $compliance->user->name }}</div>
                            <div class="text-sm text-gray-500">{{ $compliance->user->email }}</div>
                        </div>
                    </div>
                @endif

                <!-- Account -->
                @if($compliance->account)
                    <div>
                        <flux:label>Account</flux:label>
                        <div class="mt-1">
                            <div class="text-sm font-medium text-gray-900">{{ $compliance->account->account_number }}</div>
                            <div class="text-sm text-gray-500">{{ ucfirst($compliance->account->account_type) }}</div>
                        </div>
                    </div>
                @endif

                <!-- Transaction -->
                @if($compliance->transaction)
                    <div>
                        <flux:label>Transaction</flux:label>
                        <div class="mt-1">
                            <div class="text-sm font-medium text-gray-900">{{ $compliance->transaction->reference_number }}</div>
                            <div class="text-sm text-gray-500">{{ ucfirst($compliance->transaction->type) }}</div>
                        </div>
                    </div>
                @endif

                <!-- KYC Document -->
                @if($compliance->kycDocument)
                    <div>
                        <flux:label>KYC Document</flux:label>
                        <div class="mt-1">
                            <div class="text-sm font-medium text-gray-900">{{ ucfirst(str_replace('_', ' ', $compliance->kycDocument->document_type)) }}</div>
                            <div class="text-sm text-gray-500">{{ ucfirst($compliance->kycDocument->status) }}</div>
                        </div>
                    </div>
                @endif
            </div>
        </flux:card>

        <!-- Risk Factors -->
        @if($compliance->risk_factors && count($compliance->risk_factors) > 0)
            <flux:card>
                <flux:heading size="lg" class="mb-4">Risk Factors</flux:heading>
                <div class="flex flex-wrap gap-2">
                    @foreach($compliance->risk_factors as $factor)
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                            {{ ucfirst(str_replace('_', ' ', $factor)) }}
                        </span>
                    @endforeach
                </div>
            </flux:card>
        @endif

        <!-- Details -->
        @if($compliance->details)
            <flux:card>
                <flux:heading size="lg" class="mb-4">Additional Details</flux:heading>
                <div class="bg-gray-50 rounded-lg p-4">
                    <pre class="text-sm text-gray-900 whitespace-pre-wrap">{{ json_encode($compliance->details, JSON_PRETTY_PRINT) }}</pre>
                </div>
            </flux:card>
        @endif

        <!-- Actions -->
        <div class="flex justify-end space-x-3">
            <flux:button href="{{ route('admin.compliance.show', $compliance) }}" variant="outline">
                Cancel
            </flux:button>
            <flux:button icon="check" type="submit" variant="primary" class="text-xs">
                Update Compliance Log
            </flux:button>
        </div>
    </form>
</div>
@endsection
