<x-layouts.admin-auth>
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
        <!-- Logo -->
        <div class="px-4 py-3 text-center border-b border-gray-100">
            <div class="flex items-center justify-center">
                <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-12 w-auto">
            </div>
        </div>
        
        <!-- Login Form -->
        <div class="px-4 py-4">
            <div class="text-left mb-4">
                <h2 class="text-base font-bold text-gray-900 mb-0.5 relative">
                    Admin Login
                    <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
                </h2>
                <p class="text-xs text-gray-600 mt-1.5">Access the admin dashboard</p>
            </div>

            <form action="{{ route('admin.login.post') }}" method="POST" class="space-y-3">
                @csrf
                
                <!-- Email -->
                <div>
                    <flux:input
                        name="email"
                        :label="__('Email Address')"
                        type="email"
                        required
                        autofocus
                        autocomplete="username"
                        placeholder="Enter your admin email"
                        class="w-full text-sm"
                        icon:leading="user"
                        value="{{ old('email') }}"
                    />
                    @error('email')
                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div class="relative">
                    <flux:input
                        name="password"
                        :label="__('Password')"
                        type="password"
                        required
                        autocomplete="current-password"
                        placeholder="Enter your password"
                        viewable
                        class="w-full text-sm"
                        icon:leading="finger-print"
                    />
                    @error('password')
                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Remember Me -->
                <div class="flex items-center justify-between">
                    <flux:checkbox name="remember" :label="__('Remember me')" class="text-sm" />
                </div>

                <!-- Action Buttons -->
                <div class="flex space-x-2 pt-3">
                    <flux:button variant="primary" type="submit" class="flex-1 cursor-pointer px-4 py-2 text-sm">
                        {{ __('Login') }}
                    </flux:button>
                    <flux:link href="{{ route('dashboard') }}" class="flex-1">
                        <flux:button variant="filled" type="button" class="w-full cursor-pointer px-4 py-2 text-sm">
                            {{ __('Customer Portal') }}
                        </flux:button>
                    </flux:link>
                </div>
            </form>

            <!-- Admin Notice -->
            <div class="mt-4 pt-3 border-t border-gray-100">
                <div class="text-center">
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
                        <div class="flex items-center justify-center">
                            <flux:icon name="shield-check" class="w-4 h-4 text-blue-600 mr-2" />
                            <p class="text-xs text-blue-700">Admin access only. Authorized personnel only.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Error Display -->
        @if ($errors->any())
            <div class="px-4 pb-4">
                @foreach ($errors->all() as $error)
                    <div class="bg-red-50 border border-red-200 rounded-lg p-3 mb-2">
                        <div class="flex items-center">
                            <flux:icon name="exclamation-circle" class="w-5 h-5 text-red-600 mr-2" />
                            <p class="text-sm text-red-700">{{ $error }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</x-layouts.admin-auth>