@extends('components.layouts.admin')

@section('title', 'User Analytics')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">User Analytics</h1>
            <p class="text-gray-600">User growth, activity patterns, and demographic insights</p>
        </div>
        <div class="flex space-x-3">
            <flux:select id="period-select" onchange="updatePeriod(this.value)">
                <option value="7d" {{ $period === '7d' ? 'selected' : '' }}>Last 7 Days</option>
                <option value="30d" {{ $period === '30d' ? 'selected' : '' }}>Last 30 Days</option>
                <option value="90d" {{ $period === '90d' ? 'selected' : '' }}>Last 90 Days</option>
                <option value="1y" {{ $period === '1y' ? 'selected' : '' }}>Last Year</option>
            </flux:select>
            <flux:button href="{{ route('admin.analytics.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Analytics
            </flux:button>
        </div>
    </div>

    <!-- User Activity Summary -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="users" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Users</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($userActivity['total_users']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Active Users</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($userActivity['active_users']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="user-plus" class="w-8 h-8 text-purple-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">New Users</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($userActivity['new_users']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="chart-line" class="w-8 h-8 text-orange-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Growth Rate</p>
                    <p class="text-2xl font-semibold {{ $userActivity['user_growth_rate'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        {{ $userActivity['user_growth_rate'] >= 0 ? '+' : '' }}{{ $userActivity['user_growth_rate'] }}%
                    </p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- User Growth Chart -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">User Growth Trend</flux:heading>
            @if($userGrowth->count() > 0)
                <div class="space-y-3">
                    @foreach($userGrowth as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ \Carbon\Carbon::parse($data->date)->format('M j, Y') }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ ($data->count / $userGrowth->max('count')) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $data->count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No user growth data available for the selected period.</p>
            @endif
        </flux:card>

        <!-- User Activity Metrics -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Activity Metrics</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Login Activity</span>
                    <span class="text-lg font-semibold text-gray-900">{{ number_format($userActivity['login_activity']) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">User Retention</span>
                    <span class="text-lg font-semibold text-gray-900">{{ $userActivity['user_retention'] }}%</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Active Rate</span>
                    <span class="text-lg font-semibold text-gray-900">
                        {{ $userActivity['total_users'] > 0 ? number_format(($userActivity['active_users'] / $userActivity['total_users']) * 100, 1) : 0 }}%
                    </span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">New User Rate</span>
                    <span class="text-lg font-semibold text-gray-900">
                        {{ $userActivity['total_users'] > 0 ? number_format(($userActivity['new_users'] / $userActivity['total_users']) * 100, 1) : 0 }}%
                    </span>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Demographics Analysis -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Customer Type Distribution -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Customer Type Distribution</flux:heading>
            @if($userDemographics['by_customer_type']->count() > 0)
                <div class="space-y-3">
                    @foreach($userDemographics['by_customer_type'] as $type => $count)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst(str_replace('_', ' ', $type)) }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ ($count / $userDemographics['by_customer_type']->sum()) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No customer type data available.</p>
            @endif
        </flux:card>

        <!-- Customer Status Distribution -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Customer Status Distribution</flux:heading>
            @if($userDemographics['by_customer_status']->count() > 0)
                <div class="space-y-3">
                    @foreach($userDemographics['by_customer_status'] as $status => $count)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst(str_replace('_', ' ', $status)) }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="h-2 rounded-full {{ 
                                        $status === 'active' ? 'bg-green-600' : 
                                        ($status === 'inactive' ? 'bg-red-600' : 
                                        ($status === 'suspended' ? 'bg-yellow-600' : 'bg-gray-600')) 
                                    }}" style="width: {{ ($count / $userDemographics['by_customer_status']->sum()) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No customer status data available.</p>
            @endif
        </flux:card>
    </div>

    <!-- KYC Status and Geographic Distribution -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- KYC Status Distribution -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">KYC Status Distribution</flux:heading>
            @if($userDemographics['by_kyc_status']->count() > 0)
                <div class="space-y-3">
                    @foreach($userDemographics['by_kyc_status'] as $status => $count)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst(str_replace('_', ' ', $status)) }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="h-2 rounded-full {{ 
                                        $status === 'verified' ? 'bg-green-600' : 
                                        ($status === 'pending' ? 'bg-yellow-600' : 
                                        ($status === 'rejected' ? 'bg-red-600' : 'bg-blue-600')) 
                                    }}" style="width: {{ ($count / $userDemographics['by_kyc_status']->sum()) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No KYC status data available.</p>
            @endif
        </flux:card>

        <!-- Top Countries -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Top Countries</flux:heading>
            @if($userDemographics['by_country']->count() > 0)
                <div class="space-y-3">
                    @foreach($userDemographics['by_country'] as $country => $count)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">{{ $country }}</span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-purple-600 h-2 rounded-full" style="width: {{ ($count / $userDemographics['by_country']->max()) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No country data available.</p>
            @endif
        </flux:card>
    </div>

    <!-- Age Group Distribution -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Age Group Distribution</flux:heading>
        @if($userDemographics['by_age_group']->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                @foreach($userDemographics['by_age_group'] as $ageGroup => $count)
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <div class="text-2xl font-bold text-gray-900">{{ $count }}</div>
                        <div class="text-sm text-gray-500">{{ $ageGroup }}</div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500">No age group data available.</p>
        @endif
    </flux:card>
</div>

<script>
function updatePeriod(period) {
    const url = new URL(window.location);
    url.searchParams.set('period', period);
    window.location.href = url.toString();
}
</script>
@endsection
